/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.resource;

import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.mtr.core.data.TransportMode;
import org.mtr.core.serializer.ReaderBase;
import org.mtr.core.tool.Utilities;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArraySet;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectCollection;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectImmutableList;
import org.mtr.mapping.holder.Box;
import org.mtr.mapping.holder.MutableText;
import org.mtr.mapping.holder.Vector3d;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.TextHelper;
import org.mtr.mod.client.CustomResourceLoader;
import org.mtr.mod.data.VehicleExtension;
import org.mtr.mod.generated.resource.VehicleResourceSchema;
import org.mtr.mod.render.DynamicVehicleModel;
import org.mtr.mod.render.MainRenderer;
import org.mtr.mod.render.QueuedRenderLayer;
import org.mtr.mod.render.StoredMatrixTransformations;
import org.mtr.mod.resource.CustomResourceTools;
import org.mtr.mod.resource.OptimizedModelWrapper;
import org.mtr.mod.resource.PartCondition;
import org.mtr.mod.resource.VehicleModel;
import org.mtr.mod.sound.BveVehicleSound;
import org.mtr.mod.sound.BveVehicleSoundConfig;
import org.mtr.mod.sound.LegacyVehicleSound;
import org.mtr.mod.sound.VehicleSoundBase;

public final class VehicleResource
extends VehicleResourceSchema {
    public final ObjectImmutableList<Box> floors;
    public final ObjectImmutableList<Box> doorways;
    public final Supplier<VehicleSoundBase> createVehicleSoundBase;
    private final Object2ObjectOpenHashMap<PartCondition, OptimizedModelWrapper> optimizedModels;
    private final Object2ObjectOpenHashMap<PartCondition, OptimizedModelWrapper> optimizedModelsDoorsClosed;
    private final Object2ObjectOpenHashMap<PartCondition, OptimizedModelWrapper> optimizedModelsBogie1;
    private final Object2ObjectOpenHashMap<PartCondition, OptimizedModelWrapper> optimizedModelsBogie2;
    private static final boolean[][] CHRISTMAS_LIGHT_STAGES = new boolean[][]{{true, false, false, false}, {false, true, false, false}, {false, false, true, false}, {false, false, false, true}, {true, false, false, false}, {false, true, false, false}, {false, false, true, false}, {false, false, false, true}, {true, true, false, false}, {false, true, true, false}, {false, false, true, true}, {true, false, false, true}, {true, true, false, false}, {false, true, true, false}, {false, false, true, true}, {true, false, false, true}, {true, false, true, false}, {false, true, false, true}, {true, false, true, false}, {false, true, false, true}, {true, false, true, false}, {false, true, false, true}, {true, false, true, false}, {false, true, false, true}, {true, false, false, false}, {true, true, false, false}, {true, true, true, false}, {true, true, true, true}, {false, true, false, false}, {false, true, true, false}, {false, true, true, true}, {true, true, true, true}, {false, false, true, false}, {false, false, true, true}, {true, false, true, true}, {true, true, true, true}, {false, false, false, true}, {true, false, false, true}, {true, true, false, true}, {true, true, true, true}, {false, false, false, false}, {true, true, true, true}, {true, true, true, true}, {true, true, true, true}, {false, false, false, false}, {true, true, true, true}, {true, true, true, true}, {true, true, true, true}};

    public VehicleResource(ReaderBase readerBase, @Nullable ObjectArrayList<VehicleModel> extraModels, @Nullable Box extraFloor, ObjectArraySet<Box> doorways) {
        super(readerBase);
        this.updateData(readerBase);
        ObjectArraySet<Box> floors = new ObjectArraySet<Box>();
        Object2ObjectOpenHashMap<PartCondition, ObjectArrayList<OptimizedModelWrapper.MaterialGroupWrapper>> materialGroupsModel = new Object2ObjectOpenHashMap<PartCondition, ObjectArrayList<OptimizedModelWrapper.MaterialGroupWrapper>>();
        Object2ObjectOpenHashMap<PartCondition, ObjectArrayList<OptimizedModelWrapper.MaterialGroupWrapper>> materialGroupsModelDoorsClosed = new Object2ObjectOpenHashMap<PartCondition, ObjectArrayList<OptimizedModelWrapper.MaterialGroupWrapper>>();
        Object2ObjectOpenHashMap<PartCondition, ObjectArrayList<OptimizedModelWrapper.MaterialGroupWrapper>> materialGroupsBogie1Model = new Object2ObjectOpenHashMap<PartCondition, ObjectArrayList<OptimizedModelWrapper.MaterialGroupWrapper>>();
        Object2ObjectOpenHashMap<PartCondition, ObjectArrayList<OptimizedModelWrapper.MaterialGroupWrapper>> materialGroupsBogie2Model = new Object2ObjectOpenHashMap<PartCondition, ObjectArrayList<OptimizedModelWrapper.MaterialGroupWrapper>>();
        Object2ObjectOpenHashMap<PartCondition, ObjectArrayList<OptimizedModelWrapper.ObjModelWrapper>> objModelsModel = new Object2ObjectOpenHashMap<PartCondition, ObjectArrayList<OptimizedModelWrapper.ObjModelWrapper>>();
        Object2ObjectOpenHashMap<PartCondition, ObjectArrayList<OptimizedModelWrapper.ObjModelWrapper>> objModelsModelDoorsClosed = new Object2ObjectOpenHashMap<PartCondition, ObjectArrayList<OptimizedModelWrapper.ObjModelWrapper>>();
        Object2ObjectOpenHashMap<PartCondition, ObjectArrayList<OptimizedModelWrapper.ObjModelWrapper>> objModelsBogie1Model = new Object2ObjectOpenHashMap<PartCondition, ObjectArrayList<OptimizedModelWrapper.ObjModelWrapper>>();
        Object2ObjectOpenHashMap<PartCondition, ObjectArrayList<OptimizedModelWrapper.ObjModelWrapper>> objModelsBogie2Model = new Object2ObjectOpenHashMap<PartCondition, ObjectArrayList<OptimizedModelWrapper.ObjModelWrapper>>();
        if (extraModels != null) {
            this.models.addAll(extraModels);
        }
        if (extraFloor != null) {
            floors.add(extraFloor);
        }
        VehicleResource.forEachNonNull(this.models, dynamicVehicleModel -> dynamicVehicleModel.writeFloorsAndDoorways(floors, doorways, materialGroupsModel, materialGroupsModelDoorsClosed, objModelsModel, objModelsModelDoorsClosed));
        VehicleResource.forEachNonNull(this.models, dynamicVehicleModel -> dynamicVehicleModel.modelProperties.iterateParts(modelPropertiesPart -> modelPropertiesPart.mapDoors(doorways)));
        VehicleResource.forEachNonNull(this.bogie1Models, dynamicVehicleModel -> dynamicVehicleModel.writeFloorsAndDoorways(new ObjectArraySet<Box>(), new ObjectArraySet<Box>(), new Object2ObjectOpenHashMap<PartCondition, ObjectArrayList<OptimizedModelWrapper.MaterialGroupWrapper>>(), materialGroupsBogie1Model, new Object2ObjectOpenHashMap<PartCondition, ObjectArrayList<OptimizedModelWrapper.ObjModelWrapper>>(), objModelsBogie1Model));
        VehicleResource.forEachNonNull(this.bogie2Models, dynamicVehicleModel -> dynamicVehicleModel.writeFloorsAndDoorways(new ObjectArraySet<Box>(), new ObjectArraySet<Box>(), new Object2ObjectOpenHashMap<PartCondition, ObjectArrayList<OptimizedModelWrapper.MaterialGroupWrapper>>(), materialGroupsBogie2Model, new Object2ObjectOpenHashMap<PartCondition, ObjectArrayList<OptimizedModelWrapper.ObjModelWrapper>>(), objModelsBogie2Model));
        this.floors = new ObjectImmutableList(floors);
        this.doorways = new ObjectImmutableList<Box>((ObjectCollection<Box>)doorways);
        this.optimizedModels = VehicleResource.writeToOptimizedModels(materialGroupsModel, objModelsModel);
        this.optimizedModelsDoorsClosed = VehicleResource.writeToOptimizedModels(materialGroupsModelDoorsClosed, objModelsModelDoorsClosed);
        this.optimizedModelsBogie1 = VehicleResource.writeToOptimizedModels(materialGroupsBogie1Model, objModelsBogie1Model);
        this.optimizedModelsBogie2 = VehicleResource.writeToOptimizedModels(materialGroupsBogie2Model, objModelsBogie2Model);
        if (this.bveSoundBaseResource.isEmpty()) {
            LegacyVehicleSound legacyVehicleSound = new LegacyVehicleSound(this.legacySpeedSoundBaseResource, (int)this.legacySpeedSoundCount, this.legacyUseAccelerationSoundsWhenCoasting, this.legacyConstantPlaybackSpeed, this.legacyDoorSoundBaseResource, this.legacyDoorCloseSoundTime);
            this.createVehicleSoundBase = () -> legacyVehicleSound;
        } else {
            BveVehicleSoundConfig bveVehicleSoundConfig = new BveVehicleSoundConfig(this.bveSoundBaseResource);
            this.createVehicleSoundBase = () -> new BveVehicleSound(bveVehicleSoundConfig);
        }
    }

    public VehicleResource(ReaderBase readerBase) {
        this(readerBase, null, null, new ObjectArraySet<Box>());
    }

    public void queue(StoredMatrixTransformations storedMatrixTransformations, VehicleExtension vehicle, int light, ObjectArrayList<Box> openDoorways) {
        if (openDoorways.isEmpty()) {
            VehicleResource.queue(this.optimizedModelsDoorsClosed, storedMatrixTransformations, vehicle, light, true);
        } else {
            VehicleResource.queue(this.optimizedModels, storedMatrixTransformations, vehicle, light, false);
        }
    }

    public void queueBogie(int bogieIndex, StoredMatrixTransformations storedMatrixTransformations, VehicleExtension vehicle, int light) {
        if (Utilities.isBetween(bogieIndex, 0.0, 1.0)) {
            VehicleResource.queue(bogieIndex == 0 ? this.optimizedModelsBogie1 : this.optimizedModelsBogie2, storedMatrixTransformations, vehicle, light, true);
        }
    }

    public String getId() {
        return this.id;
    }

    public MutableText getName() {
        return TextHelper.translatable(this.name, new Object[0]);
    }

    public int getColor() {
        return CustomResourceTools.colorStringToInt(this.color);
    }

    public TransportMode getTransportMode() {
        return this.transportMode;
    }

    public double getLength() {
        return this.length;
    }

    public double getWidth() {
        return this.width;
    }

    public double getBogie1Position() {
        return this.bogie1Position;
    }

    public double getBogie2Position() {
        return this.bogie2Position;
    }

    public double getCouplingPadding1() {
        return this.couplingPadding1;
    }

    public double getCouplingPadding2() {
        return this.couplingPadding2;
    }

    public MutableText getDescription() {
        return TextHelper.translatable(this.description, new Object[0]);
    }

    public String getWikipediaArticle() {
        return this.wikipediaArticle;
    }

    public void iterateModels(ModelConsumer modelConsumer) {
        for (int i = 0; i < this.models.size(); ++i) {
            VehicleModel vehicleModel = (VehicleModel)this.models.get(i);
            if (vehicleModel == null || vehicleModel.model == null) continue;
            modelConsumer.accept(i, vehicleModel.model);
        }
    }

    public void iterateBogieModels(int bogieIndex, Consumer<DynamicVehicleModel> consumer) {
        if (Utilities.isBetween(bogieIndex, 0.0, 1.0)) {
            (bogieIndex == 0 ? this.bogie1Models : this.bogie2Models).forEach(vehicleModel -> {
                if (vehicleModel.model != null) {
                    consumer.accept(vehicleModel.model);
                }
            });
        }
    }

    public boolean hasGangway1() {
        return this.hasGangway1;
    }

    public boolean hasGangway2() {
        return this.hasGangway2;
    }

    public boolean hasBarrier1() {
        return this.hasBarrier1;
    }

    public boolean hasBarrier2() {
        return this.hasBarrier2;
    }

    public static boolean matchesCondition(VehicleExtension vehicle, PartCondition partCondition, boolean noOpenDoorways) {
        switch (partCondition) {
            case AT_DEPOT: {
                return !vehicle.getIsOnRoute();
            }
            case ON_ROUTE_FORWARDS: {
                return vehicle.getIsOnRoute() && !vehicle.getReversed();
            }
            case ON_ROUTE_BACKWARDS: {
                return vehicle.getIsOnRoute() && vehicle.getReversed();
            }
            case DOORS_CLOSED: {
                return vehicle.persistentVehicleData.getDoorValue() == 0.0 || noOpenDoorways;
            }
            case DOORS_OPENED: {
                return vehicle.persistentVehicleData.getDoorValue() > 0.0 && !noOpenDoorways;
            }
        }
        return VehicleResource.getChristmasLightState(partCondition);
    }

    private static boolean getChristmasLightState(PartCondition partCondition) {
        int index;
        switch (partCondition) {
            case CHRISTMAS_LIGHT_RED: {
                index = 0;
                break;
            }
            case CHRISTMAS_LIGHT_YELLOW: {
                index = 1;
                break;
            }
            case CHRISTMAS_LIGHT_GREEN: {
                index = 2;
                break;
            }
            case CHRISTMAS_LIGHT_BLUE: {
                index = 3;
                break;
            }
            default: {
                return true;
            }
        }
        return CHRISTMAS_LIGHT_STAGES[(int)(System.currentTimeMillis() / 500L % (long)CHRISTMAS_LIGHT_STAGES.length)][index];
    }

    private static void queue(Object2ObjectOpenHashMap<PartCondition, OptimizedModelWrapper> optimizedModels, StoredMatrixTransformations storedMatrixTransformations, VehicleExtension vehicle, int light, boolean noOpenDoorways) {
        optimizedModels.forEach((partCondition, optimizedModel) -> {
            if (VehicleResource.matchesCondition(vehicle, partCondition, noOpenDoorways)) {
                MainRenderer.scheduleRender(QueuedRenderLayer.TEXT, (graphicsHolder, offset) -> {
                    storedMatrixTransformations.transform((GraphicsHolder)graphicsHolder, (Vector3d)offset);
                    CustomResourceLoader.OPTIMIZED_RENDERER_WRAPPER.queue((OptimizedModelWrapper)optimizedModel, (GraphicsHolder)graphicsHolder, light);
                    graphicsHolder.pop();
                });
            }
        });
    }

    private static Object2ObjectOpenHashMap<PartCondition, OptimizedModelWrapper> writeToOptimizedModels(Object2ObjectOpenHashMap<PartCondition, ObjectArrayList<OptimizedModelWrapper.MaterialGroupWrapper>> materialGroupsModel, Object2ObjectOpenHashMap<PartCondition, ObjectArrayList<OptimizedModelWrapper.ObjModelWrapper>> objModelsModel) {
        Object2ObjectOpenHashMap<PartCondition, OptimizedModelWrapper> optimizedModels = new Object2ObjectOpenHashMap<PartCondition, OptimizedModelWrapper>();
        for (PartCondition partCondition : PartCondition.values()) {
            ObjectArrayList<OptimizedModelWrapper.MaterialGroupWrapper> materialGroups = materialGroupsModel.get((Object)partCondition);
            OptimizedModelWrapper optimizedModel1 = materialGroups == null ? null : OptimizedModelWrapper.fromMaterialGroups(materialGroups);
            ObjectArrayList<OptimizedModelWrapper.ObjModelWrapper> objModels = objModelsModel.get((Object)partCondition);
            OptimizedModelWrapper optimizedModel2 = objModels == null ? null : OptimizedModelWrapper.fromObjModels(objModels);
            optimizedModels.put(partCondition, new OptimizedModelWrapper(optimizedModel1, optimizedModel2));
        }
        return optimizedModels;
    }

    private static void forEachNonNull(ObjectArrayList<VehicleModel> models, Consumer<DynamicVehicleModel> consumer) {
        models.forEach(vehicleModel -> {
            if (vehicleModel.model != null) {
                consumer.accept(vehicleModel.model);
            }
        });
    }

    @FunctionalInterface
    public static interface ModelConsumer {
        public void accept(int var1, DynamicVehicleModel var2);
    }
}

