/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.screen;

import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.client.gui.components.AbstractWidget;
import org.mtr.core.data.AreaBase;
import org.mtr.core.data.Data;
import org.mtr.core.data.Depot;
import org.mtr.core.data.Platform;
import org.mtr.core.data.Position;
import org.mtr.core.data.Route;
import org.mtr.core.data.RoutePlatformData;
import org.mtr.core.data.SavedRailBase;
import org.mtr.core.data.Siding;
import org.mtr.core.data.Station;
import org.mtr.core.data.TransportMode;
import org.mtr.core.operation.DeleteDataRequest;
import org.mtr.core.operation.UpdateDataRequest;
import org.mtr.libraries.it.unimi.dsi.fastutil.ints.IntIntImmutablePair;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.mapping.holder.ClickableWidget;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.holder.Screen;
import org.mtr.mapping.mapper.ButtonWidgetExtension;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.GuiDrawing;
import org.mtr.mapping.mapper.ScreenExtension;
import org.mtr.mapping.mapper.TextFieldWidgetExtension;
import org.mtr.mapping.mapper.TextHelper;
import org.mtr.mapping.tool.TextCase;
import org.mtr.mod.Init;
import org.mtr.mod.InitClient;
import org.mtr.mod.client.IDrawing;
import org.mtr.mod.client.MinecraftClientData;
import org.mtr.mod.data.IGui;
import org.mtr.mod.packet.PacketDeleteData;
import org.mtr.mod.packet.PacketUpdateData;
import org.mtr.mod.screen.ConfigScreen;
import org.mtr.mod.screen.DashboardList;
import org.mtr.mod.screen.DashboardListItem;
import org.mtr.mod.screen.DeleteConfirmationScreen;
import org.mtr.mod.screen.EditDepotScreen;
import org.mtr.mod.screen.EditRouteScreen;
import org.mtr.mod.screen.EditStationScreen;
import org.mtr.mod.screen.PlatformScreen;
import org.mtr.mod.screen.RailActionsScreen;
import org.mtr.mod.screen.SidingScreen;
import org.mtr.mod.screen.WidgetColorSelector;
import org.mtr.mod.screen.WidgetMap;

public class DashboardScreen
extends ScreenExtension
implements IGui {
    private SelectedTab selectedTab;
    private AreaBase<?, ?> editingArea;
    private Route editingRoute;
    private int editingRoutePlatformIndex;
    private boolean isNew;
    private final TransportMode transportMode;
    private final WidgetMap widgetMap;
    private final ButtonWidgetExtension buttonTabStations;
    private final ButtonWidgetExtension buttonTabRoutes;
    private final ButtonWidgetExtension buttonTabDepots;
    private final ButtonWidgetExtension buttonAddStation;
    private final ButtonWidgetExtension buttonAddRoute;
    private final ButtonWidgetExtension buttonAddDepot;
    private final ButtonWidgetExtension buttonDoneEditingStation;
    private final ButtonWidgetExtension buttonDoneEditingRoute;
    private final ButtonWidgetExtension buttonDoneEditingRouteDestination;
    private final ButtonWidgetExtension buttonZoomIn;
    private final ButtonWidgetExtension buttonZoomOut;
    private final ButtonWidgetExtension buttonRailActions;
    private final ButtonWidgetExtension buttonOptions;
    private final TextFieldWidgetExtension textFieldName;
    private final TextFieldWidgetExtension textFieldCustomDestination;
    private final WidgetColorSelector colorSelector;
    private final DashboardList dashboardList;
    public static final int MAX_COLOR_ZONE_LENGTH = 6;
    private static final int COLOR_WIDTH = 48;

    public DashboardScreen(TransportMode transportMode) {
        this.transportMode = transportMode;
        this.textFieldName = new TextFieldWidgetExtension(0, 0, 0, 20, 1024, TextCase.DEFAULT, null, TextHelper.translatable("gui.mtr.name", new Object[0]).getString());
        this.textFieldCustomDestination = new TextFieldWidgetExtension(0, 0, 0, 20, 1024, TextCase.DEFAULT, null, TextHelper.translatable("gui.mtr.custom_destination_suggestion", new Object[0]).getString());
        this.colorSelector = new WidgetColorSelector(this, true, this::toggleButtons);
        this.widgetMap = new WidgetMap(transportMode, this::onDrawCorners, this::onDrawCornersMouseRelease, this::onClickAddPlatformToRoute, this::onClickEditSavedRail, this.colorSelector::isMouseOver2);
        this.buttonTabStations = new ButtonWidgetExtension(0, 0, 0, 20, TextHelper.translatable("gui.mtr.stations", new Object[0]), button -> this.onSelectTab(SelectedTab.STATIONS));
        this.buttonTabRoutes = new ButtonWidgetExtension(0, 0, 0, 20, TextHelper.translatable("gui.mtr.routes", new Object[0]), button -> this.onSelectTab(SelectedTab.ROUTES));
        this.buttonTabDepots = new ButtonWidgetExtension(0, 0, 0, 20, TextHelper.translatable("gui.mtr.depots", new Object[0]), button -> this.onSelectTab(SelectedTab.DEPOTS));
        this.buttonAddStation = new ButtonWidgetExtension(0, 0, 0, 20, TextHelper.translatable("gui.mtr.add_station", new Object[0]), button -> this.startEditingArea(new Station(MinecraftClientData.getDashboardInstance()), true));
        this.buttonAddRoute = new ButtonWidgetExtension(0, 0, 0, 20, TextHelper.translatable("gui.mtr.add_route", new Object[0]), button -> this.startEditingRoute(new Route(transportMode, (Data)MinecraftClientData.getDashboardInstance()), true));
        this.buttonAddDepot = new ButtonWidgetExtension(0, 0, 0, 20, TextHelper.translatable("gui.mtr.add_depot", new Object[0]), button -> this.startEditingArea(new Depot(transportMode, (Data)MinecraftClientData.getDashboardInstance()), true));
        this.buttonDoneEditingStation = new ButtonWidgetExtension(0, 0, 0, 20, TextHelper.translatable("gui.done", new Object[0]), button -> this.onDoneEditingArea());
        this.buttonDoneEditingRoute = new ButtonWidgetExtension(0, 0, 0, 20, TextHelper.translatable("gui.done", new Object[0]), button -> this.onDoneEditingRoute());
        this.buttonDoneEditingRouteDestination = new ButtonWidgetExtension(0, 0, 0, 20, TextHelper.translatable("gui.done", new Object[0]), button -> this.onDoneEditingRouteDestination());
        this.buttonZoomIn = new ButtonWidgetExtension(0, 0, 0, 20, TextHelper.literal("+"), button -> this.widgetMap.scale(1.0));
        this.buttonZoomOut = new ButtonWidgetExtension(0, 0, 0, 20, TextHelper.literal("-"), button -> this.widgetMap.scale(-1.0));
        this.buttonRailActions = new ButtonWidgetExtension(0, 0, 0, 20, TextHelper.translatable("gui.mtr.rail_actions_button", new Object[0]), button -> MinecraftClient.getInstance().openScreen(new Screen(new RailActionsScreen())));
        this.buttonOptions = new ButtonWidgetExtension(0, 0, 0, 20, TextHelper.translatable("menu.options", new Object[0]), button -> MinecraftClient.getInstance().openScreen(new Screen(new ConfigScreen())));
        this.dashboardList = new DashboardList(this::onFind, this::onDrawArea, this::onEdit, this::onSort, null, this::onDelete, this::getList, () -> MinecraftClientData.DASHBOARD_SEARCH, text -> {
            MinecraftClientData.DASHBOARD_SEARCH = text;
        });
        this.onSelectTab(SelectedTab.STATIONS);
    }

    @Override
    protected void init2() {
        super.init2();
        int tabCount = 3;
        int bottomRowY = this.f_96544_ - 20;
        this.widgetMap.setPositionAndSize(144, 0, this.f_96543_ - 144, this.f_96544_);
        IDrawing.setPositionAndWidth(this.buttonTabStations, 0, 0, 48);
        IDrawing.setPositionAndWidth(this.buttonTabRoutes, 48, 0, 48);
        IDrawing.setPositionAndWidth(this.buttonTabDepots, 96, 0, 48);
        IDrawing.setPositionAndWidth(this.buttonAddStation, 0, bottomRowY, 144);
        IDrawing.setPositionAndWidth(this.buttonAddRoute, 0, bottomRowY, 144);
        IDrawing.setPositionAndWidth(this.buttonAddDepot, 0, bottomRowY, 144);
        IDrawing.setPositionAndWidth(this.buttonDoneEditingStation, 0, bottomRowY, 144);
        IDrawing.setPositionAndWidth(this.buttonDoneEditingRoute, 0, bottomRowY, 144);
        IDrawing.setPositionAndWidth(this.buttonDoneEditingRouteDestination, 0, bottomRowY, 144);
        IDrawing.setPositionAndWidth(this.buttonZoomIn, this.f_96543_ - 40, bottomRowY, 20);
        IDrawing.setPositionAndWidth(this.buttonZoomOut, this.f_96543_ - 20, bottomRowY, 20);
        IDrawing.setPositionAndWidth(this.buttonRailActions, this.f_96543_ - 200, bottomRowY, 100);
        IDrawing.setPositionAndWidth(this.buttonOptions, this.f_96543_ - 100, bottomRowY, 60);
        IDrawing.setPositionAndWidth(this.textFieldName, 2, bottomRowY - 20 - 2, 92);
        IDrawing.setPositionAndWidth(this.textFieldCustomDestination, 2, bottomRowY - 20 - 2, 140);
        IDrawing.setPositionAndWidth(this.colorSelector, 98, bottomRowY - 20 - 2, 44);
        this.dashboardList.x = 0;
        this.dashboardList.y = 20;
        this.dashboardList.width = 144;
        this.toggleButtons();
        this.dashboardList.init(this::addChild);
        this.addChild(new ClickableWidget(this.widgetMap));
        this.addChild(new ClickableWidget((AbstractWidget)this.buttonTabStations));
        this.addChild(new ClickableWidget((AbstractWidget)this.buttonTabRoutes));
        this.addChild(new ClickableWidget((AbstractWidget)this.buttonTabDepots));
        this.addChild(new ClickableWidget((AbstractWidget)this.buttonAddStation));
        this.addChild(new ClickableWidget((AbstractWidget)this.buttonAddRoute));
        this.addChild(new ClickableWidget((AbstractWidget)this.buttonAddDepot));
        this.addChild(new ClickableWidget((AbstractWidget)this.buttonDoneEditingStation));
        this.addChild(new ClickableWidget((AbstractWidget)this.buttonDoneEditingRoute));
        this.addChild(new ClickableWidget((AbstractWidget)this.buttonDoneEditingRouteDestination));
        this.addChild(new ClickableWidget((AbstractWidget)this.buttonZoomIn));
        this.addChild(new ClickableWidget((AbstractWidget)this.buttonZoomOut));
        this.addChild(new ClickableWidget((AbstractWidget)this.buttonRailActions));
        this.addChild(new ClickableWidget((AbstractWidget)this.buttonOptions));
        this.addChild(new ClickableWidget((AbstractWidget)this.textFieldName));
        this.addChild(new ClickableWidget((AbstractWidget)this.textFieldCustomDestination));
        this.addChild(new ClickableWidget((AbstractWidget)this.colorSelector));
    }

    @Override
    public void render(GraphicsHolder graphicsHolder, int mouseX, int mouseY, float delta) {
        this.widgetMap.render(graphicsHolder, mouseX, mouseY, delta);
        graphicsHolder.push();
        graphicsHolder.translate(0.0, 0.0, 500.0);
        GuiDrawing guiDrawing = new GuiDrawing(graphicsHolder);
        guiDrawing.beginDrawingRectangle();
        guiDrawing.drawRectangle(0.0, 0.0, 144.0, this.f_96544_, -15592942);
        guiDrawing.finishDrawingRectangle();
        this.dashboardList.render(graphicsHolder);
        super.render(graphicsHolder, mouseX, mouseY, delta);
        graphicsHolder.pop();
    }

    @Override
    public void mouseMoved2(double mouseX, double mouseY) {
        this.dashboardList.mouseMoved(mouseX, mouseY);
    }

    @Override
    public boolean mouseScrolled2(double mouseX, double mouseY, double amount) {
        this.dashboardList.mouseScrolled(mouseX, mouseY, amount);
        return super.mouseScrolled2(mouseX, mouseY, amount);
    }

    @Override
    public void tick2() {
        this.textFieldName.tick2();
        this.textFieldCustomDestination.tick2();
        this.dashboardList.tick();
        try {
            switch (this.selectedTab) {
                case STATIONS: {
                    if (this.editingArea == null) {
                        this.dashboardList.setData(MinecraftClientData.convertDataSet(MinecraftClientData.getDashboardInstance().stations), true, true, true, false, false, true);
                        break;
                    }
                    this.dashboardList.setData(MinecraftClientData.convertDataSet(this.editingArea.savedRails), true, false, true, false, false, false);
                    break;
                }
                case ROUTES: {
                    if (this.editingRoute == null) {
                        this.dashboardList.setData(MinecraftClientData.getFilteredDataSet(this.transportMode, MinecraftClientData.getDashboardInstance().routes), false, true, true, false, false, true);
                        break;
                    }
                    ObjectArrayList routeData = this.editingRoute.getRoutePlatforms().stream().map(routePlatformData -> {
                        Platform platform = routePlatformData.platform;
                        if (platform == null) {
                            return null;
                        }
                        String customDestinationPrefix = routePlatformData.getCustomDestination().isEmpty() ? "" : (Route.destinationIsReset(routePlatformData.getCustomDestination()) ? "\"" : "*");
                        Station station = (Station)platform.area;
                        if (station != null) {
                            return new DashboardListItem(0L, String.format("%s%s (%s)", customDestinationPrefix, station.getName(), platform.getName()), station.getColor());
                        }
                        return new DashboardListItem(0L, String.format("%s(%s)", customDestinationPrefix, platform.getName()), 0);
                    }).filter(Objects::nonNull).collect(Collectors.toCollection(ObjectArrayList::new));
                    this.dashboardList.setData(routeData, false, false, true, true, false, true);
                    break;
                }
                case DEPOTS: {
                    if (this.editingArea == null) {
                        this.dashboardList.setData(MinecraftClientData.getFilteredDataSet(this.transportMode, MinecraftClientData.getDashboardInstance().depots), true, true, true, false, false, true);
                        break;
                    }
                    this.dashboardList.setData(MinecraftClientData.convertDataSet(this.editingArea.savedRails), true, false, true, false, false, false);
                }
            }
        }
        catch (Exception e) {
            Init.LOGGER.error("", (Throwable)e);
        }
    }

    @Override
    public boolean isPauseScreen2() {
        return false;
    }

    private void onSelectTab(SelectedTab tab) {
        this.selectedTab = tab;
        this.buttonTabStations.f_93623_ = tab != SelectedTab.STATIONS;
        this.buttonTabRoutes.f_93623_ = tab != SelectedTab.ROUTES;
        this.buttonTabDepots.f_93623_ = tab != SelectedTab.DEPOTS;
        this.stopEditing();
        this.widgetMap.setShowStations(this.selectedTab != SelectedTab.DEPOTS);
    }

    private void onFind(DashboardListItem dashboardListItem, int index) {
        if (this.selectedTab == SelectedTab.STATIONS || this.selectedTab == SelectedTab.DEPOTS) {
            if (this.editingArea == null && dashboardListItem.data instanceof AreaBase) {
                AreaBase area = (AreaBase)dashboardListItem.data;
                if (AreaBase.validCorners(area)) {
                    this.widgetMap.find(area.getCenter());
                }
            } else if (this.selectedTab == SelectedTab.STATIONS) {
                Platform platform = (Platform)dashboardListItem.data;
                this.widgetMap.find(platform.getMidPosition());
            }
        }
    }

    private void onDrawArea(DashboardListItem dashboardListItem, int index) {
        switch (this.selectedTab) {
            case STATIONS: 
            case DEPOTS: {
                if (this.editingArea != null || !(dashboardListItem.data instanceof AreaBase)) break;
                this.startEditingArea((AreaBase)dashboardListItem.data, false);
                break;
            }
            case ROUTES: {
                if (!(dashboardListItem.data instanceof Route)) break;
                this.startEditingRoute((Route)dashboardListItem.data, false);
            }
        }
        this.dashboardList.clearSearch();
    }

    private void onEdit(DashboardListItem dashboardListItem, int index) {
        switch (this.selectedTab) {
            case STATIONS: {
                if (this.editingArea == null) {
                    if (!(dashboardListItem.data instanceof Station)) break;
                    MinecraftClient.getInstance().openScreen(new Screen(new EditStationScreen((Station)dashboardListItem.data, this)));
                    break;
                }
                if (!(dashboardListItem.data instanceof Platform)) break;
                MinecraftClient.getInstance().openScreen(new Screen(new PlatformScreen((Platform)dashboardListItem.data, this.transportMode, this)));
                break;
            }
            case ROUTES: {
                if (this.editingRoute == null && dashboardListItem.data instanceof Route) {
                    MinecraftClient.getInstance().openScreen(new Screen(new EditRouteScreen((Route)dashboardListItem.data, this)));
                    break;
                }
                this.startEditingRouteDestination(index);
                break;
            }
            case DEPOTS: {
                if (this.editingArea == null) {
                    if (!(dashboardListItem.data instanceof Depot)) break;
                    MinecraftClient.getInstance().openScreen(new Screen(new EditDepotScreen((Depot)dashboardListItem.data, this.transportMode, this)));
                    break;
                }
                if (!(dashboardListItem.data instanceof Siding)) break;
                MinecraftClient.getInstance().openScreen(new Screen(new SidingScreen((Siding)dashboardListItem.data, this.transportMode, this)));
            }
        }
    }

    private void onSort() {
        if (this.selectedTab == SelectedTab.ROUTES && this.editingRoute != null) {
            InitClient.REGISTRY_CLIENT.sendPacketToServer(new PacketUpdateData(new UpdateDataRequest(MinecraftClientData.getDashboardInstance()).addRoute(this.editingRoute)));
        }
    }

    private void onDelete(DashboardListItem dashboardListItem, int index) {
        switch (this.selectedTab) {
            case STATIONS: {
                if (!(dashboardListItem.data instanceof Station)) break;
                Station station = (Station)dashboardListItem.data;
                MinecraftClient.getInstance().openScreen(new Screen(new DeleteConfirmationScreen(() -> InitClient.REGISTRY_CLIENT.sendPacketToServer(new PacketDeleteData(new DeleteDataRequest().addStationId(station.getId()))), IGui.formatStationName(station.getName()), this)));
                break;
            }
            case ROUTES: {
                if (this.editingRoute == null) {
                    if (!(dashboardListItem.data instanceof Route)) break;
                    Route route = (Route)dashboardListItem.data;
                    MinecraftClient.getInstance().openScreen(new Screen(new DeleteConfirmationScreen(() -> InitClient.REGISTRY_CLIENT.sendPacketToServer(new PacketDeleteData(new DeleteDataRequest().addRouteId(route.getId()))), IGui.formatStationName(route.getName()), this)));
                    break;
                }
                this.editingRoute.getRoutePlatforms().remove(index);
                InitClient.REGISTRY_CLIENT.sendPacketToServer(new PacketUpdateData(new UpdateDataRequest(MinecraftClientData.getDashboardInstance()).addRoute(this.editingRoute)));
                break;
            }
            case DEPOTS: {
                if (!(dashboardListItem.data instanceof Depot)) break;
                Depot depot = (Depot)dashboardListItem.data;
                MinecraftClient.getInstance().openScreen(new Screen(new DeleteConfirmationScreen(() -> InitClient.REGISTRY_CLIENT.sendPacketToServer(new PacketDeleteData(new DeleteDataRequest().addDepotId(depot.getId()))), IGui.formatStationName(depot.getName()), this)));
            }
        }
    }

    private ObjectArrayList<RoutePlatformData> getList() {
        return this.editingRoute == null ? new ObjectArrayList() : this.editingRoute.getRoutePlatforms();
    }

    private void startEditingArea(AreaBase<?, ?> editingArea, boolean isNew) {
        this.editingArea = editingArea;
        this.editingRoute = null;
        this.isNew = isNew;
        this.textFieldName.setText2(editingArea.getName());
        this.colorSelector.setColor(editingArea.getColor());
        this.widgetMap.startEditingArea(editingArea);
        this.toggleButtons();
    }

    private void startEditingRoute(Route editingRoute, boolean isNew) {
        this.editingArea = null;
        this.editingRoute = editingRoute;
        this.isNew = isNew;
        this.editingRoutePlatformIndex = -1;
        this.textFieldName.setText2(editingRoute.getName());
        this.colorSelector.setColor(editingRoute.getColor());
        this.widgetMap.startEditingRoute();
        this.toggleButtons();
    }

    private void startEditingRouteDestination(int index) {
        this.editingRoutePlatformIndex = index;
        if (this.isValidRoutePlatformIndex()) {
            this.textFieldCustomDestination.setText2(this.editingRoute.getRoutePlatforms().get(index).getCustomDestination());
        }
        this.toggleButtons();
    }

    private void onDrawCorners(IntIntImmutablePair corner1, IntIntImmutablePair corner2) {
        this.editingArea.setCorners(new Position(corner1.leftInt(), Long.MIN_VALUE, corner1.rightInt()), new Position(corner2.leftInt(), Long.MAX_VALUE, corner2.rightInt()));
        this.toggleButtons();
    }

    private void onDrawCornersMouseRelease() {
        if (this.editingArea instanceof Station) {
            InitClient.REGISTRY_CLIENT.sendPacketToServer(new PacketUpdateData(new UpdateDataRequest(MinecraftClientData.getDashboardInstance()).addStation((Station)this.editingArea)));
        } else if (this.editingArea instanceof Depot) {
            InitClient.REGISTRY_CLIENT.sendPacketToServer(new PacketUpdateData(new UpdateDataRequest(MinecraftClientData.getDashboardInstance()).addDepot((Depot)this.editingArea)));
        }
    }

    private void onClickAddPlatformToRoute(long platformId) {
        RoutePlatformData routePlatformData = new RoutePlatformData(platformId);
        this.editingRoute.getRoutePlatforms().add(routePlatformData);
        routePlatformData.writePlatformCache(this.editingRoute, MinecraftClientData.getDashboardInstance().platformIdMap);
        InitClient.REGISTRY_CLIENT.sendPacketToServer(new PacketUpdateData(new UpdateDataRequest(MinecraftClientData.getDashboardInstance()).addRoute(this.editingRoute)));
    }

    private void onClickEditSavedRail(SavedRailBase<?, ?> savedRail) {
        if (savedRail instanceof Platform) {
            MinecraftClient.getInstance().openScreen(new Screen(new PlatformScreen((Platform)savedRail, this.transportMode, this)));
        } else if (savedRail instanceof Siding) {
            MinecraftClient.getInstance().openScreen(new Screen(new SidingScreen((Siding)savedRail, this.transportMode, this)));
        }
    }

    private void onDoneEditingArea() {
        this.editingArea.setName(IGui.textOrUntitled(this.textFieldName.getText2()));
        this.editingArea.setColor(this.colorSelector.getColor());
        if (this.editingArea instanceof Station) {
            InitClient.REGISTRY_CLIENT.sendPacketToServer(new PacketUpdateData(new UpdateDataRequest(MinecraftClientData.getDashboardInstance()).addStation((Station)this.editingArea)));
        } else if (this.editingArea instanceof Depot) {
            InitClient.REGISTRY_CLIENT.sendPacketToServer(new PacketUpdateData(new UpdateDataRequest(MinecraftClientData.getDashboardInstance()).addDepot((Depot)this.editingArea)));
        }
        this.stopEditing();
    }

    private void onDoneEditingRoute() {
        this.editingRoute.setName(IGui.textOrUntitled(this.textFieldName.getText2()));
        this.editingRoute.setColor(this.colorSelector.getColor());
        InitClient.REGISTRY_CLIENT.sendPacketToServer(new PacketUpdateData(new UpdateDataRequest(MinecraftClientData.getDashboardInstance()).addRoute(this.editingRoute)));
        this.stopEditing();
    }

    private void onDoneEditingRouteDestination() {
        if (this.isValidRoutePlatformIndex()) {
            this.editingRoute.getRoutePlatforms().get(this.editingRoutePlatformIndex).setCustomDestination(this.textFieldCustomDestination.getText2());
            InitClient.REGISTRY_CLIENT.sendPacketToServer(new PacketUpdateData(new UpdateDataRequest(MinecraftClientData.getDashboardInstance()).addRoute(this.editingRoute)));
        }
        this.startEditingRoute(this.editingRoute, this.isNew);
    }

    private void stopEditing() {
        this.editingArea = null;
        this.editingRoute = null;
        this.widgetMap.stopEditing();
        this.toggleButtons();
    }

    private boolean isValidRoutePlatformIndex() {
        return this.editingRoute != null && this.editingRoutePlatformIndex >= 0 && this.editingRoutePlatformIndex < this.editingRoute.getRoutePlatforms().size();
    }

    private void toggleButtons() {
        boolean showTextFields;
        boolean hasPermission = MinecraftClientData.hasPermission();
        boolean showRouteDestinationFields = this.isValidRoutePlatformIndex();
        this.buttonAddStation.f_93624_ = this.selectedTab == SelectedTab.STATIONS && this.editingArea == null && hasPermission;
        this.buttonAddRoute.f_93624_ = this.selectedTab == SelectedTab.ROUTES && this.editingRoute == null && hasPermission;
        this.buttonAddDepot.f_93624_ = this.selectedTab == SelectedTab.DEPOTS && this.editingArea == null && hasPermission;
        this.buttonDoneEditingStation.f_93624_ = (this.selectedTab == SelectedTab.STATIONS || this.selectedTab == SelectedTab.DEPOTS) && this.editingArea != null;
        this.buttonDoneEditingStation.f_93623_ = AreaBase.validCorners(this.editingArea);
        this.buttonDoneEditingRoute.f_93624_ = this.selectedTab == SelectedTab.ROUTES && this.editingRoute != null && !showRouteDestinationFields;
        this.buttonDoneEditingRouteDestination.f_93624_ = this.selectedTab == SelectedTab.ROUTES && this.editingRoute != null && showRouteDestinationFields;
        this.textFieldName.f_93624_ = showTextFields = (this.selectedTab == SelectedTab.STATIONS || this.selectedTab == SelectedTab.DEPOTS) && this.editingArea != null || this.selectedTab == SelectedTab.ROUTES && this.editingRoute != null && !showRouteDestinationFields;
        this.textFieldCustomDestination.f_93624_ = showRouteDestinationFields;
        this.colorSelector.f_93624_ = showTextFields;
        this.dashboardList.height = this.f_96544_ - 40 - (showTextFields || showRouteDestinationFields ? 24 : 0);
    }

    private static enum SelectedTab {
        STATIONS,
        ROUTES,
        DEPOTS;

    }
}

