/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.screen;

import net.minecraft.client.gui.components.AbstractWidget;
import org.mtr.mapping.holder.ClickableWidget;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.holder.Screen;
import org.mtr.mapping.mapper.ButtonWidgetExtension;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.ScreenExtension;
import org.mtr.mapping.mapper.TextHelper;
import org.mtr.mod.Init;
import org.mtr.mod.client.IDrawing;
import org.mtr.mod.data.IGui;
import org.mtr.mod.screen.DashboardScreen;

public class DeleteConfirmationScreen
extends ScreenExtension
implements IGui {
    private final Runnable deleteCallback;
    private final String name;
    private final DashboardScreen dashboardScreen;
    private final ButtonWidgetExtension buttonYes;
    private final ButtonWidgetExtension buttonNo;
    private static final int BUTTON_WIDTH = 100;
    private static final int BUTTON_HALF_PADDING = 10;

    public DeleteConfirmationScreen(Runnable deleteCallback, String name, DashboardScreen dashboardScreen) {
        this.deleteCallback = deleteCallback;
        this.name = name;
        this.dashboardScreen = dashboardScreen;
        this.buttonYes = new ButtonWidgetExtension(0, 0, 0, 20, TextHelper.translatable("gui.yes", new Object[0]), button -> this.onYes());
        this.buttonNo = new ButtonWidgetExtension(0, 0, 0, 20, TextHelper.translatable("gui.no", new Object[0]), button -> this.onNo());
    }

    @Override
    protected void init2() {
        super.init2();
        IDrawing.setPositionAndWidth(this.buttonYes, this.f_96543_ / 2 - 100 - 10, this.f_96544_ / 2, 100);
        IDrawing.setPositionAndWidth(this.buttonNo, this.f_96543_ / 2 + 10, this.f_96544_ / 2, 100);
        this.addChild(new ClickableWidget((AbstractWidget)this.buttonYes));
        this.addChild(new ClickableWidget((AbstractWidget)this.buttonNo));
    }

    @Override
    public void render(GraphicsHolder graphicsHolder, int mouseX, int mouseY, float delta) {
        try {
            this.renderBackground(graphicsHolder);
            super.render(graphicsHolder, mouseX, mouseY, delta);
            graphicsHolder.drawCenteredText(TextHelper.translatable("gui.mtr.delete_confirmation", IGui.formatStationName(this.name)), this.f_96543_ / 2, this.f_96544_ / 2 - 40 + 6, -1);
        }
        catch (Exception e) {
            Init.LOGGER.error("", (Throwable)e);
        }
    }

    @Override
    public void onClose2() {
        super.onClose2();
        MinecraftClient.getInstance().openScreen(new Screen(this.dashboardScreen));
    }

    private void onYes() {
        this.deleteCallback.run();
        this.onClose2();
    }

    private void onNo() {
        this.onClose2();
    }
}

