/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.screen;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleSupplier;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.minecraft.client.gui.components.AbstractWidget;
import org.mtr.core.serializer.SerializedDataBase;
import org.mtr.mapping.holder.ClickableWidget;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.holder.Screen;
import org.mtr.mapping.mapper.ButtonWidgetExtension;
import org.mtr.mapping.mapper.CheckboxWidgetExtension;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.ScreenExtension;
import org.mtr.mapping.mapper.TextFieldWidgetExtension;
import org.mtr.mapping.tool.TextCase;
import org.mtr.mod.data.IGui;

public abstract class GenericScreenBase<T extends SerializedDataBase>
extends ScreenExtension
implements IGui {
    protected final T data;
    protected final List<DataElementBase<?>> dataElements = new ArrayList();
    private final GenericScreenBase<?> previousScreen;

    public GenericScreenBase(T data, GenericScreenBase<?> previousScreen) {
        this.data = data;
        this.previousScreen = previousScreen;
    }

    @Override
    protected void init2() {
        super.init2();
        int offsetY = 0;
        for (DataElementBase<?> dataElement : this.dataElements) {
            dataElement.init(this, 34 + offsetY);
            offsetY += dataElement.getWidgetHeight();
        }
    }

    @Override
    public void render(GraphicsHolder graphicsHolder, int mouseX, int mouseY, float delta) {
        this.renderBackground(graphicsHolder);
        super.render(graphicsHolder, mouseX, mouseY, delta);
        int offsetY = 0;
        for (DataElementBase<?> dataElement : this.dataElements) {
            dataElement.render(graphicsHolder, 34 + offsetY);
            offsetY += dataElement.getWidgetHeight();
        }
    }

    @Override
    public void onClose2() {
        MinecraftClient.getInstance().openScreen(new Screen(this.previousScreen));
    }

    @Override
    public boolean isPauseScreen2() {
        return false;
    }

    protected static abstract class DataElementBase<U> {
        final String title;
        final Supplier<U> getData;
        final Consumer<U> setData;
        static final int OFFSET_X = 170;

        DataElementBase(String title, Supplier<U> getData, Consumer<U> setData) {
            this.title = title;
            this.getData = getData;
            this.setData = setData;
        }

        abstract void init(ScreenExtension var1, int var2);

        abstract int getWidgetHeight();

        void render(GraphicsHolder graphicsHolder, int offsetY) {
            graphicsHolder.drawText(this.title, 20, offsetY + this.getWidgetHeight() / 2, -1, false, GraphicsHolder.getDefaultLight());
        }
    }

    protected static final class ChildDataElementBase<T extends SerializedDataBase, U extends SerializedDataBase>
    extends DataElementBase<U> {
        private final ButtonWidgetExtension buttonWidgetExtension;

        ChildDataElementBase(String title, GenericScreenBase<?> newScreen, Supplier<U> getData, Consumer<U> setData) {
            super(title, getData, setData);
            this.buttonWidgetExtension = new ButtonWidgetExtension(170, 0, 144, 20, title, button -> MinecraftClient.getInstance().openScreen(new Screen(newScreen)));
        }

        @Override
        void init(ScreenExtension screen, int offsetY) {
            this.buttonWidgetExtension.setY2(offsetY);
            screen.addChild(new ClickableWidget((AbstractWidget)this.buttonWidgetExtension));
        }

        @Override
        int getWidgetHeight() {
            return 20;
        }
    }

    protected static final class DoubleDataElementBase
    extends DataElementBase<Double> {
        private final TextFieldWidgetExtension textFieldWidgetExtension;

        DoubleDataElementBase(String title, DoubleSupplier getData, DoubleConsumer setData) {
            super(title, getData::getAsDouble, setData::accept);
            this.textFieldWidgetExtension = new TextFieldWidgetExtension(172, 0, 140, 20, title, 16, TextCase.DEFAULT, "[^\\d.-]", title);
        }

        @Override
        void init(ScreenExtension screen, int offsetY) {
            this.textFieldWidgetExtension.setText2(((Double)this.getData.get()).toString());
            this.textFieldWidgetExtension.setY2(2 + offsetY);
            screen.addChild(new ClickableWidget((AbstractWidget)this.textFieldWidgetExtension));
        }

        @Override
        int getWidgetHeight() {
            return 24;
        }
    }

    protected static final class IntegerDataElementBase
    extends DataElementBase<Integer> {
        private final TextFieldWidgetExtension textFieldWidgetExtension;

        IntegerDataElementBase(String title, IntSupplier getData, IntConsumer setData) {
            super(title, getData::getAsInt, setData::accept);
            this.textFieldWidgetExtension = new TextFieldWidgetExtension(172, 0, 140, 20, title, 16, TextCase.DEFAULT, "[^\\d-]", title);
        }

        @Override
        void init(ScreenExtension screen, int offsetY) {
            this.textFieldWidgetExtension.setText2(((Integer)this.getData.get()).toString());
            this.textFieldWidgetExtension.setY2(2 + offsetY);
            screen.addChild(new ClickableWidget((AbstractWidget)this.textFieldWidgetExtension));
        }

        @Override
        int getWidgetHeight() {
            return 24;
        }
    }

    protected static final class StringDataElementBase
    extends DataElementBase<String> {
        private final TextFieldWidgetExtension textFieldWidgetExtension;

        StringDataElementBase(String title, Supplier<String> getData, Consumer<String> setData) {
            super(title, getData, setData);
            this.textFieldWidgetExtension = new TextFieldWidgetExtension(172, 0, 140, 20, title, 256, TextCase.DEFAULT, null, title);
        }

        @Override
        void init(ScreenExtension screen, int offsetY) {
            this.textFieldWidgetExtension.setText2((String)this.getData.get());
            this.textFieldWidgetExtension.setY2(2 + offsetY);
            screen.addChild(new ClickableWidget((AbstractWidget)this.textFieldWidgetExtension));
        }

        @Override
        int getWidgetHeight() {
            return 24;
        }
    }

    protected static final class BooleanDataElementBase
    extends DataElementBase<Boolean> {
        private final CheckboxWidgetExtension checkboxWidgetExtension;

        BooleanDataElementBase(String title, BooleanSupplier getData, Consumer<Boolean> setData) {
            super(title, getData::getAsBoolean, setData);
            this.checkboxWidgetExtension = new CheckboxWidgetExtension(20, 0, 288, 20, title, true, setData);
        }

        @Override
        void init(ScreenExtension screen, int offsetY) {
            this.checkboxWidgetExtension.setChecked((Boolean)this.getData.get());
            this.checkboxWidgetExtension.setY2(offsetY);
            screen.addChild(new ClickableWidget((AbstractWidget)this.checkboxWidgetExtension));
        }

        @Override
        int getWidgetHeight() {
            return 20;
        }

        @Override
        void render(GraphicsHolder graphicsHolder, int offsetY) {
        }
    }
}

