/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.screen;

import java.util.Collections;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.network.chat.Component;
import org.mtr.core.data.Platform;
import org.mtr.core.data.RoutePlatformData;
import org.mtr.core.data.Station;
import org.mtr.core.tool.Utilities;
import org.mtr.libraries.it.unimi.dsi.fastutil.longs.LongAVLTreeSet;
import org.mtr.libraries.it.unimi.dsi.fastutil.longs.LongCollection;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectImmutableList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectList;
import org.mtr.mapping.holder.BlockEntity;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.ClickableWidget;
import org.mtr.mapping.holder.ClientWorld;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.MathHelper;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.holder.MutableText;
import org.mtr.mapping.holder.Screen;
import org.mtr.mapping.holder.Text;
import org.mtr.mapping.mapper.ButtonWidgetExtension;
import org.mtr.mapping.mapper.CheckboxWidgetExtension;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.ScreenExtension;
import org.mtr.mapping.mapper.TextFieldWidgetExtension;
import org.mtr.mapping.mapper.TextHelper;
import org.mtr.mapping.mapper.TexturedButtonWidgetExtension;
import org.mtr.mapping.tool.TextCase;
import org.mtr.mod.Init;
import org.mtr.mod.InitClient;
import org.mtr.mod.block.BlockPIDSBase;
import org.mtr.mod.client.IDrawing;
import org.mtr.mod.data.IGui;
import org.mtr.mod.packet.PacketUpdatePIDSConfig;
import org.mtr.mod.screen.DashboardListItem;
import org.mtr.mod.screen.DashboardListSelectorScreen;

public class PIDSConfigScreen
extends ScreenExtension
implements IGui {
    private final BlockPos blockPos;
    private final String[] messages;
    private final boolean[] hideArrivalArray;
    private final TextFieldWidgetExtension[] textFieldMessages;
    private final CheckboxWidgetExtension[] buttonsHideArrival;
    private final TextFieldWidgetExtension displayPageInput;
    private final MutableText messageText = TextHelper.translatable("gui.mtr.pids_message", new Object[0]);
    private final MutableText hideArrivalText = TextHelper.translatable("gui.mtr.hide_arrival", new Object[0]);
    private final CheckboxWidgetExtension selectAllCheckbox;
    private final ButtonWidgetExtension filterButton;
    private final TexturedButtonWidgetExtension buttonPrevPage;
    private final TexturedButtonWidgetExtension buttonNextPage;
    private final LongAVLTreeSet filterPlatformIds;
    private final int displayPage;
    private final int maxArrivals;
    private int page = 0;
    private static final int MAX_MESSAGE_LENGTH = 2048;
    private static final int TEXT_FIELDS_Y_OFFSET = 162;

    public PIDSConfigScreen(BlockPos blockPos, int maxArrivals) {
        int i;
        this.blockPos = blockPos;
        this.maxArrivals = maxArrivals;
        this.messages = new String[maxArrivals];
        for (i = 0; i < maxArrivals; ++i) {
            this.messages[i] = "";
        }
        this.hideArrivalArray = new boolean[maxArrivals];
        this.selectAllCheckbox = new CheckboxWidgetExtension(0, 0, 0, 20, true, checked -> {});
        this.selectAllCheckbox.setMessage2(new Text((Component)TextHelper.translatable((String)"gui.mtr.automatically_detect_nearby_platform", (Object[])new Object[0]).data));
        this.textFieldMessages = new TextFieldWidgetExtension[maxArrivals];
        for (i = 0; i < maxArrivals; ++i) {
            this.textFieldMessages[i] = new TextFieldWidgetExtension(0, 0, 0, 20, 2048, TextCase.DEFAULT, null, "");
        }
        this.buttonsHideArrival = new CheckboxWidgetExtension[maxArrivals];
        for (i = 0; i < maxArrivals; ++i) {
            this.buttonsHideArrival[i] = new CheckboxWidgetExtension(0, 0, 0, 20, true, checked -> {});
            this.buttonsHideArrival[i].setMessage2(new Text((Component)this.hideArrivalText.data));
        }
        this.buttonPrevPage = new TexturedButtonWidgetExtension(0, 0, 0, 20, new Identifier("textures/gui/sprites/mtr/icon_left.png"), new Identifier("textures/gui/sprites/mtr/icon_left_highlighted.png"), button -> this.setPage(this.page - 1));
        this.buttonNextPage = new TexturedButtonWidgetExtension(0, 0, 0, 20, new Identifier("textures/gui/sprites/mtr/icon_right.png"), new Identifier("textures/gui/sprites/mtr/icon_right_highlighted.png"), button -> this.setPage(this.page + 1));
        ClientWorld clientWorld = MinecraftClient.getInstance().getWorldMapped();
        if (clientWorld == null) {
            this.filterPlatformIds = new LongAVLTreeSet();
            this.displayPage = 0;
        } else {
            BlockEntity blockEntity = clientWorld.getBlockEntity(blockPos);
            if (blockEntity != null && blockEntity.data instanceof BlockPIDSBase.BlockEntityBase) {
                this.filterPlatformIds = ((BlockPIDSBase.BlockEntityBase)((Object)blockEntity.data)).getPlatformIds();
                for (int i2 = 0; i2 < maxArrivals; ++i2) {
                    this.messages[i2] = ((BlockPIDSBase.BlockEntityBase)((Object)blockEntity.data)).getMessage(i2);
                    this.hideArrivalArray[i2] = ((BlockPIDSBase.BlockEntityBase)((Object)blockEntity.data)).getHideArrival(i2);
                }
                this.displayPage = ((BlockPIDSBase.BlockEntityBase)((Object)blockEntity.data)).getDisplayPage();
            } else {
                this.filterPlatformIds = new LongAVLTreeSet();
                this.displayPage = 0;
            }
        }
        this.filterButton = PIDSConfigScreen.getPlatformFilterButton(blockPos, this.selectAllCheckbox, this.filterPlatformIds, this);
        this.displayPageInput = new TextFieldWidgetExtension(0, 0, 0, 20, 3, TextCase.DEFAULT, "\\D", "1");
    }

    @Override
    protected void init2() {
        super.init2();
        int customMessageWidth = GraphicsHolder.getTextWidth(this.messageText) + 20 + 6;
        int textWidth = GraphicsHolder.getTextWidth(this.hideArrivalText) + 20 + 12;
        IDrawing.setPositionAndWidth(this.selectAllCheckbox, 20, 20, 144);
        this.selectAllCheckbox.setChecked(this.filterPlatformIds.isEmpty());
        this.addChild(new ClickableWidget((AbstractWidget)this.selectAllCheckbox));
        IDrawing.setPositionAndWidth(this.filterButton, 20, 60, 72);
        this.filterButton.setMessage2(new Text((Component)TextHelper.translatable((String)"selectWorld.edit", (Object[])new Object[0]).data));
        this.addChild(new ClickableWidget((AbstractWidget)this.filterButton));
        IDrawing.setPositionAndWidth(this.displayPageInput, 22, 102, 68);
        this.displayPageInput.setText2(String.valueOf(this.displayPage + 1));
        this.addChild(new ClickableWidget((AbstractWidget)this.displayPageInput));
        IDrawing.setPositionAndWidth(this.buttonPrevPage, customMessageWidth, 140, 20);
        this.addChild(new ClickableWidget((AbstractWidget)this.buttonPrevPage));
        IDrawing.setPositionAndWidth(this.buttonNextPage, customMessageWidth + 60, 140, 20);
        this.addChild(new ClickableWidget((AbstractWidget)this.buttonNextPage));
        for (int i = 0; i < this.textFieldMessages.length; ++i) {
            TextFieldWidgetExtension textFieldMessage = this.textFieldMessages[i];
            int y = 162 + 24 * (i % this.getMaxArrivalsPerPage());
            IDrawing.setPositionAndWidth(textFieldMessage, 22, y, this.f_96543_ - 40 - 4 - textWidth);
            textFieldMessage.setText2(this.messages[i]);
            this.addChild(new ClickableWidget((AbstractWidget)textFieldMessage));
            CheckboxWidgetExtension buttonHideArrival = this.buttonsHideArrival[i];
            IDrawing.setPositionAndWidth(buttonHideArrival, this.f_96543_ - 20 - textWidth + 6, y + 2, textWidth);
            buttonHideArrival.setChecked(this.hideArrivalArray[i]);
            this.addChild(new ClickableWidget((AbstractWidget)buttonHideArrival));
        }
        this.setPage(0);
    }

    private void setPage(int newPage) {
        int maxArrivalsPerPage = this.getMaxArrivalsPerPage();
        int maxPages = this.getMaxPages() - 1;
        this.page = MathHelper.clamp(newPage, 0, maxPages);
        for (int i = 0; i < this.textFieldMessages.length; ++i) {
            this.textFieldMessages[i].f_93624_ = i / maxArrivalsPerPage == this.page;
        }
        this.buttonPrevPage.f_93624_ = this.page > 0;
        this.buttonNextPage.f_93624_ = this.page < maxPages;
    }

    @Override
    public void tick2() {
        for (TextFieldWidgetExtension textFieldMessage : this.textFieldMessages) {
            textFieldMessage.tick2();
        }
    }

    @Override
    public void onClose2() {
        for (int i = 0; i < this.textFieldMessages.length; ++i) {
            this.messages[i] = this.textFieldMessages[i].getText2();
            this.hideArrivalArray[i] = this.buttonsHideArrival[i].isChecked2();
        }
        if (this.selectAllCheckbox.isChecked2()) {
            this.filterPlatformIds.clear();
        }
        int displayPage = 0;
        try {
            displayPage = Math.max(0, Integer.parseInt(this.displayPageInput.getText2()) - 1);
        }
        catch (Exception e) {
            Init.LOGGER.error("", (Throwable)e);
        }
        InitClient.REGISTRY_CLIENT.sendPacketToServer(new PacketUpdatePIDSConfig(this.blockPos, this.messages, this.hideArrivalArray, this.filterPlatformIds, displayPage));
        super.onClose2();
    }

    @Override
    public void render(GraphicsHolder graphicsHolder, int mouseX, int mouseY, float delta) {
        this.renderBackground(graphicsHolder);
        graphicsHolder.drawText(TextHelper.translatable("gui.mtr.display_page", new Object[0]), 20, 86, -1, false, GraphicsHolder.getDefaultLight());
        graphicsHolder.drawText(TextHelper.translatable("gui.mtr.filtered_platforms", this.selectAllCheckbox.isChecked2() ? 0 : this.filterPlatformIds.size()), 20, 46, -1, false, GraphicsHolder.getDefaultLight());
        graphicsHolder.drawText(this.messageText, 20, 146, -1, false, GraphicsHolder.getDefaultLight());
        int maxPages = this.getMaxPages();
        if (maxPages > 1) {
            graphicsHolder.drawCenteredText(String.format("%s/%s", this.page + 1, maxPages), 60 + GraphicsHolder.getTextWidth(this.messageText) + 6, 146, -1);
        }
        super.render(graphicsHolder, mouseX, mouseY, delta);
    }

    @Override
    public boolean isPauseScreen2() {
        return false;
    }

    private int getMaxArrivalsPerPage() {
        return Math.max(1, (this.f_96544_ - 162 - 20) / 24);
    }

    private int getMaxPages() {
        return (int)Math.ceil((float)this.maxArrivals / (float)this.getMaxArrivalsPerPage());
    }

    public static ButtonWidgetExtension getPlatformFilterButton(BlockPos blockPos, CheckboxWidgetExtension selectAllCheckbox, LongAVLTreeSet filterPlatformIds, ScreenExtension thisScreen) {
        return new ButtonWidgetExtension(0, 0, 0, 20, button -> {
            Station station = InitClient.findStation(blockPos);
            if (station != null) {
                ObjectImmutableList<DashboardListItem> platformsForList = PIDSConfigScreen.getPlatformsForList(station);
                if (selectAllCheckbox.isChecked2()) {
                    filterPlatformIds.clear();
                }
                MinecraftClient.getInstance().openScreen(new Screen(new DashboardListSelectorScreen(() -> {
                    MinecraftClient.getInstance().openScreen(new Screen(thisScreen));
                    selectAllCheckbox.setChecked(filterPlatformIds.isEmpty());
                }, new ObjectImmutableList<DashboardListItem>((ObjectList<DashboardListItem>)platformsForList), (LongCollection)filterPlatformIds, false, false)));
            }
        });
    }

    public static ObjectImmutableList<DashboardListItem> getPlatformsForList(Station station) {
        ObjectArrayList platformsForList = new ObjectArrayList();
        ObjectArrayList<Platform> platforms = new ObjectArrayList<Platform>(station.savedRails);
        Collections.sort(platforms);
        platforms.forEach(platform -> platformsForList.add(new DashboardListItem(platform.getId(), platform.getName() + " " + IGui.mergeStations(platform.routes.stream().map(route -> {
            RoutePlatformData lastRoutePlatformData = (RoutePlatformData)Utilities.getElement(route.getRoutePlatforms(), -1);
            if (lastRoutePlatformData == null) {
                return null;
            }
            Station lastStation = (Station)lastRoutePlatformData.platform.area;
            return lastStation == null ? null : lastStation.getName();
        }).filter(Objects::nonNull).collect(Collectors.toList())), 0)));
        return new ObjectImmutableList<DashboardListItem>(platformsForList);
    }
}

