/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.screen;

import org.mtr.core.data.Platform;
import org.mtr.core.data.Station;
import org.mtr.core.data.TransportMode;
import org.mtr.core.operation.UpdateDataRequest;
import org.mtr.mapping.holder.MutableText;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.TextHelper;
import org.mtr.mod.InitClient;
import org.mtr.mod.client.MinecraftClientData;
import org.mtr.mod.packet.PacketUpdateData;
import org.mtr.mod.screen.DashboardScreen;
import org.mtr.mod.screen.SavedRailScreenBase;

public class PlatformScreen
extends SavedRailScreenBase<Platform, Station> {
    private static final MutableText DWELL_TIME_TEXT = TextHelper.translatable("gui.mtr.dwell_time", new Object[0]);

    public PlatformScreen(Platform savedRailBase, TransportMode transportMode, DashboardScreen dashboardScreen) {
        super(savedRailBase, transportMode, dashboardScreen, DWELL_TIME_TEXT);
    }

    @Override
    protected void init2() {
        super.init2();
        this.sliderDwellTimeMin.setY2(44);
        this.sliderDwellTimeMin.setValue((int)Math.floor((float)((Platform)this.savedRailBase).getDwellTime() / 1000.0f / 60.0f));
        this.sliderDwellTimeSec.setY2(54);
        this.sliderDwellTimeSec.setValue((int)(((Platform)this.savedRailBase).getDwellTime() / 500L % 120L));
    }

    @Override
    public void render(GraphicsHolder graphicsHolder, int mouseX, int mouseY, float delta) {
        super.render(graphicsHolder, mouseX, mouseY, delta);
        if (this.showScheduleControls) {
            graphicsHolder.drawText(DWELL_TIME_TEXT, 20, 50, -1, false, GraphicsHolder.getDefaultLight());
        }
    }

    @Override
    public void onClose2() {
        int minutes = this.sliderDwellTimeMin.getIntValue();
        float second = (float)this.sliderDwellTimeSec.getIntValue() / 2.0f;
        ((Platform)this.savedRailBase).setDwellTime((long)((second + (float)((long)minutes * 60L)) * 1000.0f));
        InitClient.REGISTRY_CLIENT.sendPacketToServer(new PacketUpdateData(new UpdateDataRequest(MinecraftClientData.getDashboardInstance()).addPlatform((Platform)this.savedRailBase)));
        super.onClose2();
    }

    @Override
    protected String getNumberStringKey() {
        return "gui.mtr.platform_number";
    }
}

