/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.screen;

import java.util.stream.Collectors;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.network.chat.Component;
import org.mtr.core.data.Rail;
import org.mtr.core.operation.UpdateDataRequest;
import org.mtr.core.tool.Utilities;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.mapping.holder.ClickableWidget;
import org.mtr.mapping.holder.ClientPlayerEntity;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.holder.MutableText;
import org.mtr.mapping.holder.Screen;
import org.mtr.mapping.holder.Text;
import org.mtr.mapping.mapper.ButtonWidgetExtension;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.GuiDrawing;
import org.mtr.mapping.mapper.ScreenExtension;
import org.mtr.mapping.mapper.TextFieldWidgetExtension;
import org.mtr.mapping.mapper.TextHelper;
import org.mtr.mapping.tool.TextCase;
import org.mtr.mod.InitClient;
import org.mtr.mod.client.IDrawing;
import org.mtr.mod.client.MinecraftClientData;
import org.mtr.mod.data.IGui;
import org.mtr.mod.packet.PacketUpdateData;
import org.mtr.mod.packet.PacketUpdateLastRailStyles;
import org.mtr.mod.screen.RailStyleSelectorScreen;

public class RailModifierScreen
extends ScreenExtension
implements IGui {
    private Rail.Shape shape;
    private double radius;
    private final int buttonsWidth;
    private final Rail rail;
    private final double maxRadius;
    private final ButtonWidgetExtension buttonShape;
    private final ButtonWidgetExtension buttonStyle;
    private final ButtonWidgetExtension buttonStyleFlip;
    private final ButtonWidgetExtension buttonMinus2;
    private final ButtonWidgetExtension buttonMinus1;
    private final ButtonWidgetExtension buttonMinus0;
    private final ButtonWidgetExtension buttonPlus0;
    private final ButtonWidgetExtension buttonPlus1;
    private final ButtonWidgetExtension buttonPlus2;
    private final TextFieldWidgetExtension textFieldRadius;
    private final MutableText shapeText = TextHelper.translatable("gui.mtr.rail_shape", new Object[0]);
    private final MutableText styleText = TextHelper.translatable("gui.mtr.rail_styles", new Object[0]);
    private final MutableText radiusText = TextHelper.translatable("gui.mtr.rail_radius", new Object[0]);
    private final int xStart;

    public RailModifierScreen(String railId) {
        this.rail = (Rail)MinecraftClientData.getInstance().railIdMap.get(railId);
        this.shape = this.rail == null ? Rail.Shape.QUADRATIC : this.rail.railMath.getShape();
        this.radius = this.rail == null ? 0.0 : this.rail.railMath.getVerticalRadius();
        this.maxRadius = this.rail == null ? 0.0 : this.rail.railMath.getMaxVerticalRadius();
        this.buttonShape = new ButtonWidgetExtension(0, 0, 0, 20, TextHelper.literal(""), button -> {
            this.shape = this.shape == Rail.Shape.QUADRATIC ? Rail.Shape.TWO_RADII : Rail.Shape.QUADRATIC;
            this.update(this.radius, true);
        });
        this.buttonStyle = new ButtonWidgetExtension(0, 0, 0, 20, TextHelper.translatable("selectWorld.edit", new Object[0]), button -> {
            if (this.rail != null) {
                MinecraftClient.getInstance().openScreen(new Screen(RailStyleSelectorScreen.create(this.rail)));
            }
        });
        this.buttonStyleFlip = new ButtonWidgetExtension(0, 0, 0, 20, TextHelper.translatable("gui.mtr.flip_styles", new Object[0]), button -> {
            if (this.rail != null) {
                ObjectArrayList styles = this.rail.getStyles().stream().map(style -> {
                    boolean isForwards = style.endsWith("_1");
                    boolean isBackwards = style.endsWith("_2");
                    if (isForwards || isBackwards) {
                        return style.substring(0, style.length() - 1) + (isForwards ? "2" : "1");
                    }
                    return style;
                }).collect(Collectors.toCollection(ObjectArrayList::new));
                InitClient.REGISTRY_CLIENT.sendPacketToServer(new PacketUpdateData(new UpdateDataRequest(MinecraftClientData.getInstance()).addRail(Rail.copy(this.rail, styles))));
                ClientPlayerEntity clientPlayerEntity = MinecraftClient.getInstance().getPlayerMapped();
                if (clientPlayerEntity != null) {
                    InitClient.REGISTRY_CLIENT.sendPacketToServer(new PacketUpdateLastRailStyles(clientPlayerEntity.getUuid(), this.rail.getTransportMode(), styles));
                }
                MinecraftClient.getInstance().openScreen(null);
            }
        });
        this.buttonMinus2 = new ButtonWidgetExtension(0, 0, 0, 20, TextHelper.literal("-10"), button -> this.update(this.radius - 10.0, true));
        this.buttonMinus1 = new ButtonWidgetExtension(0, 0, 0, 20, TextHelper.literal("-1"), button -> this.update(this.radius - 1.0, true));
        this.buttonMinus0 = new ButtonWidgetExtension(0, 0, 0, 20, TextHelper.literal("-0.1"), button -> this.update(this.radius - 0.1, true));
        this.buttonPlus0 = new ButtonWidgetExtension(0, 0, 0, 20, TextHelper.literal("+0.1"), button -> this.update(this.radius + 0.1, true));
        this.buttonPlus1 = new ButtonWidgetExtension(0, 0, 0, 20, TextHelper.literal("+1"), button -> this.update(this.radius + 1.0, true));
        this.buttonPlus2 = new ButtonWidgetExtension(0, 0, 0, 20, TextHelper.literal("+10"), button -> this.update(this.radius + 10.0, true));
        this.textFieldRadius = new TextFieldWidgetExtension(0, 0, 0, 20, 256, TextCase.DEFAULT, "[^\\d\\.]", "0");
        this.xStart = Math.max(GraphicsHolder.getTextWidth(this.shapeText), GraphicsHolder.getTextWidth(this.radiusText)) + 12;
        this.buttonsWidth = 240 + GraphicsHolder.getTextWidth(this.styleText) + 12;
    }

    @Override
    protected void init2() {
        super.init2();
        IDrawing.setPositionAndWidth(this.buttonShape, this.xStart, 0, 120);
        IDrawing.setPositionAndWidth(this.buttonStyle, this.xStart + this.buttonsWidth - 120, 0, 60);
        IDrawing.setPositionAndWidth(this.buttonStyleFlip, this.xStart + this.buttonsWidth - 60, 0, 60);
        IDrawing.setPositionAndWidth(this.buttonMinus2, this.xStart, 22, 40);
        IDrawing.setPositionAndWidth(this.buttonMinus1, this.xStart + 40, 22, 40);
        IDrawing.setPositionAndWidth(this.buttonMinus0, this.xStart + 80, 22, 40);
        IDrawing.setPositionAndWidth(this.buttonPlus0, this.xStart + this.buttonsWidth - 120, 22, 40);
        IDrawing.setPositionAndWidth(this.buttonPlus1, this.xStart + this.buttonsWidth - 80, 22, 40);
        IDrawing.setPositionAndWidth(this.buttonPlus2, this.xStart + this.buttonsWidth - 40, 22, 40);
        IDrawing.setPositionAndWidth(this.textFieldRadius, 0, 22, this.buttonsWidth - 240 - 4);
        this.addChild(new ClickableWidget((AbstractWidget)this.buttonShape));
        this.addChild(new ClickableWidget((AbstractWidget)this.buttonStyle));
        this.addChild(new ClickableWidget((AbstractWidget)this.buttonStyleFlip));
        this.addChild(new ClickableWidget((AbstractWidget)this.buttonMinus2));
        this.addChild(new ClickableWidget((AbstractWidget)this.buttonMinus1));
        this.addChild(new ClickableWidget((AbstractWidget)this.buttonMinus0));
        this.addChild(new ClickableWidget((AbstractWidget)this.buttonPlus0));
        this.addChild(new ClickableWidget((AbstractWidget)this.buttonPlus1));
        this.addChild(new ClickableWidget((AbstractWidget)this.buttonPlus2));
        this.addChild(new ClickableWidget((AbstractWidget)this.textFieldRadius));
        this.textFieldRadius.setText2(String.valueOf(this.radius));
        this.textFieldRadius.setChangedListener2(text -> {
            try {
                this.update(Double.parseDouble(text), true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.update(this.radius, false);
    }

    @Override
    public void tick2() {
        super.tick2();
        this.textFieldRadius.tick2();
    }

    @Override
    public void render(GraphicsHolder graphicsHolder, int mouseX, int mouseY, float delta) {
        GuiDrawing guiDrawing = new GuiDrawing(graphicsHolder);
        guiDrawing.beginDrawingRectangle();
        guiDrawing.drawRectangle(0.0, 0.0, this.f_96543_, this.shape == Rail.Shape.QUADRATIC ? 20.0 : 44.0, -15592942);
        guiDrawing.finishDrawingRectangle();
        super.render(graphicsHolder, mouseX, mouseY, delta);
        graphicsHolder.drawText(this.shapeText, 6, 6, -1, false, GraphicsHolder.getDefaultLight());
        graphicsHolder.drawText(this.styleText, this.xStart + 120 + 6, 6, -1, false, GraphicsHolder.getDefaultLight());
        if (this.shape != Rail.Shape.QUADRATIC) {
            graphicsHolder.drawText(this.radiusText, 6, 28, -1, false, GraphicsHolder.getDefaultLight());
        }
    }

    @Override
    public boolean isPauseScreen2() {
        return false;
    }

    private void update(double newRadius, boolean sendPacket) {
        this.buttonShape.setMessage2(new Text((Component)TextHelper.translatable((String)(this.shape == Rail.Shape.QUADRATIC ? "gui.mtr.rail_shape_quadratic" : "gui.mtr.rail_shape_two_radii"), (Object[])new Object[0]).data));
        this.radius = Utilities.clamp(Utilities.round(newRadius, 2), 0.0, this.maxRadius);
        this.textFieldRadius.setX2((this.shape == Rail.Shape.QUADRATIC ? this.f_96543_ : this.xStart + 120) + 2);
        this.buttonMinus2.setVisibleMapped(this.shape != Rail.Shape.QUADRATIC);
        this.buttonMinus1.setVisibleMapped(this.shape != Rail.Shape.QUADRATIC);
        this.buttonMinus0.setVisibleMapped(this.shape != Rail.Shape.QUADRATIC);
        this.buttonPlus0.setVisibleMapped(this.shape != Rail.Shape.QUADRATIC);
        this.buttonPlus1.setVisibleMapped(this.shape != Rail.Shape.QUADRATIC);
        this.buttonPlus2.setVisibleMapped(this.shape != Rail.Shape.QUADRATIC);
        this.buttonMinus2.setActiveMapped(this.radius > 0.0);
        this.buttonMinus1.setActiveMapped(this.radius > 0.0);
        this.buttonMinus0.setActiveMapped(this.radius > 0.0);
        this.buttonPlus0.setActiveMapped(this.radius < this.maxRadius);
        this.buttonPlus1.setActiveMapped(this.radius < this.maxRadius);
        this.buttonPlus2.setActiveMapped(this.radius < this.maxRadius);
        try {
            if (Double.parseDouble(this.textFieldRadius.getText2()) != this.radius) {
                this.textFieldRadius.setText2(String.valueOf(this.radius));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (sendPacket) {
            InitClient.REGISTRY_CLIENT.sendPacketToServer(new PacketUpdateData(new UpdateDataRequest(MinecraftClientData.getInstance()).addRail(Rail.copy(this.rail, this.shape, this.radius))));
        }
    }
}

