/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.screen;

import java.util.stream.Collectors;
import org.mtr.core.data.Rail;
import org.mtr.core.operation.UpdateDataRequest;
import org.mtr.libraries.it.unimi.dsi.fastutil.longs.LongArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.longs.LongCollection;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.Object2BooleanArrayMap;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectImmutableList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectList;
import org.mtr.mapping.holder.ClientPlayerEntity;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mod.InitClient;
import org.mtr.mod.client.CustomResourceLoader;
import org.mtr.mod.client.MinecraftClientData;
import org.mtr.mod.packet.PacketUpdateData;
import org.mtr.mod.packet.PacketUpdateLastRailStyles;
import org.mtr.mod.resource.RailResource;
import org.mtr.mod.screen.DashboardListItem;
import org.mtr.mod.screen.DashboardListSelectorScreen;

public class RailStyleSelectorScreen
extends DashboardListSelectorScreen {
    private final Rail rail;
    private final ObjectImmutableList<RailResource> allRails = CustomResourceLoader.getRails();

    private RailStyleSelectorScreen(Rail rail, ObjectImmutableList<DashboardListItem> rails, LongArrayList selectedRailIndices) {
        super(() -> {}, rails, (LongCollection)selectedRailIndices, false, false);
        this.rail = rail;
    }

    @Override
    public void onClose2() {
        super.onClose2();
        ClientPlayerEntity clientPlayerEntity = MinecraftClient.getInstance().getPlayerMapped();
        if (clientPlayerEntity != null) {
            InitClient.REGISTRY_CLIENT.sendPacketToServer(new PacketUpdateLastRailStyles(clientPlayerEntity.getUuid(), this.rail.getTransportMode(), this.getStyles()));
        }
    }

    @Override
    protected void updateList() {
        super.updateList();
        InitClient.REGISTRY_CLIENT.sendPacketToServer(new PacketUpdateData(new UpdateDataRequest(MinecraftClientData.getInstance()).addRail(Rail.copy(this.rail, this.getStyles()))));
    }

    public static RailStyleSelectorScreen create(Rail rail) {
        ObjectImmutableList<RailResource> allRails = CustomResourceLoader.getRails();
        ObjectArrayList<DashboardListItem> railsForList = new ObjectArrayList<DashboardListItem>();
        LongArrayList selectedIds = new LongArrayList();
        ObjectArrayList railStylesWithoutDirection = rail.getStyles().stream().map(RailResource::getIdWithoutDirection).collect(Collectors.toCollection(ObjectArrayList::new));
        for (int i = 0; i < allRails.size(); ++i) {
            RailResource railResource = allRails.get(i);
            railsForList.add(new DashboardListItem(i, railResource.getName(), railResource.getColor() | 0xFF000000));
            if (!railStylesWithoutDirection.contains(railResource.getId())) continue;
            selectedIds.add(i);
        }
        return new RailStyleSelectorScreen(rail, new ObjectImmutableList<DashboardListItem>((ObjectList<DashboardListItem>)railsForList), selectedIds);
    }

    private ObjectArrayList<String> getStyles() {
        ObjectArrayList<String> styles = new ObjectArrayList<String>();
        Object2BooleanArrayMap existingDirections = new Object2BooleanArrayMap();
        this.rail.getStyles().forEach(style -> {
            if (!style.equals("default")) {
                existingDirections.put(RailResource.getIdWithoutDirection(style), style.endsWith("_2"));
            }
        });
        this.selectedIds.forEach(index -> {
            String id = this.allRails.get((int)index).getId();
            styles.add((String)(id.equals("default") ? id : id + (existingDirections.getBoolean(id) ? "_2" : "_1")));
        });
        styles.sort(String::compareTo);
        return styles;
    }
}

