/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.screen;

import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.mtr.core.data.AreaBase;
import org.mtr.core.data.Depot;
import org.mtr.core.data.Platform;
import org.mtr.core.data.Position;
import org.mtr.core.data.SavedRailBase;
import org.mtr.core.data.Siding;
import org.mtr.core.data.Station;
import org.mtr.core.data.TransportMode;
import org.mtr.core.tool.Utilities;
import org.mtr.libraries.it.unimi.dsi.fastutil.doubles.DoubleDoubleImmutablePair;
import org.mtr.libraries.it.unimi.dsi.fastutil.ints.IntIntImmutablePair;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.Object2ObjectAVLTreeMap;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.mapping.holder.ClientPlayerEntity;
import org.mtr.mapping.holder.ClientWorld;
import org.mtr.mapping.holder.HeightMapType;
import org.mtr.mapping.holder.MathHelper;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.mapper.ClickableWidgetExtension;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.GuiDrawing;
import org.mtr.mapping.mapper.TextHelper;
import org.mtr.mod.Init;
import org.mtr.mod.client.IDrawing;
import org.mtr.mod.client.MinecraftClientData;
import org.mtr.mod.data.IGui;

public class WidgetMap
extends ClickableWidgetExtension
implements IGui {
    private double scale;
    private double centerX;
    private double centerY;
    private IntIntImmutablePair drawArea1;
    private IntIntImmutablePair drawArea2;
    private MapState mapState;
    private boolean showStations;
    private final TransportMode transportMode;
    private final OnDrawCorners onDrawCorners;
    private final Runnable onDrawCornersMouseRelease;
    private final Consumer<Long> onClickAddPlatformToRoute;
    private final Consumer<SavedRailBase<?, ?>> onClickEditSavedRail;
    private final BiFunction<Double, Double, Boolean> isRestrictedMouseArea;
    private final ClientWorld world;
    private final ClientPlayerEntity player;
    private final Object2ObjectAVLTreeMap<Position, ObjectArrayList<Platform>> flatPositionToPlatformMap;
    private final Object2ObjectAVLTreeMap<Position, ObjectArrayList<Siding>> flatPositionToSidingMap;
    private static final int ARGB_BLUE = -12417548;
    private static final int SCALE_UPPER_LIMIT = 64;
    private static final double SCALE_LOWER_LIMIT = 0.0078125;

    public WidgetMap(TransportMode transportMode, OnDrawCorners onDrawCorners, Runnable onDrawCornersMouseRelease, Consumer<Long> onClickAddPlatformToRoute, Consumer<SavedRailBase<?, ?>> onClickEditSavedRail, BiFunction<Double, Double, Boolean> isRestrictedMouseArea) {
        super(0, 0, 0, 0);
        this.transportMode = transportMode;
        this.onDrawCorners = onDrawCorners;
        this.onDrawCornersMouseRelease = onDrawCornersMouseRelease;
        this.onClickAddPlatformToRoute = onClickAddPlatformToRoute;
        this.onClickEditSavedRail = onClickEditSavedRail;
        this.isRestrictedMouseArea = isRestrictedMouseArea;
        MinecraftClient minecraftClient = MinecraftClient.getInstance();
        this.world = minecraftClient.getWorldMapped();
        this.player = minecraftClient.getPlayerMapped();
        if (this.player == null) {
            this.centerX = 0.0;
            this.centerY = 0.0;
        } else {
            this.centerX = this.player.getX();
            this.centerY = this.player.getZ();
        }
        this.scale = 1.0;
        this.setShowStations(true);
        this.flatPositionToPlatformMap = MinecraftClientData.getFlatPositionToSavedRails(MinecraftClientData.getDashboardInstance().platforms, transportMode);
        this.flatPositionToSidingMap = MinecraftClientData.getFlatPositionToSavedRails(MinecraftClientData.getDashboardInstance().sidings, transportMode);
    }

    @Override
    public void render(GraphicsHolder graphicsHolder, int mouseX, int mouseY, float delta) {
        GuiDrawing guiDrawing = new GuiDrawing(graphicsHolder);
        guiDrawing.beginDrawingRectangle();
        guiDrawing.drawRectangle(this.getX2(), this.getY2(), this.getX2() + this.f_93618_, this.getY2() + this.f_93619_, -16777216);
        IntIntImmutablePair topLeft = this.coordsToWorldPos(0, 0);
        IntIntImmutablePair bottomRight = this.coordsToWorldPos(this.f_93618_, this.f_93619_);
        int increment = this.scale >= 1.0 ? 1 : (int)Math.ceil(1.0 / this.scale);
        for (int i = topLeft.leftInt(); i <= bottomRight.leftInt(); i += increment) {
            for (int j = topLeft.rightInt(); j <= bottomRight.rightInt(); j += increment) {
                int color;
                if (this.world == null || (color = WidgetMap.divideColorRGB(this.world.getBlockState(Init.newBlockPos(i, this.world.getTopY(HeightMapType.getMotionBlockingMapped(), i, j) - 1, j)).getBlock().getDefaultMapColor().getColorMapped(), 2)) == 0) continue;
                this.drawRectangleFromWorldCoords(guiDrawing, i, j, i + increment, j + increment, 0xFF000000 | color);
            }
        }
        DoubleDoubleImmutablePair mouseWorldPos = this.coordsToWorldPos((double)mouseX - (double)this.getX2(), (double)(mouseY - this.getY2()));
        if (this.showStations) {
            this.flatPositionToPlatformMap.forEach((position, platforms) -> this.drawRectangleFromWorldCoords(guiDrawing, position.getX(), position.getZ(), position.getX() + 1L, position.getZ() + 1L, -1));
            for (Station station : MinecraftClientData.getDashboardInstance().stations) {
                if (!AreaBase.validCorners(station)) continue;
                this.drawRectangleFromWorldCoords(guiDrawing, station.getMinX(), station.getMinZ(), station.getMaxX(), station.getMaxZ(), 0x7F000000 + station.getColor());
            }
            this.mouseOnSavedRail(mouseWorldPos, (savedRail, x1, z1, x2, z2) -> this.drawRectangleFromWorldCoords(guiDrawing, x1, z1, x2, z2, -1), true);
        } else {
            this.flatPositionToSidingMap.forEach((position, sidings) -> this.drawRectangleFromWorldCoords(guiDrawing, position.getX(), position.getZ(), position.getX() + 1L, position.getZ() + 1L, -1));
            for (Depot depot : MinecraftClientData.getDashboardInstance().depots) {
                if (!depot.isTransportMode(this.transportMode) || !AreaBase.validCorners(depot)) continue;
                this.drawRectangleFromWorldCoords(guiDrawing, depot.getMinX(), depot.getMinZ(), depot.getMaxX(), depot.getMaxZ(), 0x7F000000 + depot.getColor());
            }
            this.mouseOnSavedRail(mouseWorldPos, (savedRail, x1, z1, x2, z2) -> this.drawRectangleFromWorldCoords(guiDrawing, x1, z1, x2, z2, -1), false);
        }
        if (this.mapState == MapState.EDITING_AREA && this.drawArea1 != null && this.drawArea2 != null) {
            this.drawRectangleFromWorldCoords(guiDrawing, this.drawArea1, this.drawArea2, Integer.MAX_VALUE);
        }
        if (this.player != null) {
            this.drawFromWorldCoords(this.player.getX(), this.player.getZ(), (x1, y1) -> {
                guiDrawing.drawRectangle((double)this.getX2() + Math.max(0.0, x1 - 2.0), (double)this.getY2() + y1 - 3.0, (double)this.getX2() + x1 + 2.0, (double)this.getY2() + y1 + 3.0, -1);
                guiDrawing.drawRectangle((double)this.getX2() + Math.max(0.0, x1 - 3.0), (double)this.getY2() + y1 - 2.0, (double)this.getX2() + x1 + 3.0, (double)this.getY2() + y1 + 2.0, -1);
                guiDrawing.drawRectangle((double)this.getX2() + Math.max(0.0, x1 - 2.0), (double)this.getY2() + y1 - 2.0, (double)this.getX2() + x1 + 2.0, (double)this.getY2() + y1 + 2.0, -12417548);
            });
        }
        guiDrawing.finishDrawingRectangle();
        if (this.mapState == MapState.EDITING_AREA) {
            graphicsHolder.drawText(TextHelper.translatable("gui.mtr.edit_area", new Object[0]).getString(), this.getX2() + 6, this.getY2() + 6, -1, false, GraphicsHolder.getDefaultLight());
        } else if (this.mapState == MapState.EDITING_ROUTE) {
            graphicsHolder.drawText(TextHelper.translatable("gui.mtr.edit_route", new Object[0]).getString(), this.getX2() + 6, this.getY2() + 6, -1, false, GraphicsHolder.getDefaultLight());
        }
        if (this.scale >= 8.0) {
            if (this.showStations) {
                this.flatPositionToPlatformMap.forEach((position, platforms) -> this.drawSavedRail(graphicsHolder, (Position)position, (ObjectArrayList)platforms));
            } else {
                this.flatPositionToSidingMap.forEach((position, sidings) -> this.drawSavedRail(graphicsHolder, (Position)position, (ObjectArrayList)sidings));
            }
        }
        if (this.showStations) {
            for (Station station : MinecraftClientData.getDashboardInstance().stations) {
                if (!this.canDrawAreaText(station)) continue;
                Position position2 = station.getCenter();
                String stationString = String.format("%s|(%s)", station.getName(), TextHelper.translatable("gui.mtr.zone_number", station.getZone1()).getString());
                this.drawFromWorldCoords(position2.getX(), position2.getZ(), (x1, y1) -> IDrawing.drawStringWithFont(graphicsHolder, stationString, (float)this.getX2() + x1.floatValue(), (float)this.getY2() + y1.floatValue(), GraphicsHolder.getDefaultLight()));
            }
        } else {
            for (Depot depot : MinecraftClientData.getDashboardInstance().depots) {
                if (!this.canDrawAreaText(depot)) continue;
                Position position3 = depot.getCenter();
                this.drawFromWorldCoords(position3.getX(), position3.getZ(), (x1, y1) -> IDrawing.drawStringWithFont(graphicsHolder, depot.getName(), (float)this.getX2() + x1.floatValue(), (float)this.getY2() + y1.floatValue(), GraphicsHolder.getDefaultLight()));
            }
        }
        String mousePosText = String.format("(%.1f, %.1f)", mouseWorldPos.leftDouble(), mouseWorldPos.rightDouble());
        graphicsHolder.drawText(mousePosText, this.getX2() + this.f_93618_ - 6 - GraphicsHolder.getTextWidth(mousePosText), this.getY2() + 6, -1, false, GraphicsHolder.getDefaultLight());
    }

    @Override
    public boolean mouseDragged2(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.mapState == MapState.EDITING_AREA) {
            this.drawArea2 = this.coordsToWorldPos((int)Math.round(mouseX - (double)this.getX2()), (int)Math.round(mouseY - (double)this.getY2()));
            if (this.drawArea1.leftInt() == this.drawArea2.leftInt()) {
                this.drawArea2 = new IntIntImmutablePair(this.drawArea2.leftInt() + 1, this.drawArea2.rightInt());
            }
            if (this.drawArea1.rightInt() == this.drawArea2.rightInt()) {
                this.drawArea2 = new IntIntImmutablePair(this.drawArea2.leftInt(), this.drawArea2.rightInt() + 1);
            }
            this.onDrawCorners.onDrawCorners(this.drawArea1, this.drawArea2);
        } else {
            this.centerX -= deltaX / this.scale;
            this.centerY -= deltaY / this.scale;
        }
        return true;
    }

    @Override
    public boolean mouseReleased2(double mouseX, double mouseY, int button) {
        if (this.mapState == MapState.EDITING_AREA) {
            this.onDrawCornersMouseRelease.run();
        }
        return true;
    }

    @Override
    public boolean mouseClicked2(double mouseX, double mouseY, int button) {
        if (this.isMouseOver2(mouseX, mouseY)) {
            if (MinecraftClientData.hasPermission()) {
                if (this.mapState == MapState.EDITING_AREA) {
                    this.drawArea1 = this.coordsToWorldPos((int)(mouseX - (double)this.getX2()), (int)(mouseY - (double)this.getY2()));
                    this.drawArea2 = null;
                } else if (this.mapState == MapState.EDITING_ROUTE) {
                    DoubleDoubleImmutablePair mouseWorldPos = this.coordsToWorldPos(mouseX - (double)this.getX2(), mouseY - (double)this.getY2());
                    this.mouseOnSavedRail(mouseWorldPos, (savedRail, x1, z1, x2, z2) -> this.onClickAddPlatformToRoute.accept(savedRail.getId()), true);
                } else {
                    DoubleDoubleImmutablePair mouseWorldPos = this.coordsToWorldPos(mouseX - (double)this.getX2(), mouseY - (double)this.getY2());
                    this.mouseOnSavedRail(mouseWorldPos, (savedRail, x1, z1, x2, z2) -> this.onClickEditSavedRail.accept(savedRail), this.showStations);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseScrolled2(double mouseX, double mouseY, double amount) {
        double oldScale = this.scale;
        if (oldScale > 0.0078125 && amount < 0.0) {
            this.centerX -= (mouseX - (double)this.getX2() - (double)this.f_93618_ / 2.0) / this.scale;
            this.centerY -= (mouseY - (double)this.getY2() - (double)this.f_93619_ / 2.0) / this.scale;
        }
        this.scale(amount);
        if (oldScale < 64.0 && amount > 0.0) {
            this.centerX += (mouseX - (double)this.getX2() - (double)this.f_93618_ / 2.0) / this.scale;
            this.centerY += (mouseY - (double)this.getY2() - (double)this.f_93619_ / 2.0) / this.scale;
        }
        return true;
    }

    @Override
    public boolean isMouseOver2(double mouseX, double mouseY) {
        return mouseX >= (double)this.getX2() && mouseY >= (double)this.getY2() && mouseX < (double)(this.getX2() + this.f_93618_) && mouseY < (double)(this.getY2() + this.f_93619_) && (!(mouseX >= (double)(this.getX2() + this.f_93618_ - 200)) || !(mouseY >= (double)(this.getY2() + this.f_93619_ - 20))) && this.isRestrictedMouseArea.apply(mouseX, mouseY) == false;
    }

    public void setFocused2(boolean focused) {
    }

    @Override
    public boolean isFocused2() {
        return false;
    }

    public void setPositionAndSize(int x, int y, int width, int height) {
        this.setX2(x);
        this.setY2(y);
        this.f_93618_ = width;
        this.f_93619_ = height;
    }

    public void scale(double amount) {
        this.scale *= Math.pow(2.0, amount);
        this.scale = MathHelper.clamp(this.scale, 0.0078125, 64.0);
    }

    public void find(Position position) {
        this.centerX = position.getX();
        this.centerY = position.getZ();
        this.scale = Math.max(8.0, this.scale);
    }

    public void startEditingArea(AreaBase<?, ?> editingArea) {
        this.mapState = MapState.EDITING_AREA;
        this.drawArea1 = new IntIntImmutablePair((int)editingArea.getMinX(), (int)editingArea.getMinY());
        this.drawArea2 = new IntIntImmutablePair((int)editingArea.getMaxX(), (int)editingArea.getMaxY());
    }

    public void startEditingRoute() {
        this.mapState = MapState.EDITING_ROUTE;
    }

    public void stopEditing() {
        this.mapState = MapState.DEFAULT;
    }

    public void setShowStations(boolean showStations) {
        this.showStations = showStations;
    }

    private void mouseOnSavedRail(DoubleDoubleImmutablePair mouseWorldPos, MouseOnSavedRailCallback mouseOnSavedRailCallback, boolean isPlatform) {
        (isPlatform ? this.flatPositionToPlatformMap : this.flatPositionToSidingMap).forEach((position, savedRails) -> {
            int savedRailCount = savedRails.size();
            for (int i = 0; i < savedRailCount; ++i) {
                double left = position.getX();
                double right = position.getX() + 1L;
                double top = (double)position.getZ() + (double)i / (double)savedRailCount;
                double bottom = (double)position.getZ() + ((double)i + 1.0) / (double)savedRailCount;
                if (!Utilities.isBetween(mouseWorldPos.leftDouble(), left, right) || !Utilities.isBetween(mouseWorldPos.rightDouble(), top, bottom)) continue;
                mouseOnSavedRailCallback.mouseOnSavedRailCallback((SavedRailBase)savedRails.get(i), left, top, right, bottom);
            }
        });
    }

    private IntIntImmutablePair coordsToWorldPos(int mouseX, int mouseY) {
        DoubleDoubleImmutablePair worldPos = this.coordsToWorldPos((double)mouseX, (double)mouseY);
        return new IntIntImmutablePair((int)Math.floor(worldPos.leftDouble()), (int)Math.floor(worldPos.rightDouble()));
    }

    private DoubleDoubleImmutablePair coordsToWorldPos(double mouseX, double mouseY) {
        double left = (mouseX - (double)this.f_93618_ / 2.0) / this.scale + this.centerX;
        double right = (mouseY - (double)this.f_93619_ / 2.0) / this.scale + this.centerY;
        return new DoubleDoubleImmutablePair(left, right);
    }

    private void drawFromWorldCoords(double worldX, double worldZ, BiConsumer<Double, Double> callback) {
        double coordsX = (worldX - this.centerX) * this.scale + (double)this.f_93618_ / 2.0;
        double coordsY = (worldZ - this.centerY) * this.scale + (double)this.f_93619_ / 2.0;
        if (Utilities.isBetween(coordsX, 0.0, this.f_93618_) && Utilities.isBetween(coordsY, 0.0, this.f_93619_)) {
            callback.accept(coordsX, coordsY);
        }
    }

    private void drawRectangleFromWorldCoords(GuiDrawing guiDrawing, IntIntImmutablePair corner1, IntIntImmutablePair corner2, int color) {
        this.drawRectangleFromWorldCoords(guiDrawing, corner1.leftInt(), corner1.rightInt(), corner2.leftInt(), corner2.rightInt(), color);
    }

    private void drawRectangleFromWorldCoords(GuiDrawing guiDrawing, double posX1, double posZ1, double posX2, double posZ2, int color) {
        double x1 = (posX1 - this.centerX) * this.scale + (double)this.f_93618_ / 2.0;
        double z1 = (posZ1 - this.centerY) * this.scale + (double)this.f_93619_ / 2.0;
        double x2 = (posX2 - this.centerX) * this.scale + (double)this.f_93618_ / 2.0;
        double z2 = (posZ2 - this.centerY) * this.scale + (double)this.f_93619_ / 2.0;
        guiDrawing.drawRectangle((double)this.getX2() + Math.max(0.0, x1), (double)this.getY2() + z1, (double)this.getX2() + x2, (double)this.getY2() + z2, color);
    }

    private boolean canDrawAreaText(AreaBase<?, ?> areaBase) {
        return areaBase.getCenter() != null && this.scale >= (double)(80.0f / (float)Math.max(areaBase.getMaxX() - areaBase.getMinX(), areaBase.getMaxZ() - areaBase.getMinZ()));
    }

    private <T extends SavedRailBase<T, U>, U extends AreaBase<U, T>> void drawSavedRail(GraphicsHolder graphicsHolder, Position position, ObjectArrayList<T> sortedSavedRails) {
        int savedRailCount = sortedSavedRails.size();
        for (int i = 0; i < savedRailCount; ++i) {
            int index = i;
            this.drawFromWorldCoords((double)position.getX() + 0.5, (double)position.getZ() + ((double)i + 0.5) / (double)savedRailCount, (x1, y1) -> graphicsHolder.drawCenteredText(((SavedRailBase)sortedSavedRails.get(index)).getName(), this.getX2() + x1.intValue(), this.getY2() + y1.intValue() - 4, -1));
        }
    }

    private static int divideColorRGB(int color, int amount) {
        int r = (color >> 16 & 0xFF) / amount;
        int g = (color >> 8 & 0xFF) / amount;
        int b = (color & 0xFF) / amount;
        return (r << 16) + (g << 8) + b;
    }

    @FunctionalInterface
    public static interface OnDrawCorners {
        public void onDrawCorners(IntIntImmutablePair var1, IntIntImmutablePair var2);
    }

    @FunctionalInterface
    private static interface MouseOnSavedRailCallback {
        public void mouseOnSavedRailCallback(SavedRailBase<?, ?> var1, double var2, double var4, double var6, double var8);
    }

    private static enum MapState {
        DEFAULT,
        EDITING_AREA,
        EDITING_ROUTE;

    }
}

