/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.servlet;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.Logger;
import org.mtr.mapping.holder.OperatingSystem;
import org.mtr.mapping.holder.Util;
import org.mtr.mod.Init;

public final class Tunnel {
    private String tunnelUrl = "";
    private Runnable stopTunnel = null;

    public Tunnel(File rootDirectory, int port, Runnable setUrlCallback) {
        Path tunnelDirectory = rootDirectory.toPath().resolve("tunnelmole");
        Path tunnelPath = tunnelDirectory.resolve("tmole");
        OperatingSystem operatingSystem = Util.getOperatingSystem();
        if (!Files.exists(tunnelPath, new LinkOption[0])) {
            String downloadFileName;
            String url;
            boolean needsUnzip = switch (operatingSystem) {
                case OperatingSystem.WINDOWS -> {
                    url = "https://tunnelmole.com/downloads/tmole.exe";
                    downloadFileName = "tmole";
                    yield false;
                }
                case OperatingSystem.OSX -> {
                    url = "https://tunnelmole.com/downloads/tmole-mac.gz";
                    downloadFileName = "tmole.gz";
                    yield true;
                }
                default -> {
                    url = "https://tunnelmole.com/downloads/tmole-linux.gz";
                    downloadFileName = "tmole.gz";
                    yield true;
                }
            };
            try {
                FileUtils.copyURLToFile((URL)new URL(url), (File)tunnelDirectory.resolve(downloadFileName).toFile());
            }
            catch (Exception e) {
                Init.LOGGER.error("", (Throwable)e);
            }
            if (needsUnzip) {
                Tunnel.executeCommand(null, arg_0 -> ((Logger)Init.LOGGER).info(arg_0), "gunzip", tunnelDirectory.resolve(downloadFileName).toString());
                Tunnel.executeCommand(null, arg_0 -> ((Logger)Init.LOGGER).info(arg_0), "chmod", "+x", tunnelPath.toString());
            }
            Init.LOGGER.info("Successfully downloaded Tunnelmole");
        }
        Tunnel.executeCommand(null, line -> Init.LOGGER.info("Tunnelmole version: {}", line), tunnelPath.toString(), "--version");
        Executors.newSingleThreadExecutor().execute(() -> Tunnel.executeCommand(process -> {
            this.stopTunnel = () -> {
                if (process.isAlive()) {
                    try {
                        process.destroyForcibly().waitFor();
                        Init.LOGGER.info("Successfully stopped Tunnelmole");
                    }
                    catch (Exception e) {
                        Init.LOGGER.error("", (Throwable)e);
                    }
                }
            };
        }, line -> {
            String linePart = line.split(" ")[0];
            if (linePart.startsWith("https://")) {
                this.tunnelUrl = linePart;
                setUrlCallback.run();
            } else if (!linePart.startsWith("http")) {
                Init.LOGGER.info(line);
            }
        }, tunnelPath.toString(), String.valueOf(port)));
        Runtime.getRuntime().addShutdownHook(new Thread(this::stop));
    }

    public void stop() {
        if (this.stopTunnel != null) {
            this.stopTunnel.run();
        }
    }

    public String getTunnelUrl() {
        return this.tunnelUrl;
    }

    private static void executeCommand(@Nullable Consumer<Process> processConsumer, Consumer<String> consoleConsumer, String ... arguments) {
        if (arguments.length > 0) {
            try {
                String line;
                Process process = new ProcessBuilder(arguments).redirectErrorStream(true).start();
                if (processConsumer != null) {
                    processConsumer.accept(process);
                }
                BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                while ((line = reader.readLine()) != null) {
                    consoleConsumer.accept(line);
                }
            }
            catch (Exception e) {
                Init.LOGGER.error("", (Throwable)e);
            }
        }
    }
}

