/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.animation.v1.entity;

import gg.moonflower.pinwheel.api.animation.AnimationController;
import gg.moonflower.pollen.api.animation.v1.controller.SerializableAnimationController;
import gg.moonflower.pollen.core.network.PollenMessages;
import gg.moonflower.pollen.core.network.play.ClientboundSetAnimationPacket;
import io.netty.buffer.Unpooled;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;

public interface AnimatedEntity {
    public AnimationController getAnimationController();

    default public AnimationController getRenderAnimationController() {
        return this.getAnimationController();
    }

    default public void syncClient() {
        AnimationController animationController = this.getAnimationController();
        if (!(animationController instanceof SerializableAnimationController)) {
            throw new IllegalStateException("Animation controller must be serializable to sync");
        }
        SerializableAnimationController serializableController = (SerializableAnimationController)animationController;
        AnimatedEntity animatedEntity = this;
        if (!(animatedEntity instanceof Entity)) {
            throw new IllegalStateException(this.getClass().getName() + " must extend Entity");
        }
        Entity entity = (Entity)animatedEntity;
        if (!serializableController.isDirty()) {
            return;
        }
        serializableController.setDirty(false);
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        serializableController.writeToNetwork(buf);
        PollenMessages.PLAY.sendToTracking(entity, new ClientboundSetAnimationPacket(entity.m_19879_(), buf));
    }
}

