/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.render.util.v1;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import java.util.function.Supplier;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Mth;

public final class ShapeRenderer {
    private static float zLevel = 0.0f;
    private static float red = 1.0f;
    private static float green = 1.0f;
    private static float blue = 1.0f;
    private static float alpha = 1.0f;
    private static Supplier<ShaderInstance> shader = GameRenderer::m_172814_;

    private ShapeRenderer() {
    }

    public static void drawRectWithTexture(PoseStack matrixStack, float x, float y, float width, float height, TextureAtlasSprite sprite) {
        ShapeRenderer.drawRectWithTexture(matrixStack, x, y, sprite.m_118409_(), sprite.m_118411_(), width, height, sprite.m_118410_() - sprite.m_118409_(), sprite.m_118412_() - sprite.m_118411_(), 1.0f, 1.0f);
    }

    public static void drawRectWithTexture(PoseStack matrixStack, float x, float y, float u, float v, float width, float height) {
        ShapeRenderer.drawRectWithTexture(matrixStack, x, y, u, v, width, height, width, height, 256.0f, 256.0f);
    }

    public static void drawRectWithTexture(PoseStack matrixStack, float x, float y, float u, float v, float width, float height, float textureWidth, float textureHeight) {
        ShapeRenderer.drawRectWithTexture(matrixStack, x, y, u, v, width, height, textureWidth, textureHeight, 256.0f, 256.0f);
    }

    public static void drawRectWithTexture(PoseStack matrixStack, float x, float y, float u, float v, float width, float height, float textureWidth, float textureHeight, float sourceWidth, float sourceHeight) {
        ShapeRenderer.drawRectWithTexture(ShapeRenderer.begin(), matrixStack, x, y, u, v, width, height, textureWidth, textureHeight, sourceWidth, sourceHeight);
        ShapeRenderer.end();
    }

    public static VertexConsumer begin() {
        BufferBuilder buffer = Tesselator.m_85913_().m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_);
        return buffer;
    }

    public static void end() {
        RenderSystem.m_157427_(shader);
        Tesselator.m_85913_().m_85914_();
        zLevel = 0.0f;
        ShapeRenderer.resetColor();
        shader = GameRenderer::m_172814_;
    }

    public static void drawRectWithTexture(VertexConsumer buffer, PoseStack matrixStack, float x, float y, float width, float height, TextureAtlasSprite sprite) {
        ShapeRenderer.drawRectWithTexture(buffer, matrixStack, x, y, sprite.m_118409_(), sprite.m_118411_(), width, height, sprite.m_118410_() - sprite.m_118409_(), sprite.m_118412_() - sprite.m_118411_(), 1.0f, 1.0f);
    }

    public static void drawRectWithTexture(VertexConsumer buffer, PoseStack matrixStack, float x, float y, float u, float v, float width, float height) {
        ShapeRenderer.drawRectWithTexture(buffer, matrixStack, x, y, u, v, width, height, width, height, 256.0f, 256.0f);
    }

    public static void drawRectWithTexture(VertexConsumer buffer, PoseStack matrixStack, float x, float y, float u, float v, float width, float height, float textureWidth, float textureHeight) {
        ShapeRenderer.drawRectWithTexture(buffer, matrixStack, x, y, u, v, width, height, textureWidth, textureHeight, 256.0f, 256.0f);
    }

    public static void drawRectWithTexture(VertexConsumer buffer, PoseStack matrixStack, float x, float y, float u, float v, float width, float height, float textureWidth, float textureHeight, float sourceWidth, float sourceHeight) {
        float scaleWidth = 1.0f / sourceWidth;
        float scaleHeight = 1.0f / sourceHeight;
        Matrix4f matrix4f = matrixStack.m_85850_().m_85861_();
        buffer.m_85982_(matrix4f, x, y + height, zLevel).m_85950_(red, green, blue, alpha).m_7421_(u * scaleWidth, (v + textureHeight) * scaleHeight).m_5752_();
        buffer.m_85982_(matrix4f, x + width, y + height, zLevel).m_85950_(red, green, blue, alpha).m_7421_((u + textureWidth) * scaleWidth, (v + textureHeight) * scaleHeight).m_5752_();
        buffer.m_85982_(matrix4f, x + width, y, zLevel).m_85950_(red, green, blue, alpha).m_7421_((u + textureWidth) * scaleWidth, v * scaleHeight).m_5752_();
        buffer.m_85982_(matrix4f, x, y, zLevel).m_85950_(red, green, blue, alpha).m_7421_(u * scaleWidth, v * scaleHeight).m_5752_();
    }

    public static void drawSunburst(PoseStack matrixStack, float x, float y, float width, float height, int segments) {
        BufferBuilder builder = Tesselator.m_85913_().m_85915_();
        builder.m_166779_(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.f_85815_);
        Matrix4f matrix4f = matrixStack.m_85850_().m_85861_();
        float burstAngleOffset = (float)(Math.PI * (double)(1.0f / (float)segments / 2.0f));
        for (int i = 0; i < segments; ++i) {
            float angle = (float)(Math.PI * 2 * (double)i / (double)segments + 1.5707963267948966);
            builder.m_85982_(matrix4f, x, y, zLevel).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_85982_(matrix4f, x + Mth.m_14089_((float)(angle + burstAngleOffset)) * width / 2.0f, y + Mth.m_14031_((float)(angle + burstAngleOffset)) * height / 2.0f, zLevel).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_85982_(matrix4f, x + Mth.m_14089_((float)(angle - burstAngleOffset)) * width / 2.0f, y + Mth.m_14031_((float)(angle - burstAngleOffset)) * height / 2.0f, zLevel).m_85950_(red, green, blue, alpha).m_5752_();
        }
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_69472_();
        ShapeRenderer.end();
        RenderSystem.m_69493_();
        RenderSystem.m_69461_();
    }

    public static void resetColor() {
        red = 1.0f;
        green = 1.0f;
        blue = 1.0f;
        alpha = 1.0f;
    }

    public static void setZLevel(float zLevel) {
        ShapeRenderer.zLevel = zLevel;
    }

    public static void setColor(float red, float green, float blue, float alpha) {
        ShapeRenderer.red = red;
        ShapeRenderer.green = green;
        ShapeRenderer.blue = blue;
        ShapeRenderer.alpha = alpha;
    }

    public static void setColor(int color) {
        red = (float)(color >> 16 & 0xFF) / 255.0f;
        green = (float)(color >> 8 & 0xFF) / 255.0f;
        blue = (float)(color & 0xFF) / 255.0f;
        alpha = (float)(color >> 24 & 0xFF) / 255.0f;
    }

    public static void setShader(Supplier<ShaderInstance> shader) {
        ShapeRenderer.shader = shader;
    }
}

