/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.core.compat.jei;

import gg.moonflower.pollen.api.crafting.v1.PollenGrindstoneRecipe;
import gg.moonflower.pollen.api.crafting.v1.PollenRecipeTypes;
import gg.moonflower.pollen.core.crafting.PollenShapelessGrindstoneRecipeImpl;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.runtime.IIngredientManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class PollenRecipeMaker {
    private PollenRecipeMaker() {
    }

    public static List<PollenGrindstoneRecipe> getGrindstoneRecipes(IRecipeCategory<PollenGrindstoneRecipe> category, IIngredientManager ingredientManager) {
        Minecraft minecraft = Objects.requireNonNull(Minecraft.m_91087_(), "minecraft");
        ClientLevel clientLevel = Objects.requireNonNull(minecraft.f_91073_, "minecraft world");
        List<PollenGrindstoneRecipe> recipes = PollenRecipeMaker.getRecipes(clientLevel.m_7465_(), category, PollenRecipeTypes.GRINDSTONE_TYPE.get());
        RegistryAccess registryAccess = clientLevel.m_5962_();
        Registry itemRegistry = registryAccess.m_175515_(Registry.f_122904_);
        Registry enchantmentRegistry = registryAccess.m_175515_(Registry.f_122902_);
        Collection ingredients = ingredientManager.getAllIngredients((IIngredientType)VanillaTypes.ITEM_STACK);
        for (ItemStack ingredient : ingredients) {
            ResourceLocation id;
            if (!ingredient.m_41792_() || (id = itemRegistry.m_7981_((Object)ingredient.m_41720_())) == null || id == Registry.f_122827_.m_122315_()) continue;
            Stream inputs = enchantmentRegistry.m_123024_().filter(enchantment -> !enchantment.m_6589_()).flatMap(enchantment -> IntStream.rangeClosed(enchantment.m_44702_(), enchantment.m_6586_()).mapToObj(level -> {
                HashMap<Enchantment, Integer> enchantmentsMap = new HashMap<Enchantment, Integer>(1);
                enchantmentsMap.put((Enchantment)enchantment, level);
                ItemStack input = ingredient.m_41720_() == Items.f_42517_ ? new ItemStack((ItemLike)Items.f_42690_) : ingredient.m_41777_();
                EnchantmentHelper.m_44865_(enchantmentsMap, (ItemStack)input);
                return input;
            }));
            recipes.add(new PollenShapelessGrindstoneRecipeImpl(new ResourceLocation(id.m_135827_(), "disenchant_" + id.m_135815_()), "", ingredient, (NonNullList<Ingredient>)NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{Ingredient.m_43921_(inputs)}), -1));
        }
        return recipes;
    }

    public static <C extends Container, T extends Recipe<C>> List<T> getRecipes(@Nullable IRecipeCategory<T> category, RecipeType<T> type) {
        Minecraft minecraft = Objects.requireNonNull(Minecraft.m_91087_(), "minecraft");
        ClientLevel level = Objects.requireNonNull(minecraft.f_91073_, "minecraft world");
        return PollenRecipeMaker.getRecipes(level.m_7465_(), category, type);
    }

    public static <C extends Container, T extends Recipe<C>> List<T> getRecipes(RecipeManager recipeManager, @Nullable IRecipeCategory<T> category, RecipeType<T> type) {
        return recipeManager.m_44013_(type).stream().filter(recipe -> !recipe.m_5598_() && (category == null || category.isHandled(recipe))).collect(Collectors.toList());
    }
}

