/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.impl.animation.controller;

import gg.moonflower.pinwheel.api.animation.PlayingAnimation;
import gg.moonflower.pollen.api.animation.v1.controller.PollenAnimationController;
import gg.moonflower.pollen.api.render.animation.v1.AnimationManager;
import gg.moonflower.pollen.impl.animation.PollenPlayingAnimationImpl;
import gg.moonflower.pollen.impl.animation.controller.IdleAnimationControllerImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class ClientIdleAnimationControllerImpl
extends IdleAnimationControllerImpl {
    private final List<PlayingAnimation> playingAnimations = new ArrayList<PlayingAnimation>();
    private ResourceLocation[] idleAnimations = new ResourceLocation[0];

    public ClientIdleAnimationControllerImpl(PollenAnimationController delegate) {
        super(delegate);
    }

    private void tickIdle() {
        if (!this.playingAnimations.isEmpty()) {
            return;
        }
        for (ResourceLocation animation : this.idleAnimations) {
            PollenPlayingAnimationImpl playingAnimation = new PollenPlayingAnimationImpl(AnimationManager.getAnimation(animation));
            playingAnimation.setTimer(this.delegate.getRenderTimer(animation));
            this.playingAnimations.add((PlayingAnimation)playingAnimation);
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.delegate.isNoAnimationPlaying()) {
            this.playingAnimations.clear();
            return;
        }
        for (PlayingAnimation playingAnimation : this.playingAnimations) {
            if (!(playingAnimation instanceof PollenPlayingAnimationImpl)) continue;
            PollenPlayingAnimationImpl impl = (PollenPlayingAnimationImpl)playingAnimation;
            impl.tick();
        }
        if (this.idleAnimations.length > 0) {
            this.tickIdle();
        }
    }

    @Override
    public void updateRenderTime(float partialTicks) {
        super.updateRenderTime(partialTicks);
        if (this.delegate.isNoAnimationPlaying()) {
            for (PlayingAnimation animation : this.playingAnimations) {
                if (!(animation instanceof PollenPlayingAnimationImpl)) continue;
                PollenPlayingAnimationImpl impl = (PollenPlayingAnimationImpl)animation;
                impl.setRenderTime(partialTicks);
            }
        }
    }

    @Override
    public Collection<PlayingAnimation> getPlayingAnimations() {
        return this.delegate.isNoAnimationPlaying() ? this.playingAnimations : super.getPlayingAnimations();
    }

    @Override
    public ResourceLocation[] getIdleAnimations() {
        return this.idleAnimations;
    }

    @Override
    public void setIdleAnimations(ResourceLocation ... animations) {
        if (Arrays.equals(this.idleAnimations, animations)) {
            return;
        }
        this.idleAnimations = animations;
        if (this.delegate.isNoAnimationPlaying()) {
            this.playingAnimations.clear();
            this.tickIdle();
        }
    }
}

