/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.impl.animation.runtime;

import gg.moonflower.molangcompiler.api.MolangEnvironmentBuilder;
import gg.moonflower.molangcompiler.api.MolangExpression;
import gg.moonflower.molangcompiler.api.MolangRuntime;
import gg.moonflower.molangcompiler.api.bridge.MolangJavaFunction;
import gg.moonflower.molangcompiler.api.bridge.MolangVariableProvider;
import gg.moonflower.pollen.api.animation.v1.controller.IdleAnimationController;
import gg.moonflower.pollen.api.animation.v1.controller.PollenAnimationController;
import gg.moonflower.pollen.api.animation.v1.controller.StateAnimationController;
import gg.moonflower.pollen.api.animation.v1.state.AnimationState;
import gg.moonflower.pollen.impl.animation.controller.IdleAnimationControllerImpl;
import gg.moonflower.pollen.impl.animation.controller.StateAnimationControllerImpl;
import gg.moonflower.pollen.impl.animation.runtime.SidedAnimationRuntime;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApiStatus.Internal
public class CommonAnimationRuntime
implements SidedAnimationRuntime {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"MoLang");
    private static final MolangJavaFunction APPROX_EQUALS = context -> {
        if (context.getParameters() <= 1) {
            return 1.0f;
        }
        float first = context.get(0);
        for (int i = 1; i < context.getParameters(); ++i) {
            if (!((double)Math.abs(context.get(i) - first) > 1.0E-6)) continue;
            return 0.0f;
        }
        return 1.0f;
    };
    private static final MolangJavaFunction LOG = context -> {
        int size = context.getParameters();
        if (size == 1) {
            float value = context.get(0);
            LOGGER.info(String.valueOf(value));
            return value;
        }
        CharSequence[] values = new String[size];
        for (int i = 0; i < values.length; ++i) {
            values[i] = Float.toString(context.get(i));
        }
        LOGGER.info(String.join((CharSequence)", ", values));
        return 0.0f;
    };

    @Override
    public void addGlobal(MolangEnvironmentBuilder<?> builder) {
        builder.setQuery("approx_eq", -1, APPROX_EQUALS);
        builder.setQuery("log", -1, LOG);
    }

    @Override
    public void addEntity(MolangEnvironmentBuilder<?> builder, Entity entity, boolean client) {
        LivingEntity livingEntity;
        if (entity instanceof MolangVariableProvider) {
            MolangVariableProvider provider = (MolangVariableProvider)entity;
            builder.setVariables(provider);
        }
        builder.setQuery("day", MolangExpression.of(() -> Float.valueOf(entity.f_19853_.m_46468_() / 24000L + 1L)));
        builder.setQuery("moon_phase", MolangExpression.of(() -> Float.valueOf(entity.f_19853_.m_46941_())));
        builder.setQuery("moon_brightness", MolangExpression.of(() -> Float.valueOf(entity.f_19853_.m_46940_())));
        builder.setQuery("is_on_ground", MolangExpression.of(() -> ((Entity)entity).m_20096_()));
        builder.setQuery("is_in_water", MolangExpression.of(() -> ((Entity)entity).m_20069_()));
        builder.setQuery("is_in_water_or_rain", MolangExpression.of(() -> ((Entity)entity).m_20070_()));
        builder.setQuery("is_in_contact_with_water", MolangExpression.of(() -> ((Entity)entity).m_20071_()));
        builder.setQuery("is_moving", MolangExpression.of(() -> entity.m_20184_().m_82556_() > 1.0E-7));
        builder.setQuery("is_alive", MolangExpression.of(() -> ((Entity)entity).m_6084_()));
        builder.setQuery("is_fire_immune", MolangExpression.of(() -> ((Entity)entity).m_5825_()));
        builder.setQuery("is_on_fire", MolangExpression.of(() -> ((Entity)entity).m_6060_()));
        builder.setQuery("is_invisible", MolangExpression.of(() -> ((Entity)entity).m_20145_()));
        builder.setQuery("is_ghost", MolangExpression.of(() -> ((Entity)entity).m_5833_()));
        builder.setQuery("ground_speed", MolangExpression.of(() -> {
            Vec3 velocity = entity.m_20184_();
            return Float.valueOf(Mth.m_14116_((float)((float)(velocity.f_82479_ * velocity.f_82479_ + velocity.f_82481_ * velocity.f_82481_))));
        }));
        if (entity instanceof LivingEntity) {
            livingEntity = (LivingEntity)entity;
            builder.setQuery("modified_move_speed", MolangExpression.of(() -> ((LivingEntity)livingEntity).m_6113_()));
        }
        builder.setQuery("modified_distance_moved", MolangExpression.of(() -> Float.valueOf(entity.f_19788_)));
        builder.setQuery("vertical_speed", MolangExpression.of(() -> Float.valueOf((float)entity.m_20184_().m_7098_())));
        if (entity instanceof LivingEntity) {
            livingEntity = (LivingEntity)entity;
            builder.setQuery("health", MolangExpression.of(() -> ((LivingEntity)livingEntity).m_21223_()));
            builder.setQuery("max_health", MolangExpression.of(() -> ((LivingEntity)livingEntity).m_21233_()));
            builder.setQuery("is_baby", MolangExpression.of(() -> ((LivingEntity)livingEntity).m_6162_()));
        }
    }

    @Override
    public StateAnimationController createController(AnimationState[] states, MolangRuntime runtime, boolean client) {
        return new StateAnimationControllerImpl(states, runtime);
    }

    @Override
    public IdleAnimationController createIdleController(PollenAnimationController controller) {
        return new IdleAnimationControllerImpl(controller);
    }
}

