/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.impl.mixin.crafting;

import gg.moonflower.pollen.api.crafting.v1.PollenBrewingRecipe;
import gg.moonflower.pollen.api.crafting.v1.PollenRecipeTypes;
import gg.moonflower.pollen.api.platform.v1.Platform;
import java.util.Collections;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.ItemLike;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PotionBrewing.class})
public class PotionBrewingMixin {
    @Unique
    private static List<PollenBrewingRecipe> getRecipes() {
        return Platform.getRecipeManager().map(recipeManager -> recipeManager.m_44013_(PollenRecipeTypes.BREWING_TYPE.get())).orElse(Collections.emptyList());
    }

    @Inject(method={"isPotionIngredient"}, at={@At(value="HEAD")}, cancellable=true)
    private static void isPotionIngredient(ItemStack itemStack, CallbackInfoReturnable<Boolean> cir) {
        List<PollenBrewingRecipe> recipes = PotionBrewingMixin.getRecipes();
        for (PollenBrewingRecipe recipe : recipes) {
            if (!recipe.getIngredient().test(itemStack)) continue;
            cir.setReturnValue((Object)true);
            return;
        }
    }

    @Inject(method={"isBrewablePotion"}, at={@At(value="HEAD")}, cancellable=true)
    private static void isBrewablePotion(Potion potion, CallbackInfoReturnable<Boolean> cir) {
        List<PollenBrewingRecipe> list = PotionBrewingMixin.getRecipes();
        for (PollenBrewingRecipe recipes : list) {
            if (recipes.getResult() != potion) continue;
            cir.setReturnValue((Object)true);
            return;
        }
    }

    @Inject(method={"hasPotionMix"}, at={@At(value="HEAD")}, cancellable=true)
    private static void hasPotionMix(ItemStack potionStack, ItemStack ingredient, CallbackInfoReturnable<Boolean> cir) {
        Potion potion = PotionUtils.m_43579_((ItemStack)potionStack);
        List<PollenBrewingRecipe> recipes = PotionBrewingMixin.getRecipes();
        for (PollenBrewingRecipe recipe : recipes) {
            if (recipe.getFrom() != potion || !recipe.getIngredient().test(ingredient)) continue;
            cir.setReturnValue((Object)true);
            return;
        }
    }

    @Inject(method={"mix"}, at={@At(value="HEAD")}, cancellable=true)
    private static void mix(ItemStack ingredient, ItemStack fromPotion, CallbackInfoReturnable<ItemStack> cir) {
        if (ingredient.m_41619_()) {
            return;
        }
        Potion potion = PotionUtils.m_43579_((ItemStack)fromPotion);
        List<PollenBrewingRecipe> recipes = PotionBrewingMixin.getRecipes();
        for (PollenBrewingRecipe recipe : recipes) {
            if (recipe.getFrom() != potion || !recipe.getIngredient().test(ingredient)) continue;
            cir.setReturnValue((Object)PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)fromPotion.m_41720_()), (Potion)recipe.getResult()));
            return;
        }
    }
}

