/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.impl.registry.particle;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import gg.moonflower.pinwheel.api.particle.ParticleComponentParser;
import gg.moonflower.pinwheel.api.particle.component.ParticleComponent;
import gg.moonflower.pollen.api.registry.particle.v1.BedrockParticleComponentType;
import gg.moonflower.pollen.api.registry.particle.v1.BedrockParticleComponents;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApiStatus.Internal
public class ParticleComponentParserImpl
implements ParticleComponentParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParticleComponentParser.class);

    public Map<String, ParticleComponent> deserialize(JsonObject json) throws JsonParseException {
        HashMap components = new HashMap(json.size());
        for (Map.Entry entry : json.entrySet()) {
            try {
                ResourceLocation id = new ResourceLocation((String)entry.getKey());
                BedrockParticleComponentType type = (BedrockParticleComponentType)BedrockParticleComponents.COMPONENTS.getRegistrar().get(id);
                if (type == null) {
                    LOGGER.error("Unknown particle component: " + id);
                    continue;
                }
                components.put((String)entry.getKey(), type.dataFactory().create((JsonElement)entry.getValue()));
            }
            catch (Exception e) {
                throw new JsonSyntaxException("Invalid particle component: " + (String)entry.getKey(), (Throwable)e);
            }
        }
        return Collections.unmodifiableMap(components);
    }
}

