/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.impl.render.geometry;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import gg.moonflower.molangcompiler.api.bridge.MolangJavaFunction;
import gg.moonflower.molangcompiler.api.exception.MolangRuntimeException;
import gg.moonflower.pinwheel.api.geometry.GeometryCompileException;
import gg.moonflower.pinwheel.api.geometry.GeometryModel;
import gg.moonflower.pinwheel.api.geometry.GeometryModelData;
import gg.moonflower.pinwheel.api.geometry.GeometryRenderer;
import gg.moonflower.pinwheel.api.geometry.GeometryTree;
import gg.moonflower.pinwheel.api.geometry.bone.AnimatedBone;
import gg.moonflower.pinwheel.api.transform.LocatorTransformation;
import gg.moonflower.pinwheel.api.transform.MatrixStack;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalLong;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.FrameTimer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class BedrockGeometryModel
extends Model
implements GeometryModel {
    private static final Logger LOGGER = LogManager.getLogger((String)"MoLang");
    private static final MolangJavaFunction APPROX_EQUALS = context -> {
        if (context.getParameters() <= 1) {
            return 1.0f;
        }
        float first = context.get(0);
        for (int i = 1; i < context.getParameters(); ++i) {
            if (!((double)Math.abs(context.get(i) - first) > 1.0E-7)) continue;
            return 0.0f;
        }
        return 1.0f;
    };
    private static final MolangJavaFunction LAST_FRAME_TIME = context -> {
        int wrappedIndex;
        FrameTimer frameTimer = Minecraft.m_91087_().m_91293_();
        long[] log = frameTimer.m_13764_();
        int index = (int)Math.min(context.get(0), (float)(log.length - 1));
        if (index == 0) {
            return (float)log[frameTimer.m_13761_()] / 1.0E9f;
        }
        if (index < 0) {
            throw new MolangRuntimeException("Invalid argument for last_frame_time(): " + index);
        }
        for (wrappedIndex = frameTimer.m_13761_() - index; wrappedIndex < 0; wrappedIndex += 240) {
        }
        return (float)log[frameTimer.m_13762_(wrappedIndex)] / 1.0E9f;
    };
    private static final MolangJavaFunction AVERAGE_FRAME_TIME = context -> BedrockGeometryModel.applyFrame((int)context.get(0), stream -> OptionalLong.of(stream.sum())) / context.get(0);
    private static final MolangJavaFunction MAX_FRAME_TIME = context -> BedrockGeometryModel.applyFrame((int)context.get(0), LongStream::max);
    private static final MolangJavaFunction MIN_FRAME_TIME = context -> BedrockGeometryModel.applyFrame((int)context.get(0), LongStream::min);
    private static final MolangJavaFunction CAMERA_ROTATION = context -> {
        int param = (int)context.get(0);
        if (param < 0 || param >= 2) {
            throw new MolangRuntimeException("Invalid argument for camera_rotation: " + param);
        }
        Camera camera = Minecraft.m_91087_().f_91063_.m_109153_();
        return param == 0 ? camera.m_90589_() : camera.m_90590_();
    };
    private static final MolangJavaFunction LOG = context -> {
        float value = context.get(0);
        LOGGER.info((Object)Float.valueOf(value));
        return value;
    };
    private static final Vector3f POSITION = new Vector3f();
    private static final Vector3f ROTATION = new Vector3f();
    private static final Vector3f SCALE = new Vector3f();
    private final Map<String, AnimatedBone.AnimationPose> boneTransformations;
    private final GeometryTree tree;

    public BedrockGeometryModel(GeometryModelData model) throws GeometryCompileException {
        super(RenderType::m_110452_);
        Objects.requireNonNull(model, "model");
        this.tree = GeometryTree.create((GeometryModelData)model);
        this.boneTransformations = this.tree.getBones().stream().collect(Collectors.toUnmodifiableMap(bone -> bone.getBone().name(), unused -> new AnimatedBone.AnimationPose()));
    }

    public void m_7695_(PoseStack matrixStack, VertexConsumer builder, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
    }

    public void render(GeometryRenderer renderer, MatrixStack matrixStack) {
        for (AnimatedBone bone : this.tree.getRootBones()) {
            bone.render(renderer, matrixStack);
        }
    }

    @Nullable
    public AnimatedBone getBone(String name) {
        return this.tree.getBone(name);
    }

    public Collection<AnimatedBone> getBones() {
        return this.tree.getBones();
    }

    public Collection<AnimatedBone> getRootBones() {
        return this.tree.getRootBones();
    }

    @Nullable
    public LocatorTransformation getLocatorTransformation(String name) {
        return this.tree.getLocatorTransformation(name);
    }

    public GeometryModelData.Locator[] getLocators() {
        return this.tree.getLocators();
    }

    private static float applyFrame(int count, FrameFunction frameFunction) throws MolangRuntimeException {
        int wrappedIndex;
        FrameTimer frameTimer = Minecraft.m_91087_().m_91293_();
        long[] log = frameTimer.m_13764_();
        int duration = Math.min(count, log.length - 1);
        if (duration == 0) {
            return (float)frameTimer.m_13764_()[frameTimer.m_13761_()] / 1.0E9f;
        }
        if (duration < 0) {
            throw new MolangRuntimeException("Invalid argument for last_frame_time(): " + duration);
        }
        for (wrappedIndex = frameTimer.m_13761_() - duration; wrappedIndex < 0; wrappedIndex += 240) {
        }
        int finalWrappedIndex = wrappedIndex;
        return (float)frameFunction.apply(LongStream.range(0L, duration).map(i -> frameTimer.m_13764_()[frameTimer.m_13762_((int)((long)finalWrappedIndex + i))])).orElse(0L) / 1.0E9f;
    }

    @FunctionalInterface
    private static interface FrameFunction {
        public OptionalLong apply(LongStream var1) throws MolangRuntimeException;
    }
}

