/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.impl.render.geometry;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import gg.moonflower.pinwheel.api.texture.ModelTexture;
import gg.moonflower.pinwheel.api.texture.ModelTextureKey;
import gg.moonflower.pollen.api.render.geometry.v1.GeometryAtlasTexture;
import gg.moonflower.pollen.api.render.shader.v1.ShaderRegistry;
import gg.moonflower.pollen.impl.render.shader.PollenShaderTypes;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class GeometryRenderTypes
extends RenderType {
    private static final Map<Integer, RenderType> ENTITY_RENDER_TYPES = new HashMap<Integer, RenderType>();
    private static final Map<Integer, RenderType> PARTICLE_RENDER_TYPES = new HashMap<Integer, RenderType>();

    private static RenderStateShard.ShaderStateShard shader(final ModelTextureKey texture, ResourceLocation shaderId) {
        return new RenderStateShard.ShaderStateShard(ShaderRegistry.getShader(shaderId)){

            public void m_110185_() {
                super.m_110185_();
                Objects.requireNonNull(RenderSystem.m_157196_()).m_173356_("Glowing").m_142617_(texture.glowing() ? 1 : 0);
            }
        };
    }

    @NotNull
    private static RenderStateShard.TextureStateShard texture(@NotNull GeometryAtlasTexture atlas) {
        return new RenderStateShard.TextureStateShard(atlas.getAtlasLocation(), false, false);
    }

    private GeometryRenderTypes(String nameIn, VertexFormat formatIn, VertexFormat.Mode drawModeIn, int bufferSizeIn, boolean useDelegateIn, boolean needsSortingIn, Runnable setupTaskIn, Runnable clearTaskIn) {
        super(nameIn, formatIn, drawModeIn, bufferSizeIn, useDelegateIn, needsSortingIn, setupTaskIn, clearTaskIn);
    }

    private static RenderType entitySolid(ModelTextureKey texture, GeometryAtlasTexture atlas, boolean cull, @Nullable Consumer<RenderType.CompositeState.CompositeStateBuilder> consumer) {
        int hash = Objects.hash(texture, atlas, cull, consumer);
        return ENTITY_RENDER_TYPES.computeIfAbsent(hash, h -> {
            RenderType.CompositeState.CompositeStateBuilder state = RenderType.CompositeState.m_110628_().m_173290_((RenderStateShard.EmptyTextureStateShard)GeometryRenderTypes.texture(atlas)).m_173292_(GeometryRenderTypes.shader(texture, PollenShaderTypes.MODEL_SOLID)).m_110685_(RenderStateShard.f_110134_).m_110661_(cull ? RenderStateShard.f_110158_ : RenderStateShard.f_110110_).m_110671_(RenderStateShard.f_110152_).m_110677_(RenderStateShard.f_110154_);
            if (consumer != null) {
                consumer.accept(state);
            }
            return RenderType.m_173215_((String)"geometry_solid", (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)state.m_110691_(true));
        });
    }

    private static RenderType entityCutout(ModelTextureKey texture, GeometryAtlasTexture atlas, boolean cull, @Nullable Consumer<RenderType.CompositeState.CompositeStateBuilder> consumer) {
        int hash = Objects.hash(texture, atlas, cull, consumer);
        return ENTITY_RENDER_TYPES.computeIfAbsent(hash, h -> {
            RenderType.CompositeState.CompositeStateBuilder state = RenderType.CompositeState.m_110628_().m_173290_((RenderStateShard.EmptyTextureStateShard)GeometryRenderTypes.texture(atlas)).m_173292_(GeometryRenderTypes.shader(texture, cull ? PollenShaderTypes.MODEL_CUTOUT_CULL : PollenShaderTypes.MODEL_CUTOUT)).m_110685_(RenderStateShard.f_110134_).m_110661_(cull ? RenderStateShard.f_110158_ : RenderStateShard.f_110110_).m_110671_(RenderStateShard.f_110152_).m_110677_(RenderStateShard.f_110154_);
            if (consumer != null) {
                consumer.accept(state);
            }
            return RenderType.m_173215_((String)"geometry_cutout", (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)state.m_110691_(true));
        });
    }

    private static RenderType entityTranslucent(ModelTextureKey texture, GeometryAtlasTexture atlas, boolean cull, @Nullable Consumer<RenderType.CompositeState.CompositeStateBuilder> consumer) {
        int hash = Objects.hash(texture, atlas, cull, consumer);
        return ENTITY_RENDER_TYPES.computeIfAbsent(hash, h -> {
            RenderType.CompositeState.CompositeStateBuilder state = RenderType.CompositeState.m_110628_().m_173290_((RenderStateShard.EmptyTextureStateShard)GeometryRenderTypes.texture(atlas)).m_173292_(GeometryRenderTypes.shader(texture, cull ? PollenShaderTypes.MODEL_TRANSLUCENT_CULL : PollenShaderTypes.MODEL_TRANSLUCENT)).m_110685_(RenderStateShard.f_110139_).m_110661_(cull ? RenderStateShard.f_110158_ : RenderStateShard.f_110110_).m_110671_(RenderStateShard.f_110152_).m_110677_(RenderStateShard.f_110154_);
            if (consumer != null) {
                consumer.accept(state);
            }
            return RenderType.m_173215_((String)"geometry_translucent", (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)true, (RenderType.CompositeState)state.m_110691_(true));
        });
    }

    private static RenderType particleSolid(ModelTextureKey texture, GeometryAtlasTexture atlas, boolean cull, @Nullable Consumer<RenderType.CompositeState.CompositeStateBuilder> consumer) {
        int hash = Objects.hash(texture, atlas, cull, consumer);
        return PARTICLE_RENDER_TYPES.computeIfAbsent(hash, h -> {
            RenderType.CompositeState.CompositeStateBuilder state = RenderType.CompositeState.m_110628_().m_173290_((RenderStateShard.EmptyTextureStateShard)GeometryRenderTypes.texture(atlas)).m_173292_(GeometryRenderTypes.shader(texture, PollenShaderTypes.PARTICLE_SOLID)).m_110685_(RenderStateShard.f_110134_).m_110661_(cull ? RenderStateShard.f_110158_ : RenderStateShard.f_110110_).m_110671_(RenderStateShard.f_110152_);
            if (consumer != null) {
                consumer.accept(state);
            }
            return RenderType.m_173215_((String)"particle_solid", (VertexFormat)DefaultVertexFormat.f_85813_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)state.m_110691_(true));
        });
    }

    private static RenderType particleCutout(ModelTextureKey texture, GeometryAtlasTexture atlas, boolean cull, @Nullable Consumer<RenderType.CompositeState.CompositeStateBuilder> consumer) {
        int hash = Objects.hash(texture, atlas, cull, consumer);
        return PARTICLE_RENDER_TYPES.computeIfAbsent(hash, h -> {
            RenderType.CompositeState.CompositeStateBuilder state = RenderType.CompositeState.m_110628_().m_173290_((RenderStateShard.EmptyTextureStateShard)GeometryRenderTypes.texture(atlas)).m_173292_(GeometryRenderTypes.shader(texture, PollenShaderTypes.PARTICLE_CUTOUT)).m_110685_(RenderStateShard.f_110134_).m_110661_(cull ? RenderStateShard.f_110158_ : RenderStateShard.f_110110_).m_110671_(RenderStateShard.f_110152_);
            if (consumer != null) {
                consumer.accept(state);
            }
            return RenderType.m_173215_((String)"particle_cutout", (VertexFormat)DefaultVertexFormat.f_85813_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)state.m_110691_(true));
        });
    }

    private static RenderType particleTranslucent(ModelTextureKey texture, GeometryAtlasTexture atlas, boolean cull, @Nullable Consumer<RenderType.CompositeState.CompositeStateBuilder> consumer) {
        int hash = Objects.hash(texture, atlas, cull, consumer);
        return PARTICLE_RENDER_TYPES.computeIfAbsent(hash, h -> {
            RenderType.CompositeState.CompositeStateBuilder state = RenderType.CompositeState.m_110628_().m_173290_((RenderStateShard.EmptyTextureStateShard)GeometryRenderTypes.texture(atlas)).m_173292_(GeometryRenderTypes.shader(texture, PollenShaderTypes.PARTICLE_TRANSLUCENT)).m_110685_(RenderStateShard.f_110139_).m_110661_(cull ? RenderStateShard.f_110158_ : RenderStateShard.f_110110_).m_110671_(RenderStateShard.f_110152_).m_110687_(RenderStateShard.f_110115_);
            if (consumer != null) {
                consumer.accept(state);
            }
            return RenderType.m_173215_((String)"particle_translucent", (VertexFormat)DefaultVertexFormat.f_85813_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)true, (RenderType.CompositeState)state.m_110691_(true));
        });
    }

    public static RenderType entity(ModelTextureKey texture, GeometryAtlasTexture atlas, @Nullable Consumer<RenderType.CompositeState.CompositeStateBuilder> consumer) {
        Objects.requireNonNull(texture, "texture");
        Objects.requireNonNull(atlas, "atlas");
        return switch (Objects.requireNonNull(texture).layer()) {
            default -> throw new IncompatibleClassChangeError();
            case ModelTexture.TextureLayer.SOLID -> GeometryRenderTypes.entitySolid(texture, atlas, false, consumer);
            case ModelTexture.TextureLayer.SOLID_CULL -> GeometryRenderTypes.entitySolid(texture, atlas, true, consumer);
            case ModelTexture.TextureLayer.CUTOUT -> GeometryRenderTypes.entityCutout(texture, atlas, false, consumer);
            case ModelTexture.TextureLayer.CUTOUT_CULL -> GeometryRenderTypes.entityCutout(texture, atlas, true, consumer);
            case ModelTexture.TextureLayer.TRANSLUCENT -> GeometryRenderTypes.entityTranslucent(texture, atlas, false, consumer);
            case ModelTexture.TextureLayer.TRANSLUCENT_CULL -> GeometryRenderTypes.entityTranslucent(texture, atlas, true, consumer);
        };
    }

    public static RenderType particle(ModelTextureKey texture, GeometryAtlasTexture atlas, @Nullable Consumer<RenderType.CompositeState.CompositeStateBuilder> consumer) {
        Objects.requireNonNull(texture, "texture");
        Objects.requireNonNull(atlas, "atlas");
        return switch (Objects.requireNonNull(texture).layer()) {
            default -> throw new IncompatibleClassChangeError();
            case ModelTexture.TextureLayer.SOLID -> GeometryRenderTypes.particleSolid(texture, atlas, false, consumer);
            case ModelTexture.TextureLayer.SOLID_CULL -> GeometryRenderTypes.particleSolid(texture, atlas, true, consumer);
            case ModelTexture.TextureLayer.CUTOUT -> GeometryRenderTypes.particleCutout(texture, atlas, false, consumer);
            case ModelTexture.TextureLayer.CUTOUT_CULL -> GeometryRenderTypes.particleCutout(texture, atlas, true, consumer);
            case ModelTexture.TextureLayer.TRANSLUCENT -> GeometryRenderTypes.particleTranslucent(texture, atlas, false, consumer);
            case ModelTexture.TextureLayer.TRANSLUCENT_CULL -> GeometryRenderTypes.particleTranslucent(texture, atlas, true, consumer);
        };
    }
}

