/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.impl.render.geometry;

import gg.moonflower.pinwheel.api.texture.ModelTexture;
import gg.moonflower.pinwheel.api.texture.TextureTable;
import gg.moonflower.pollen.api.download.v1.FileCache;
import gg.moonflower.pollen.api.pinwheelbridge.v1.PinwheelBridge;
import gg.moonflower.pollen.api.render.geometry.v1.GeometryAtlasTexture;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceMetadata;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.apache.commons.codec.binary.Base32;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class GeometryTextureSpriteUploader
extends SimplePreparableReloadListener<TextureAtlas.Preparations>
implements GeometryAtlasTexture,
AutoCloseable {
    public static final ResourceLocation ATLAS_LOCATION = new ResourceLocation("pollen", "textures/atlas/geometry.png");
    private static final Pattern FROM_LOCATION = Pattern.compile("_");
    private static final Logger LOGGER = LogManager.getLogger();
    private final TextureAtlas textureAtlas = new TextureAtlas(ATLAS_LOCATION);
    private final Set<ModelTexture> textures = new HashSet<ModelTexture>();

    public GeometryTextureSpriteUploader(TextureManager textureManager) {
        textureManager.m_118495_(this.textureAtlas.m_118330_(), (AbstractTexture)this.textureAtlas);
    }

    private static String encodeUrl(String url) {
        return "base32" + new Base32().encodeToString(url.getBytes(StandardCharsets.UTF_8)).toLowerCase(Locale.ROOT).replaceAll("=", "_");
    }

    @Override
    public ResourceLocation getAtlasLocation() {
        return ATLAS_LOCATION;
    }

    @Override
    public TextureAtlasSprite getSprite(ResourceLocation location) {
        return this.textureAtlas.m_118316_(location);
    }

    protected TextureAtlas.Preparations prepare(ResourceManager resourceManager, ProfilerFiller profiler) {
        try (OnlineRepository onlineRepository = new OnlineRepository();){
            profiler.m_7242_();
            profiler.m_6180_("stitching");
            OnlineResourceManager onlineResources = new OnlineResourceManager(resourceManager, onlineRepository, this.textures.stream().filter(texture -> texture.type() == ModelTexture.Type.ONLINE).collect(Collectors.toSet()));
            TextureAtlas.Preparations sheetData = this.textureAtlas.m_118307_((ResourceManager)onlineResources, this.textures.stream().filter(texture -> texture.type() != ModelTexture.Type.UNKNOWN).map(texture -> PinwheelBridge.toLocation(texture.location())).distinct(), profiler, ((Integer)Minecraft.m_91087_().f_91066_.m_232119_().m_231551_()).intValue());
            profiler.m_7238_();
            profiler.m_7241_();
            TextureAtlas.Preparations preparations = sheetData;
            return preparations;
        }
    }

    protected void apply(TextureAtlas.Preparations sheetData, ResourceManager resourceManager, ProfilerFiller profiler) {
        profiler.m_7242_();
        profiler.m_6180_("upload");
        this.textureAtlas.m_118312_(sheetData);
        profiler.m_7238_();
        profiler.m_7241_();
    }

    @Override
    public void close() {
        this.textureAtlas.m_118329_();
    }

    public GeometryTextureSpriteUploader setTextures(Map<ResourceLocation, TextureTable> textures) {
        this.textures.clear();
        this.textures.addAll(textures.values().stream().flatMap(table -> table.getTextureDefinitions().values().stream().flatMap(Arrays::stream)).collect(Collectors.toSet()));
        return this;
    }

    private static class OnlineRepository
    implements AutoCloseable {
        private final ExecutorService executor = FileCache.createOnlineWorker();
        private final FileCache cache = FileCache.timed(this.executor, 1L, TimeUnit.DAYS);
        private final Map<String, CompletableFuture<Path>> resources = new HashMap<String, CompletableFuture<Path>>();

        private OnlineRepository() {
        }

        public CompletableFuture<Path> requestResource(String url, boolean ignoreMissing) {
            return this.resources.computeIfAbsent(url, key -> this.cache.requestResource(url, ignoreMissing));
        }

        @Override
        public void close() {
            this.executor.shutdown();
            try {
                if (!this.executor.awaitTermination(10L, TimeUnit.SECONDS)) {
                    LOGGER.warn("Took more than 10 seconds to terminate online worker");
                }
            }
            catch (Exception e) {
                LOGGER.error("Failed to terminate online worker", (Throwable)e);
            }
        }
    }

    private static class OnlineResourceManager
    implements ResourceManager {
        private static final String PREFIX = "textures/";
        private static final String SUFFIX = ".png";
        private final ResourceManager parent;
        private final OnlineRepository repository;
        private final Map<String, Pair<CompletableFuture<Path>, CompletableFuture<ResourceMetadata>>> onlineLocations;

        private OnlineResourceManager(ResourceManager parent, OnlineRepository repository, Collection<ModelTexture> onlineTextures) {
            this.parent = parent;
            this.repository = repository;
            this.onlineLocations = onlineTextures.stream().map(ModelTexture::data).distinct().collect(Collectors.toMap(url -> url, this::updateCache));
        }

        @Nullable
        private static String decodeUrl(ResourceLocation location) {
            String[] parts = location.m_135815_().substring(PREFIX.length(), location.m_135815_().length() - SUFFIX.length()).split("/");
            if (parts[parts.length - 1].startsWith("base32")) {
                return new String(new Base32().decode(FROM_LOCATION.matcher(parts[parts.length - 1].substring(6).toUpperCase(Locale.ROOT)).replaceAll("=")));
            }
            return null;
        }

        private static InputStream read(CompletableFuture<Path> pathFuture) throws IOException {
            try {
                Path path = pathFuture.get();
                if (path == null) {
                    throw new FileNotFoundException();
                }
                return new FileInputStream(path.toFile());
            }
            catch (InterruptedException | ExecutionException e) {
                throw new IOException(e);
            }
        }

        private Pair<CompletableFuture<Path>, CompletableFuture<ResourceMetadata>> updateCache(String url) {
            String extension = FilenameUtils.getExtension((String)url);
            String[] urlParts = url.split("." + extension);
            String metadataUrl = urlParts.length <= 1 ? url + ".mcmeta" : urlParts[0] + extension + ".mcmeta" + urlParts[1];
            CompletableFuture<Path> texturePath = this.repository.requestResource(url, false);
            CompletionStage metadataPath = this.repository.requestResource(metadataUrl, true).thenApplyAsync(path -> {
                ResourceMetadata resourceMetadata;
                block8: {
                    InputStream stream = OnlineResourceManager.read(CompletableFuture.completedFuture(path));
                    try {
                        resourceMetadata = ResourceMetadata.m_215580_((InputStream)stream);
                        if (stream == null) break block8;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (stream != null) {
                                try {
                                    stream.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception ignored) {
                            return ResourceMetadata.f_215577_;
                        }
                    }
                    stream.close();
                }
                return resourceMetadata;
            }, (Executor)Util.m_183992_());
            return Pair.of(texturePath, (Object)metadataPath);
        }

        private Optional<Resource> getOnlineResource(ResourceLocation location) {
            String url = OnlineResourceManager.decodeUrl(location);
            if (url != null && this.onlineLocations.containsKey(url)) {
                return Optional.of(this.createResource(url));
            }
            return Optional.empty();
        }

        private Resource createResource(String url) {
            Pair<CompletableFuture<Path>, CompletableFuture<ResourceMetadata>> files = this.onlineLocations.get(url);
            return new Resource("online", () -> OnlineResourceManager.read((CompletableFuture)files.getLeft()), () -> (ResourceMetadata)((CompletableFuture)files.getRight()).join());
        }

        public Set<String> m_7187_() {
            return this.parent.m_7187_();
        }

        public List<Resource> m_213829_(ResourceLocation location) {
            List resources = this.parent.m_213829_(location);
            Optional<Resource> online = this.getOnlineResource(location);
            return online.map(resource -> Stream.concat(resources.stream(), Stream.of(resource)).toList()).orElse(resources);
        }

        public Map<ResourceLocation, Resource> m_214159_(String prefix, Predicate<ResourceLocation> filter) {
            Map resources = this.parent.m_214159_(prefix, filter);
            if (PREFIX.startsWith(prefix)) {
                for (String url : this.onlineLocations.keySet()) {
                    ResourceLocation location = new ResourceLocation("online", PREFIX + GeometryTextureSpriteUploader.encodeUrl(url) + SUFFIX);
                    if (!filter.test(location)) continue;
                    resources.put(location, this.createResource(url));
                }
            }
            return resources;
        }

        public Map<ResourceLocation, List<Resource>> m_214160_(String prefix, Predicate<ResourceLocation> filter) {
            Map resources = this.parent.m_214160_(prefix, filter);
            if (PREFIX.startsWith(prefix)) {
                for (String url : this.onlineLocations.keySet()) {
                    ResourceLocation location = new ResourceLocation("online", PREFIX + GeometryTextureSpriteUploader.encodeUrl(url) + SUFFIX);
                    if (!filter.test(location)) continue;
                    resources.put(location, List.of(this.createResource(url)));
                }
            }
            return resources;
        }

        public Optional<Resource> m_213713_(ResourceLocation location) {
            return this.getOnlineResource(location).or(() -> this.parent.m_213713_(location));
        }

        public Stream<PackResources> m_7536_() {
            return this.parent.m_7536_();
        }
    }
}

