/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.impl.render.geometry.texture;

import gg.moonflower.pinwheel.api.geometry.GeometryModelParser;
import gg.moonflower.pinwheel.api.texture.ModelTexture;
import gg.moonflower.pinwheel.api.texture.TextureTable;
import gg.moonflower.pollen.api.render.util.v1.BackgroundLoader;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class LocalTextureTableLoader
implements BackgroundLoader<Map<ResourceLocation, TextureTable>> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String FOLDER = "pinwheel/textures";

    @Override
    public CompletableFuture<Map<ResourceLocation, TextureTable>> reload(ResourceManager resourceManager, Executor backgroundExecutor, Executor gameExecutor) {
        return CompletableFuture.supplyAsync(() -> {
            HashMap<ResourceLocation, TextureTable> textureLocations = new HashMap<ResourceLocation, TextureTable>();
            for (Map.Entry entry : resourceManager.m_214159_(FOLDER, name -> name.m_135815_().endsWith(".json")).entrySet()) {
                ResourceLocation location = (ResourceLocation)entry.getKey();
                ResourceLocation textureTableName = new ResourceLocation(location.m_135827_(), location.m_135815_().substring(FOLDER.length() + 1, location.m_135815_().length() - 5));
                try {
                    BufferedReader reader = ((Resource)entry.getValue()).m_215508_();
                    try {
                        TextureTable table = GeometryModelParser.parseTextures((Reader)reader);
                        table.getTextureDefinitions().forEach((name, textures) -> {
                            for (ModelTexture texture : textures) {
                                if (texture.type() != ModelTexture.Type.ONLINE) continue;
                                throw new IllegalArgumentException(name + " uses unsupported texture type: " + texture.type().name().toLowerCase());
                            }
                        });
                        textureLocations.put(textureTableName, table);
                    }
                    finally {
                        if (reader == null) continue;
                        reader.close();
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Failed to load texture table '" + textureTableName + "'", (Throwable)e);
                }
            }
            return textureLocations;
        }, backgroundExecutor);
    }
}

