/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.registry;

import com.google.common.collect.ImmutableSet;
import com.jozufozu.flywheel.core.PartialModel;
import com.railwayteam.railways.Railways;
import com.railwayteam.railways.content.custom_tracks.NoCollisionCustomTrackBlock;
import com.railwayteam.railways.content.custom_tracks.monorail.MonorailTrackBlock;
import com.railwayteam.railways.content.custom_tracks.narrow_gauge.NarrowGaugeTrackBlock;
import com.railwayteam.railways.content.custom_tracks.phantom.PhantomTrackBlock;
import com.railwayteam.railways.content.custom_tracks.wide_gauge.WideGaugeTrackBlock;
import com.railwayteam.railways.mixin.AccessorBlockEntityType;
import com.railwayteam.railways.registry.CRBlocks;
import com.simibubi.create.content.trains.track.TrackBlock;
import com.simibubi.create.content.trains.track.TrackMaterial;
import com.simibubi.create.content.trains.track.TrackMaterialFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import org.jetbrains.annotations.Nullable;

public class CRTrackMaterials {
    public static final TrackMaterial ACACIA = TrackMaterialFactory.make((ResourceLocation)Railways.asResource("acacia")).lang("Acacia").block(() -> CRBlocks.ACACIA_TRACK).particle(new ResourceLocation("block/acacia_planks")).sleeper(new ItemLike[]{Blocks.f_50402_}).standardModels().build();
    public static final TrackMaterial BIRCH = TrackMaterialFactory.make((ResourceLocation)Railways.asResource("birch")).lang("Birch").block(() -> CRBlocks.BIRCH_TRACK).particle(new ResourceLocation("block/birch_planks")).sleeper(new ItemLike[]{Blocks.f_50400_}).standardModels().build();
    public static final TrackMaterial CRIMSON = TrackMaterialFactory.make((ResourceLocation)Railways.asResource("crimson")).lang("Crimson").block(() -> CRBlocks.CRIMSON_TRACK).particle(new ResourceLocation("block/crimson_planks")).sleeper(new ItemLike[]{Blocks.f_50657_}).rails(new ItemLike[]{Items.f_42587_}).standardModels().build();
    public static final TrackMaterial DARK_OAK = TrackMaterialFactory.make((ResourceLocation)Railways.asResource("dark_oak")).lang("Dark Oak").block(() -> CRBlocks.DARK_OAK_TRACK).particle(new ResourceLocation("block/dark_oak_planks")).sleeper(new ItemLike[]{Blocks.f_50403_}).standardModels().build();
    public static final TrackMaterial JUNGLE = TrackMaterialFactory.make((ResourceLocation)Railways.asResource("jungle")).lang("Jungle").block(() -> CRBlocks.JUNGLE_TRACK).particle(new ResourceLocation("block/jungle_planks")).sleeper(new ItemLike[]{Blocks.f_50401_}).standardModels().build();
    public static final TrackMaterial OAK = TrackMaterialFactory.make((ResourceLocation)Railways.asResource("oak")).lang("Oak").block(() -> CRBlocks.OAK_TRACK).particle(new ResourceLocation("block/oak_planks")).sleeper(new ItemLike[]{Blocks.f_50398_}).standardModels().build();
    public static final TrackMaterial SPRUCE = TrackMaterialFactory.make((ResourceLocation)Railways.asResource("spruce")).lang("Spruce").block(() -> CRBlocks.SPRUCE_TRACK).particle(new ResourceLocation("block/spruce_planks")).sleeper(new ItemLike[]{Blocks.f_50399_}).standardModels().build();
    public static final TrackMaterial WARPED = TrackMaterialFactory.make((ResourceLocation)Railways.asResource("warped")).lang("Warped").block(() -> CRBlocks.WARPED_TRACK).particle(new ResourceLocation("block/warped_planks")).sleeper(new ItemLike[]{Blocks.f_50658_}).rails(new ItemLike[]{Items.f_42587_}).standardModels().build();
    public static final TrackMaterial BLACKSTONE = TrackMaterialFactory.make((ResourceLocation)Railways.asResource("blackstone")).lang("Blackstone").block(() -> CRBlocks.BLACKSTONE_TRACK).particle(new ResourceLocation("block/blackstone")).sleeper(new ItemLike[]{Blocks.f_50733_}).rails(new ItemLike[]{Items.f_42587_}).standardModels().build();
    public static final TrackMaterial MANGROVE = TrackMaterialFactory.make((ResourceLocation)Railways.asResource("mangrove")).lang("Mangrove").block(() -> CRBlocks.MANGROVE_TRACK).particle(new ResourceLocation("block/mangrove_planks")).sleeper(new ItemLike[]{Blocks.f_220851_}).standardModels().build();
    public static final TrackMaterial MONORAIL = TrackMaterialFactory.make((ResourceLocation)Railways.asResource("monorail")).lang("Monorail").block(() -> CRBlocks.MONORAIL_TRACK).particle(Railways.asResource("block/monorail/monorail")).trackType(CRTrackType.MONORAIL).noRecipeGen().customModels(() -> () -> new PartialModel(Railways.asResource("block/monorail/monorail/monorail_half")), () -> () -> new PartialModel(Railways.asResource("block/empty")), () -> () -> new PartialModel(Railways.asResource("block/empty"))).build();
    public static final TrackMaterial ENDER = TrackMaterialFactory.make((ResourceLocation)Railways.asResource("ender")).lang("Ender").block(() -> CRBlocks.ENDER_TRACK).particle(new ResourceLocation("block/end_stone")).sleeper(new ItemLike[]{Blocks.f_50648_}).standardModels().build();
    public static final TrackMaterial TIELESS = TrackMaterialFactory.make((ResourceLocation)Railways.asResource("tieless")).lang("Tieless").block(() -> CRBlocks.TIELESS_TRACK).particle(new ResourceLocation("block/glass")).sleeper(new ItemLike[]{Blocks.f_50185_}).customBlockFactory(NoCollisionCustomTrackBlock::new).standardModels().build();
    public static final TrackMaterial PHANTOM = TrackMaterialFactory.make((ResourceLocation)Railways.asResource("phantom")).lang("Phantom").block(() -> CRBlocks.PHANTOM_TRACK).particle(new ResourceLocation("block/glass")).noRecipeGen().trackType(CRTrackType.UNIVERSAL).customBlockFactory(PhantomTrackBlock::new).standardModels().build();
    public static final TrackMaterial WIDE_GAUGE_ANDESITE = CRTrackMaterials.wideVariant(TrackMaterial.ANDESITE);
    public static final TrackMaterial NARROW_GAUGE_ANDESITE = CRTrackMaterials.narrowVariant(TrackMaterial.ANDESITE);
    public static final Map<TrackMaterial, TrackMaterial> WIDE_GAUGE = new HashMap<TrackMaterial, TrackMaterial>();
    public static final Map<TrackMaterial, TrackMaterial> WIDE_GAUGE_REVERSE = new HashMap<TrackMaterial, TrackMaterial>();
    public static final Map<TrackMaterial, TrackMaterial> NARROW_GAUGE = new HashMap<TrackMaterial, TrackMaterial>();
    public static final Map<TrackMaterial, TrackMaterial> NARROW_GAUGE_REVERSE = new HashMap<TrackMaterial, TrackMaterial>();

    public static TrackMaterial getWide(TrackMaterial material) {
        return WIDE_GAUGE.get(material);
    }

    @Nullable
    public static TrackMaterial getBaseFromWide(TrackMaterial material) {
        if (!WIDE_GAUGE_REVERSE.containsKey(material)) {
            return null;
        }
        return WIDE_GAUGE_REVERSE.get(material);
    }

    private static TrackMaterial wideVariant(TrackMaterial material) {
        Object path = "";
        if (!material.id.m_135827_().equals("railways")) {
            path = material.id.m_135827_() + "_";
        }
        path = (String)path + material.id.m_135815_() + "_wide";
        return TrackMaterialFactory.make((ResourceLocation)Railways.asResource((String)path)).lang("Wide " + material.langName).trackType(CRTrackType.WIDE_GAUGE).block(() -> CRBlocks.WIDE_GAUGE_TRACKS.get(WIDE_GAUGE.get(material))).particle(material.particle).noRecipeGen().standardModels().build();
    }

    public static TrackMaterial getNarrow(TrackMaterial material) {
        return NARROW_GAUGE.get(material);
    }

    @Nullable
    public static TrackMaterial getBaseFromNarrow(TrackMaterial material) {
        if (!NARROW_GAUGE_REVERSE.containsKey(material)) {
            return null;
        }
        return NARROW_GAUGE_REVERSE.get(material);
    }

    private static TrackMaterial narrowVariant(TrackMaterial material) {
        Object path = "";
        if (!material.id.m_135827_().equals("railways")) {
            path = material.id.m_135827_() + "_";
        }
        path = (String)path + material.id.m_135815_() + "_narrow";
        return TrackMaterialFactory.make((ResourceLocation)Railways.asResource((String)path)).lang("Narrow " + material.langName).trackType(CRTrackType.NARROW_GAUGE).block(() -> CRBlocks.NARROW_GAUGE_TRACKS.get(NARROW_GAUGE.get(material))).particle(material.particle).noRecipeGen().standardModels().build();
    }

    public static void register() {
    }

    public static void addToBlockEntityType(TrackBlock block) {
        BlockEntityType type;
        try {
            type = block.getBlockEntityType();
        }
        catch (NullPointerException ignored) {
            return;
        }
        ImmutableSet validBlocks = ((AccessorBlockEntityType)type).getValidBlocks();
        validBlocks = new ImmutableSet.Builder().add((Object[])((Block[])validBlocks.toArray(Block[]::new))).add((Object)block).build();
        ((AccessorBlockEntityType)type).setValidBlocks((Set<Block>)validBlocks);
    }

    static {
        WIDE_GAUGE.put(TrackMaterial.ANDESITE, WIDE_GAUGE_ANDESITE);
        WIDE_GAUGE_REVERSE.put(WIDE_GAUGE_ANDESITE, TrackMaterial.ANDESITE);
        for (TrackMaterial baseMaterial : TrackMaterial.allFromMod((String)"railways")) {
            if (baseMaterial.trackType != TrackMaterial.TrackType.STANDARD) continue;
            TrackMaterial wideMaterial = CRTrackMaterials.wideVariant(baseMaterial);
            WIDE_GAUGE.put(baseMaterial, wideMaterial);
            WIDE_GAUGE_REVERSE.put(wideMaterial, baseMaterial);
        }
        NARROW_GAUGE.put(TrackMaterial.ANDESITE, NARROW_GAUGE_ANDESITE);
        NARROW_GAUGE_REVERSE.put(NARROW_GAUGE_ANDESITE, TrackMaterial.ANDESITE);
        for (TrackMaterial baseMaterial : TrackMaterial.allFromMod((String)"railways")) {
            if (baseMaterial.trackType != TrackMaterial.TrackType.STANDARD) continue;
            TrackMaterial narrowMaterial = CRTrackMaterials.narrowVariant(baseMaterial);
            NARROW_GAUGE.put(baseMaterial, narrowMaterial);
            NARROW_GAUGE_REVERSE.put(narrowMaterial, baseMaterial);
        }
    }

    public static class CRTrackType
    extends TrackMaterial.TrackType {
        public static final TrackMaterial.TrackType MONORAIL = new CRTrackType(Railways.asResource("monorail"), MonorailTrackBlock::new);
        public static final TrackMaterial.TrackType WIDE_GAUGE = new CRTrackType(Railways.asResource("wide_gauge"), WideGaugeTrackBlock::new);
        public static final TrackMaterial.TrackType NARROW_GAUGE = new CRTrackType(Railways.asResource("narrow_gauge"), NarrowGaugeTrackBlock::new);
        public static final TrackMaterial.TrackType UNIVERSAL = new CRTrackType(Railways.asResource("universal"), TrackBlock::new);

        public CRTrackType(ResourceLocation id, TrackMaterial.TrackType.TrackBlockFactory factory) {
            super(id, factory);
        }
    }
}

