/*
 * Decompiled with CFR 0.152.
 */
package jeresources.collection;

import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;

public class TradeList
extends LinkedList<Trade> {
    private static final Random r = new Random();
    private AbstractVillager entity;

    public TradeList(AbstractVillager entity) {
        this.entity = entity;
    }

    public List<ItemStack> getCostAs() {
        return this.stream().map(Trade::getMinCostA).collect(Collectors.toList());
    }

    public List<ItemStack> getCostBs() {
        return this.stream().map(Trade::getMinCostB).filter(itemStack -> !itemStack.m_41619_()).collect(Collectors.toList());
    }

    public List<ItemStack> getResults() {
        return this.stream().map(Trade::getMinResult).collect(Collectors.toList());
    }

    public TradeList getSubListSell(ItemStack itemStack) {
        return this.stream().filter(trade -> trade.sellsItem(itemStack)).collect(Collectors.toCollection(() -> new TradeList(this.entity)));
    }

    public TradeList getSubListBuy(ItemStack itemStack) {
        return this.stream().filter(trade -> trade.buysItem(itemStack)).collect(Collectors.toCollection(() -> new TradeList(this.entity)));
    }

    public TradeList getFocusedList(IFocus<ItemStack> focus) {
        if (focus == null) {
            return this;
        }
        return switch (focus.getRole()) {
            case RecipeIngredientRole.INPUT -> this.getSubListBuy((ItemStack)focus.getTypedValue().getIngredient());
            case RecipeIngredientRole.OUTPUT -> this.getSubListSell((ItemStack)focus.getTypedValue().getIngredient());
            default -> this;
        };
    }

    private void addMerchantRecipe(MerchantOffers merchantOffers, VillagerTrades.ItemListing itemListing, RandomSource rand) {
        MerchantOffer offer = itemListing.m_213663_((Entity)this.entity, rand);
        if (offer != null) {
            merchantOffers.add((Object)offer);
        }
    }

    public void addITradeList(VillagerTrades.ItemListing[] itemListings) {
        for (VillagerTrades.ItemListing itemListing : itemListings) {
            int maxResult;
            int minCostB;
            int maxCostB;
            int maxCostA;
            MerchantOffers tempList = new MerchantOffers();
            RandomSource rand = RandomSource.m_216327_();
            for (int itr = 0; itr < 100; ++itr) {
                this.addMerchantRecipe(tempList, itemListing, rand);
            }
            if (tempList.size() == 0) {
                return;
            }
            ItemStack costA = ((MerchantOffer)tempList.get(0)).m_45358_();
            ItemStack costB = ((MerchantOffer)tempList.get(0)).m_45364_();
            ItemStack result = ((MerchantOffer)tempList.get(0)).m_45368_();
            int minCostA = maxCostA = costA.m_41613_();
            if (!costB.m_41619_()) {
                minCostB = maxCostB = costB.m_41613_();
            } else {
                maxCostB = 1;
                minCostB = 1;
            }
            int minResult = maxResult = result.m_41613_();
            for (MerchantOffer merchantRecipe : tempList) {
                if (minCostA > merchantRecipe.m_45352_().m_41613_()) {
                    minCostA = merchantRecipe.m_45358_().m_41613_();
                }
                if (!costB.m_41619_() && minCostB > merchantRecipe.m_45364_().m_41613_()) {
                    minCostB = merchantRecipe.m_45364_().m_41613_();
                }
                if (minResult > merchantRecipe.m_45368_().m_41613_()) {
                    minResult = merchantRecipe.m_45368_().m_41613_();
                }
                if (maxCostA < merchantRecipe.m_45358_().m_41613_()) {
                    maxCostA = merchantRecipe.m_45358_().m_41613_();
                }
                if (!costB.m_41619_() && maxCostB < merchantRecipe.m_45364_().m_41613_()) {
                    maxCostB = merchantRecipe.m_45358_().m_41613_();
                }
                if (maxResult >= merchantRecipe.m_45368_().m_41613_()) continue;
                maxResult = merchantRecipe.m_45368_().m_41613_();
            }
            this.add(new Trade(costA, minCostA, maxCostA, costB, minCostB, maxCostB, result, minResult, maxResult));
        }
    }

    public static class Trade {
        private final ItemStack costA;
        private final ItemStack costB;
        private final ItemStack result;
        private final int minCostA;
        private final int minCostB;
        private final int minResult;
        private final int maxCostA;
        private final int maxCostB;
        private final int maxResult;

        Trade(ItemStack costA, int minCostA, int maxCostA, ItemStack costB, int minCostB, int maxCostB, ItemStack result, int minResult, int maxResult) {
            this.costA = costA;
            this.minCostA = minCostA;
            this.maxCostA = maxCostA;
            this.costB = costB;
            this.minCostB = minCostB;
            this.maxCostB = maxCostB;
            this.result = result;
            this.minResult = minResult;
            this.maxResult = maxResult;
        }

        public boolean sellsItem(ItemStack itemStack) {
            return this.result.m_41656_(itemStack);
        }

        public boolean buysItem(ItemStack itemStack) {
            return this.costA.m_41656_(itemStack) || !this.costB.m_41619_() && this.costB.m_41656_(itemStack);
        }

        public ItemStack getMinCostA() {
            ItemStack minBuyStack = this.costA.m_41777_();
            minBuyStack.m_41764_(this.minCostA);
            return minBuyStack;
        }

        public ItemStack getMinCostB() {
            if (this.costB == null) {
                return ItemStack.f_41583_;
            }
            ItemStack minBuyStack = this.costB.m_41777_();
            minBuyStack.m_41764_(this.minCostB);
            return minBuyStack;
        }

        public ItemStack getMinResult() {
            ItemStack minSellStack = this.result.m_41777_();
            minSellStack.m_41764_(this.minResult);
            return minSellStack;
        }

        public ItemStack getMaxCostA() {
            ItemStack maxBuyStack = this.costA.m_41777_();
            maxBuyStack.m_41764_(this.maxCostA);
            return maxBuyStack;
        }

        public ItemStack getMaxCostB() {
            if (this.costB == null) {
                return ItemStack.f_41583_;
            }
            ItemStack maxBuyStack = this.costB.m_41777_();
            maxBuyStack.m_41764_(this.maxCostB);
            return maxBuyStack;
        }

        public ItemStack getMaxResult() {
            ItemStack maxSellStack = this.result.m_41777_();
            maxSellStack.m_41764_(this.maxResult);
            return maxSellStack;
        }

        public String toString() {
            return "Buy1: " + this.costA + ", Buy2: " + this.costB + ", Sell: " + this.result;
        }
    }
}

