/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import qouteall.imm_ptl.core.ClientWorldLoader;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.ducks.IERayTraceContext;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.global_portals.GlobalPortalStorage;
import qouteall.imm_ptl.core.render.CrossPortalEntityRenderer;
import qouteall.q_misc_util.my_util.LimitedLogger;

public class IPMcHelper {
    public static final LimitedLogger limitedLogger = new LimitedLogger(20);

    public static void foreachNearbyPortals(Level world, Vec3 pos, int range, Consumer<Portal> func) {
        List<Portal> globalPortals = GlobalPortalStorage.getGlobalPortals(world);
        for (Portal globalPortal : globalPortals) {
            if (!(globalPortal.getDistanceToNearestPointInPortal(pos) < (double)(range * 2))) continue;
            func.accept(globalPortal);
        }
        McHelper.foreachEntitiesByPointAndRoughRadius(Portal.class, world, pos, range, func);
    }

    public static List<Portal> getNearbyPortalList(Entity center, double range, Predicate<Portal> predicate) {
        return IPMcHelper.getNearbyPortalList(center.f_19853_, center.m_20182_(), range, predicate);
    }

    public static List<Portal> getNearbyPortalList(Level world, Vec3 pos, double range, Predicate<Portal> predicate) {
        ArrayList<Portal> result = new ArrayList<Portal>();
        IPMcHelper.foreachNearbyPortals(world, pos, (int)range, portal -> {
            if (predicate.test((Portal)portal)) {
                result.add((Portal)portal);
            }
        });
        return result;
    }

    public static Stream<Portal> getNearbyPortals(Entity center, double range) {
        return IPMcHelper.getNearbyPortals(center.f_19853_, center.m_20182_(), range);
    }

    public static Stream<Portal> getNearbyPortals(Level world, Vec3 pos, double range) {
        return IPMcHelper.getNearbyPortalList(world, pos, range, e -> true).stream();
    }

    public static void onClientEntityTick(Entity entity) {
        CrossPortalEntityRenderer.onEntityTickClient(entity);
    }

    public static List<Tuple<Portal, Vec3>> rayTracePortals(Level world, Vec3 start, Vec3 end, boolean includeGlobalPortals, Predicate<Portal> filter) {
        Vec3 middle = start.m_82490_(0.5).m_82549_(end.m_82490_(0.5));
        int chunkRadius = (int)Math.ceil(Math.abs(start.m_82554_(end) / 2.0) / 16.0);
        List<Portal> nearby = McHelper.getEntitiesNearby(world, middle, Portal.class, chunkRadius * 16);
        if (includeGlobalPortals) {
            nearby.addAll(GlobalPortalStorage.getGlobalPortals(world));
        }
        ArrayList<Tuple<Portal, Vec3>> hits = new ArrayList<Tuple<Portal, Vec3>>();
        nearby.forEach(portal -> {
            Vec3 intersection;
            if ((filter == null || filter.test((Portal)portal)) && (intersection = portal.rayTrace(start, end)) != null) {
                hits.add(new Tuple(portal, (Object)intersection));
            }
        });
        hits.sort((pair1, pair2) -> {
            Vec3 intersection1 = (Vec3)pair1.m_14419_();
            Vec3 intersection2 = (Vec3)pair2.m_14419_();
            return (int)Math.signum(intersection1.m_82557_(start) - intersection2.m_82557_(start));
        });
        return hits;
    }

    public static <T> T withSwitchedContext(Level world, Supplier<T> func) {
        if (world.f_46443_) {
            return ClientWorldLoader.withSwitchedWorld((ClientLevel)world, func);
        }
        return func.get();
    }

    private static Tuple<BlockHitResult, List<Portal>> rayTrace(Level world, ClipContext context, boolean includeGlobalPortals, List<Portal> portals) {
        Vec3 start = context.m_45702_();
        Vec3 end = context.m_45693_();
        if (portals.size() > IPGlobal.maxPortalLayer) {
            Vec3 diff = end.m_82546_(start);
            return new Tuple((Object)BlockHitResult.m_82426_((Vec3)end, (Direction)Direction.m_122366_((double)diff.f_82479_, (double)diff.f_82480_, (double)diff.f_82481_), (BlockPos)new BlockPos(end)), portals);
        }
        BlockHitResult hitResult = world.m_45547_(context);
        List<Tuple<Portal, Vec3>> rayTracedPortals = IPMcHelper.rayTracePortals(world, start, end, includeGlobalPortals, Portal::isInteractable);
        if (rayTracedPortals.isEmpty()) {
            return new Tuple((Object)hitResult, portals);
        }
        Tuple<Portal, Vec3> portalHit = rayTracedPortals.get(0);
        Portal portal = (Portal)portalHit.m_14418_();
        Vec3 intersection = (Vec3)portalHit.m_14419_();
        if (hitResult.m_82450_().m_82557_(start) < intersection.m_82557_(start)) {
            return new Tuple((Object)hitResult, portals);
        }
        IERayTraceContext betterContext = (IERayTraceContext)context;
        betterContext.setStart(portal.transformPoint(intersection)).setEnd(portal.transformPoint(end));
        portals.add(portal);
        Level destWorld = portal.getDestinationWorld();
        Tuple recursion = IPMcHelper.withSwitchedContext(destWorld, () -> IPMcHelper.rayTrace(destWorld, context, includeGlobalPortals, portals));
        betterContext.setStart(start).setEnd(end);
        return recursion;
    }

    public static Tuple<BlockHitResult, List<Portal>> rayTrace(Level world, ClipContext context, boolean includeGlobalPortals) {
        return IPMcHelper.rayTrace(world, context, includeGlobalPortals, new ArrayList<Portal>());
    }

    public static boolean hitResultIsMissedOrNull(HitResult hitResult) {
        return hitResult == null || hitResult.m_6662_() == HitResult.Type.MISS;
    }

    public static Component getDisableWarningText() {
        return Component.m_237113_((String)" ").m_7220_((Component)Component.m_237115_((String)"imm_ptl.disable_warning").m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/imm_ptl_client_debug disable_warning")).m_131162_(Boolean.valueOf(true))));
    }
}

