/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.entity.EntitySectionStorage;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.Validate;
import qouteall.imm_ptl.core.CHelper;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.compat.GravityChangerInterface;
import qouteall.imm_ptl.core.ducks.IEEntityTrackingSection;
import qouteall.imm_ptl.core.ducks.IESectionedEntityCache;
import qouteall.imm_ptl.core.ducks.IEThreadedAnvilChunkStorage;
import qouteall.imm_ptl.core.ducks.IEWorld;
import qouteall.imm_ptl.core.mc_utils.MyNbtTextFormatter;
import qouteall.imm_ptl.core.mixin.common.mc_util.IELevelEntityGetterAdapter;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.MiscHelper;
import qouteall.q_misc_util.my_util.DQuaternion;
import qouteall.q_misc_util.my_util.IntBox;

public class McHelper {
    public static IEThreadedAnvilChunkStorage getIEStorage(ResourceKey<Level> dimension) {
        return (IEThreadedAnvilChunkStorage)McHelper.getServerWorld(dimension).m_7726_().f_8325_;
    }

    public static ArrayList<ServerPlayer> getCopiedPlayerList() {
        return new ArrayList<ServerPlayer>(MiscHelper.getServer().m_6846_().m_11314_());
    }

    public static List<ServerPlayer> getRawPlayerList() {
        return MiscHelper.getServer().m_6846_().m_11314_();
    }

    public static Vec3 lastTickPosOf(Entity entity) {
        return new Vec3(entity.f_19854_, entity.f_19855_, entity.f_19856_);
    }

    public static ServerLevel getOverWorldOnServer() {
        return MiscHelper.getServer().m_129880_(Level.f_46428_);
    }

    public static void serverLog(ServerPlayer player, String text) {
        Helper.log(text);
        player.m_5661_((Component)Component.m_237113_((String)text), false);
    }

    public static long getServerGameTime() {
        return McHelper.getOverWorldOnServer().m_46467_();
    }

    public static <T> void performMultiThreadedFindingTaskOnServer(Stream<T> stream, Predicate<T> predicate, IntPredicate taskWatcher, Consumer<T> onFound, Runnable onNotFound, Runnable finalizer) {
        int[] progress = new int[1];
        Helper.SimpleBox<Boolean> isAborted = new Helper.SimpleBox<Boolean>(false);
        Helper.SimpleBox<Runnable> finishBehavior = new Helper.SimpleBox<Runnable>(() -> Helper.err("Error Occured"));
        CompletableFuture<Void> future = CompletableFuture.runAsync(() -> {
            try {
                Object result = stream.peek(obj -> {
                    progress[0] = progress[0] + 1;
                }).filter(predicate).findFirst().orElse(null);
                finishBehavior.obj = result != null ? () -> onFound.accept(result) : onNotFound;
            }
            catch (Throwable t) {
                t.printStackTrace();
                finishBehavior.obj = () -> t.printStackTrace();
            }
        }, Util.m_183991_());
        IPGlobal.serverTaskList.addTask(() -> {
            if (future.isDone()) {
                if (!((Boolean)isAborted.obj).booleanValue()) {
                    ((Runnable)finishBehavior.obj).run();
                    finalizer.run();
                } else {
                    Helper.log("Future done but the task is aborted");
                }
                return true;
            }
            if (future.isCancelled()) {
                Helper.err("The future is cancelled");
                finalizer.run();
                return true;
            }
            if (future.isCompletedExceptionally()) {
                Helper.err("The future is completed exceptionally");
                finalizer.run();
                return true;
            }
            boolean shouldContinue = taskWatcher.test(progress[0]);
            if (!shouldContinue) {
                isAborted.obj = true;
                future.cancel(true);
                finalizer.run();
                return true;
            }
            return false;
        });
    }

    public static <ENTITY extends Entity> List<ENTITY> getEntitiesNearby(Level world, Vec3 center, Class<ENTITY> entityClass, double range) {
        return McHelper.findEntitiesRough(entityClass, world, center, (int)(range / 16.0 + 1.0), e -> true);
    }

    public static <ENTITY extends Entity> List<ENTITY> getEntitiesNearby(Entity center, Class<ENTITY> entityClass, double range) {
        return McHelper.getEntitiesNearby(center.f_19853_, center.m_20182_(), entityClass, range);
    }

    public static int getRenderDistanceOnServer() {
        return McHelper.getIEStorage((ResourceKey<Level>)Level.f_46428_).ip_getWatchDistance();
    }

    public static void setPosAndLastTickPos(Entity entity, Vec3 pos, Vec3 lastTickPos) {
        entity.m_20343_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
        entity.f_19790_ = lastTickPos.f_82479_;
        entity.f_19791_ = lastTickPos.f_82480_;
        entity.f_19792_ = lastTickPos.f_82481_;
        entity.f_19854_ = lastTickPos.f_82479_;
        entity.f_19855_ = lastTickPos.f_82480_;
        entity.f_19856_ = lastTickPos.f_82481_;
    }

    public static Vec3 getEyePos(Entity entity) {
        Vec3 eyeOffset = GravityChangerInterface.invoker.getEyeOffset(entity);
        return entity.m_20182_().m_82549_(eyeOffset);
    }

    public static Vec3 getLastTickEyePos(Entity entity) {
        Vec3 eyeOffset = GravityChangerInterface.invoker.getEyeOffset(entity);
        return McHelper.lastTickPosOf(entity).m_82549_(eyeOffset);
    }

    public static void setEyePos(Entity entity, Vec3 eyePos, Vec3 lastTickEyePos) {
        Vec3 eyeOffset = GravityChangerInterface.invoker.getEyeOffset(entity);
        McHelper.setPosAndLastTickPos(entity, eyePos.m_82546_(eyeOffset), lastTickEyePos.m_82546_(eyeOffset));
    }

    public static double getVehicleY(Entity vehicle, Entity passenger) {
        return passenger.m_20186_() - vehicle.m_6048_() - passenger.m_6049_();
    }

    public static void adjustVehicle(Entity entity) {
        Entity vehicle = entity.m_20202_();
        if (vehicle == null) {
            return;
        }
        Vec3 currVelocity = vehicle.m_20184_();
        double newX = entity.m_20185_();
        double newY = McHelper.getVehicleY(vehicle, entity);
        double newZ = entity.m_20189_();
        vehicle.m_6034_(newX, newY, newZ);
        Vec3 newPos = new Vec3(newX, newY, newZ);
        McHelper.setPosAndLastTickPos(vehicle, newPos, newPos);
        vehicle.m_6453_(newX, newY, newZ, vehicle.m_146908_(), vehicle.m_146909_(), 0, false);
        vehicle.m_20256_(currVelocity);
    }

    public static LevelChunk getServerChunkIfPresent(ResourceKey<Level> dimension, int x, int z) {
        ChunkHolder chunkHolder_ = McHelper.getIEStorage(dimension).ip_getChunkHolder(ChunkPos.m_45589_((int)x, (int)z));
        if (chunkHolder_ == null) {
            return null;
        }
        return chunkHolder_.m_140085_();
    }

    public static LevelChunk getServerChunkIfPresent(ServerLevel world, int x, int z) {
        ChunkHolder chunkHolder_ = ((IEThreadedAnvilChunkStorage)world.m_7726_().f_8325_).ip_getChunkHolder(ChunkPos.m_45589_((int)x, (int)z));
        if (chunkHolder_ == null) {
            return null;
        }
        return chunkHolder_.m_140085_();
    }

    @Deprecated
    public static <ENTITY extends Entity> Stream<ENTITY> getServerEntitiesNearbyWithoutLoadingChunk(Level world, Vec3 center, Class<ENTITY> entityClass, double range) {
        return McHelper.findEntitiesRough(entityClass, world, center, (int)(range / 16.0), e -> true).stream();
    }

    public static void updateBoundingBox(Entity player) {
        player.m_6034_(player.m_20185_(), player.m_20186_(), player.m_20189_());
    }

    public static void updatePosition(Entity entity, Vec3 pos) {
        entity.m_6034_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
    }

    public static <T extends Entity> List<T> getEntitiesRegardingLargeEntities(Level world, AABB box, double maxEntitySizeHalf, Class<T> entityClass, Predicate<T> predicate) {
        return McHelper.findEntitiesByBox(entityClass, world, box, maxEntitySizeHalf, predicate);
    }

    public static Portal copyEntity(Portal portal) {
        Portal newPortal = (Portal)portal.m_6095_().m_20615_(portal.f_19853_);
        Validate.notNull((Object)newPortal);
        newPortal.m_20258_(portal.m_20240_(new CompoundTag()));
        return newPortal;
    }

    public static boolean getDoesRegionFileExist(ResourceKey<Level> toDimension, BlockPos toPos) {
        ChunkPos chunkPos = new ChunkPos(toPos);
        LevelStorageSource.LevelStorageAccess storageSource = MiscHelper.getServer().f_129744_;
        Path regionFilePath = storageSource.m_197394_(toDimension).resolve("region").resolve("r." + chunkPos.m_45610_() + "." + chunkPos.m_45612_() + ".mca");
        return regionFilePath.toFile().exists();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static MutableComponent getLinkText(String link) {
        return Component.m_237113_((String)link).m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, link)).m_131162_(Boolean.valueOf(true)));
    }

    public static void validateOnServerThread() {
        Validate.isTrue((Thread.currentThread() == MiscHelper.getServer().m_6304_() ? 1 : 0) != 0, (String)"must be on server thread", (Object[])new Object[0]);
    }

    public static void invokeCommandAs(Entity commandSender, List<String> commandList) {
        CommandSourceStack commandSource = commandSender.m_20203_().m_81325_(2).m_81324_();
        Commands commandManager = MiscHelper.getServer().m_129892_();
        for (String command : commandList) {
            commandManager.m_230957_(commandSource, command);
        }
    }

    public static void resendSpawnPacketToTrackers(Entity entity) {
        McHelper.getIEStorage((ResourceKey<Level>)entity.f_19853_.m_46472_()).ip_resendSpawnPacketToTrackers(entity);
    }

    public static void sendToTrackers(Entity entity, Packet<?> packet) {
        ChunkMap.TrackedEntity entityTracker = (ChunkMap.TrackedEntity)McHelper.getIEStorage((ResourceKey<Level>)entity.f_19853_.m_46472_()).ip_getEntityTrackerMap().get(entity.m_19879_());
        if (entityTracker == null) {
            return;
        }
        entityTracker.m_140499_(packet);
    }

    @Nullable
    public static AABB getWallBox(Level world, IntBox glassArea) {
        return glassArea.stream().map(blockPos -> {
            VoxelShape collisionShape = world.m_8055_(blockPos).m_60812_((BlockGetter)world, blockPos);
            if (collisionShape.m_83281_()) {
                return null;
            }
            return collisionShape.m_83215_().m_82383_(Vec3.m_82528_((Vec3i)blockPos));
        }).filter(b -> b != null).reduce(AABB::m_82367_).orElse(null);
    }

    public static ChunkAccessor getChunkAccessor(Level world) {
        if (world.m_5776_()) {
            return (arg_0, arg_1) -> ((Level)world).m_6325_(arg_0, arg_1);
        }
        return (x, z) -> McHelper.getServerChunkIfPresent((ServerLevel)world, x, z);
    }

    public static <T extends Entity> List<T> findEntities(Class<T> entityClass, LevelEntityGetter<Entity> entityLookup, int chunkXStart, int chunkXEnd, int chunkYStart, int chunkYEnd, int chunkZStart, int chunkZEnd, Predicate<T> predicate) {
        ArrayList result = new ArrayList();
        McHelper.foreachEntities(entityClass, entityLookup, chunkXStart, chunkXEnd, chunkYStart, chunkYEnd, chunkZStart, chunkZEnd, entity -> {
            if (predicate.test(entity)) {
                result.add(entity);
            }
        });
        return result;
    }

    public static <T extends Entity> void foreachEntities(Class<T> entityClass, LevelEntityGetter<Entity> entityLookup, int chunkXStart, int chunkXEnd, int chunkYStart, int chunkYEnd, int chunkZStart, int chunkZEnd, Consumer<T> consumer) {
        Validate.isTrue((chunkXEnd >= chunkXStart ? 1 : 0) != 0);
        Validate.isTrue((chunkYEnd >= chunkYStart ? 1 : 0) != 0);
        Validate.isTrue((chunkZEnd >= chunkZStart ? 1 : 0) != 0);
        Validate.isTrue((chunkXEnd - chunkXStart < 1000 ? 1 : 0) != 0, (String)"too big", (Object[])new Object[0]);
        Validate.isTrue((chunkZEnd - chunkZStart < 1000 ? 1 : 0) != 0, (String)"too big", (Object[])new Object[0]);
        EntityTypeTest typeFilter = EntityTypeTest.m_156916_(entityClass);
        EntitySectionStorage<?> cache = ((IELevelEntityGetterAdapter)entityLookup).getCache();
        ((IESectionedEntityCache)cache).forEachSectionInBox(chunkXStart, chunkXEnd, chunkYStart, chunkYEnd, chunkZStart, chunkZEnd, entityTrackingSection -> ((IEEntityTrackingSection)entityTrackingSection).myForeach(typeFilter, consumer));
    }

    public static <T extends Entity> List<T> findEntitiesRough(Class<T> entityClass, Level world, Vec3 center, int radiusChunks, Predicate<T> predicate) {
        if (radiusChunks <= 0) {
            radiusChunks = 1;
        }
        if (radiusChunks > 32) {
            radiusChunks = 32;
        }
        ChunkPos chunkPos = new ChunkPos(new BlockPos(center));
        return McHelper.findEntities(entityClass, ((IEWorld)world).portal_getEntityLookup(), chunkPos.f_45578_ - radiusChunks, chunkPos.f_45578_ + radiusChunks, McHelper.getMinSectionY((LevelAccessor)world), McHelper.getMaxSectionYExclusive((LevelAccessor)world) - 1, chunkPos.f_45579_ - radiusChunks, chunkPos.f_45579_ + radiusChunks, predicate);
    }

    public static <T extends Entity> List<T> findEntitiesByBox(Class<T> entityClass, Level world, AABB box, double maxEntityRadius, Predicate<T> predicate) {
        ArrayList result = new ArrayList();
        McHelper.foreachEntitiesByBox(entityClass, world, box, maxEntityRadius, predicate, result::add);
        return result;
    }

    public static <T extends Entity> void foreachEntitiesByBox(Class<T> entityClass, Level world, AABB box, double maxEntityRadius, Predicate<T> predicate, Consumer<T> consumer) {
        McHelper.foreachEntitiesByBoxApproximateRegions(entityClass, world, box, maxEntityRadius, entity -> {
            if (entity.m_20191_().m_82381_(box) && predicate.test(entity)) {
                consumer.accept(entity);
            }
        });
    }

    public static <T extends Entity> void foreachEntitiesByBoxApproximateRegions(Class<T> entityClass, Level world, AABB box, double maxEntityRadius, Consumer<T> consumer) {
        int xMin = (int)Math.floor(box.f_82288_ - maxEntityRadius);
        int yMin = (int)Math.floor(box.f_82289_ - maxEntityRadius);
        int zMin = (int)Math.floor(box.f_82290_ - maxEntityRadius);
        int xMax = (int)Math.ceil(box.f_82291_ + maxEntityRadius);
        int yMax = (int)Math.ceil(box.f_82292_ + maxEntityRadius);
        int zMax = (int)Math.ceil(box.f_82293_ + maxEntityRadius);
        int minChunkY = McHelper.getMinSectionY((LevelAccessor)world);
        int maxChunkYExclusive = McHelper.getMaxSectionYExclusive((LevelAccessor)world);
        McHelper.foreachEntities(entityClass, ((IEWorld)world).portal_getEntityLookup(), xMin >> 4, xMax >> 4, Mth.m_14045_((int)(yMin >> 4), (int)minChunkY, (int)(maxChunkYExclusive - 1)), Mth.m_14045_((int)(yMax >> 4), (int)minChunkY, (int)(maxChunkYExclusive - 1)), zMin >> 4, zMax >> 4, consumer);
    }

    public static <T extends Entity> void foreachEntitiesByPointAndRoughRadius(Class<T> entityClass, Level world, Vec3 point, int roughRadius, Consumer<T> consumer) {
        SectionPos sectionPos = SectionPos.m_123199_((BlockPos)new BlockPos(point));
        int roughRadiusChunks = roughRadius / 16;
        if (roughRadiusChunks == 0) {
            roughRadiusChunks = 1;
        }
        McHelper.foreachEntities(entityClass, ((IEWorld)world).portal_getEntityLookup(), sectionPos.m_123170_() - roughRadiusChunks, sectionPos.m_123170_() + roughRadiusChunks, sectionPos.m_123206_() - roughRadiusChunks, sectionPos.m_123206_() + roughRadiusChunks, sectionPos.m_123222_() - roughRadiusChunks, sectionPos.m_123222_() + roughRadiusChunks, consumer);
    }

    public static ResourceLocation dimensionTypeId(ResourceKey<Level> dimType) {
        return dimType.m_135782_();
    }

    public static <T> String serializeToJson(T object, Codec<T> codec) {
        DataResult r = codec.encode(object, (DynamicOps)JsonOps.INSTANCE, (Object)new JsonObject());
        Either either = r.get();
        JsonElement result = either.left().orElse(null);
        if (result != null) {
            return IPGlobal.gson.toJson(result);
        }
        return either.right().map(DataResult.PartialResult::toString).orElse("");
    }

    public static <T, Serialized> T decodeFailHard(Codec<T> codec, DynamicOps<Serialized> ops, Serialized target) {
        return (T)((Pair)codec.decode(ops, target).getOrThrow(false, s -> {
            throw new MyDecodeException("Cannot decode" + s + target);
        })).getFirst();
    }

    public static <Serialized> Serialized getElementFailHard(DynamicOps<Serialized> ops, Serialized target, String key) {
        return (Serialized)ops.get(target, key).getOrThrow(false, s -> {
            throw new MyDecodeException("Cannot find" + key + s + target);
        });
    }

    public static <T, Serialized> void encode(Codec<T> codec, DynamicOps<Serialized> ops, Serialized target, T object) {
        codec.encode(object, ops, target);
    }

    public static <Serialized, T> T decodeElementFailHard(DynamicOps<Serialized> ops, Serialized input, Codec<T> codec, String key) {
        return McHelper.decodeFailHard(codec, ops, McHelper.getElementFailHard(ops, input, key));
    }

    public static void sendMessageToFirstLoggedPlayer(Component text) {
        Helper.log(text.m_214077_());
        IPGlobal.serverTaskList.addTask(() -> {
            MinecraftServer server = MiscHelper.getServer();
            if (server == null) {
                return false;
            }
            List playerList = server.m_6846_().m_11314_();
            if (playerList.isEmpty()) {
                return false;
            }
            for (ServerPlayer player : playerList) {
                player.m_5661_(text, false);
            }
            return true;
        });
    }

    public static Iterable<Entity> getWorldEntityList(Level world) {
        if (world.m_5776_()) {
            return CHelper.getWorldEntityList(world);
        }
        if (world instanceof ServerLevel) {
            return ((ServerLevel)world).m_8583_();
        }
        return (Iterable)((Object)Collections.emptyList().iterator());
    }

    public static void spawnServerEntity(Entity entity) {
        Validate.isTrue((!entity.f_19853_.m_5776_() ? 1 : 0) != 0);
        boolean spawned = entity.f_19853_.m_7967_(entity);
        if (!spawned) {
            Helper.err("Failed to spawn " + entity + entity.f_19853_);
        }
    }

    public static ServerLevel getServerWorld(ResourceKey<Level> dim) {
        ServerLevel world = MiscHelper.getServer().m_129880_(dim);
        if (world == null) {
            throw new RuntimeException("Missing dimension " + dim.m_135782_());
        }
        return world;
    }

    public static Component compoundTagToTextSorted(CompoundTag tag, String indent, int depth) {
        return new MyNbtTextFormatter(" ", 0).apply((Tag)tag);
    }

    public static int getMinY(LevelAccessor world) {
        return world.m_141937_();
    }

    public static int getMaxYExclusive(LevelAccessor world) {
        return world.m_151558_();
    }

    public static int getMaxContentYExclusive(LevelAccessor world) {
        return world.m_6042_().f_63865_() + McHelper.getMinY(world);
    }

    public static int getMinSectionY(LevelAccessor world) {
        return world.m_151560_();
    }

    public static int getMaxSectionYExclusive(LevelAccessor world) {
        return world.m_151561_();
    }

    public static int getYSectionNumber(LevelAccessor world) {
        return McHelper.getMaxSectionYExclusive(world) - McHelper.getMinSectionY(world);
    }

    public static AABB getBoundingBoxWithMovedPosition(Entity entity, Vec3 newPos) {
        return entity.m_20191_().m_82383_(newPos.m_82546_(entity.m_20182_()));
    }

    public static String readTextResource(ResourceLocation identifier) {
        String result = null;
        try {
            InputStream inputStream = ((Resource)Minecraft.m_91087_().m_91098_().m_213713_(identifier).get()).m_215507_();
            result = IOUtils.toString((InputStream)inputStream, (Charset)Charset.defaultCharset());
        }
        catch (IOException e) {
            throw new RuntimeException("Error loading " + identifier, e);
        }
        return result;
    }

    public static Vec3 getWorldVelocity(Entity entity) {
        return GravityChangerInterface.invoker.getWorldVelocity(entity);
    }

    public static void setWorldVelocity(Entity entity, Vec3 newVelocity) {
        GravityChangerInterface.invoker.setWorldVelocity(entity, newVelocity);
    }

    public static Vec3 getEyeOffset(Entity entity) {
        return GravityChangerInterface.invoker.getEyeOffset(entity);
    }

    public static Vec3 getAxisWFromOrientation(DQuaternion quaternion) {
        return quaternion.rotate(new Vec3(1.0, 0.0, 0.0));
    }

    public static Vec3 getAxisHFromOrientation(DQuaternion quaternion) {
        return quaternion.rotate(new Vec3(0.0, 1.0, 0.0));
    }

    public static Vec3 getNormalFromOrientation(DQuaternion quaternion) {
        return quaternion.rotate(new Vec3(0.0, 0.0, 1.0));
    }

    public static interface ChunkAccessor {
        public LevelChunk getChunk(int var1, int var2);
    }

    public static class MyDecodeException
    extends RuntimeException {
        public MyDecodeException(String message) {
            super(message);
        }
    }
}

