/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.chunk_loading;

import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.multiplayer.ClientChunkCache;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.game.ClientboundLevelChunkPacketData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.EmptyLevelChunk;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LightChunkGetter;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import qouteall.imm_ptl.core.ClientWorldLoader;
import qouteall.imm_ptl.core.miscellaneous.IPVanillaCopy;
import qouteall.imm_ptl.core.platform_specific.O_O;
import qouteall.q_misc_util.my_util.SignalArged;

@OnlyIn(value=Dist.CLIENT)
@IPVanillaCopy
public class MyClientChunkManager
extends ClientChunkCache {
    private static final Logger LOGGER = LogManager.getLogger();
    protected final LevelChunk f_104408_;
    protected final LevelLightEngine lightingProvider;
    protected final ClientLevel world;
    protected final Long2ObjectLinkedOpenHashMap<LevelChunk> chunkMap = new Long2ObjectLinkedOpenHashMap();
    public static final SignalArged<LevelChunk> clientChunkLoadSignal = new SignalArged();
    public static final SignalArged<LevelChunk> clientChunkUnloadSignal = new SignalArged();

    public MyClientChunkManager(ClientLevel clientWorld, int loadDistance) {
        super(clientWorld, loadDistance);
        this.world = clientWorld;
        this.f_104408_ = new EmptyLevelChunk((Level)clientWorld, new ChunkPos(0, 0), clientWorld.m_5962_().m_175515_(Registry.f_122885_).m_206081_(Biomes.f_48202_));
        this.lightingProvider = new LevelLightEngine((LightChunkGetter)this, true, clientWorld.m_6042_().f_223549_());
    }

    public LevelLightEngine m_7827_() {
        return this.lightingProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void m_104455_(int x, int z) {
        Long2ObjectLinkedOpenHashMap<LevelChunk> long2ObjectLinkedOpenHashMap = this.chunkMap;
        synchronized (long2ObjectLinkedOpenHashMap) {
            ChunkPos chunkPos = new ChunkPos(x, z);
            LevelChunk chunk = (LevelChunk)this.chunkMap.get(chunkPos.m_45588_());
            if (MyClientChunkManager.isValidChunk(chunk, x, z)) {
                this.chunkMap.remove(chunkPos.m_45588_());
                O_O.postClientChunkUnloadEvent(chunk);
                this.world.m_104665_(chunk);
                clientChunkUnloadSignal.emit(chunk);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LevelChunk m_7587_(int x, int z, ChunkStatus chunkStatus, boolean create) {
        Long2ObjectLinkedOpenHashMap<LevelChunk> long2ObjectLinkedOpenHashMap = this.chunkMap;
        synchronized (long2ObjectLinkedOpenHashMap) {
            LevelChunk chunk = (LevelChunk)this.chunkMap.get(ChunkPos.m_45589_((int)x, (int)z));
            if (MyClientChunkManager.isValidChunk(chunk, x, z)) {
                return chunk;
            }
            return create ? this.f_104408_ : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isChunkLoaded(int x, int z) {
        Long2ObjectLinkedOpenHashMap<LevelChunk> long2ObjectLinkedOpenHashMap = this.chunkMap;
        synchronized (long2ObjectLinkedOpenHashMap) {
            return this.chunkMap.containsKey(ChunkPos.m_45589_((int)x, (int)z));
        }
    }

    public BlockGetter m_7653_() {
        return this.world;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LevelChunk m_194116_(int x, int z, FriendlyByteBuf buf, CompoundTag nbt, Consumer<ClientboundLevelChunkPacketData.BlockEntityTagOutput> consumer) {
        LevelChunk worldChunk;
        long chunkPosLong = ChunkPos.m_45589_((int)x, (int)z);
        Long2ObjectLinkedOpenHashMap<LevelChunk> long2ObjectLinkedOpenHashMap = this.chunkMap;
        synchronized (long2ObjectLinkedOpenHashMap) {
            worldChunk = (LevelChunk)this.chunkMap.get(chunkPosLong);
            ChunkPos chunkPos = new ChunkPos(x, z);
            if (!MyClientChunkManager.isValidChunk(worldChunk, x, z)) {
                worldChunk = new LevelChunk((Level)this.world, chunkPos);
                worldChunk.m_187971_(buf, nbt, consumer);
                this.chunkMap.put(chunkPosLong, (Object)worldChunk);
            } else {
                worldChunk.m_187971_(buf, nbt, consumer);
            }
        }
        this.world.m_171649_(new ChunkPos(x, z));
        O_O.postClientChunkLoadEvent(worldChunk);
        clientChunkLoadSignal.emit(worldChunk);
        return worldChunk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LevelChunk> getCopiedChunkList() {
        Long2ObjectLinkedOpenHashMap<LevelChunk> long2ObjectLinkedOpenHashMap = this.chunkMap;
        synchronized (long2ObjectLinkedOpenHashMap) {
            return Arrays.asList((LevelChunk[])this.chunkMap.values().toArray((Object[])new LevelChunk[0]));
        }
    }

    public void m_104459_(int x, int z) {
    }

    public void m_104416_(int r) {
    }

    public String m_6754_() {
        return "Client Chunks (ImmPtl) " + this.m_8482_();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int m_8482_() {
        Long2ObjectLinkedOpenHashMap<LevelChunk> long2ObjectLinkedOpenHashMap = this.chunkMap;
        synchronized (long2ObjectLinkedOpenHashMap) {
            return this.chunkMap.size();
        }
    }

    public void m_6506_(LightLayer lightType, SectionPos chunkSectionPos) {
        ClientWorldLoader.getWorldRenderer((ResourceKey<Level>)this.world.m_46472_()).m_109770_(chunkSectionPos.m_123170_(), chunkSectionPos.m_123206_(), chunkSectionPos.m_123222_());
    }

    protected static boolean isValidChunk(LevelChunk worldChunk, int x, int z) {
        if (worldChunk == null) {
            return false;
        }
        ChunkPos chunkPos = worldChunk.m_7697_();
        return chunkPos.f_45578_ == x && chunkPos.f_45579_ == z;
    }
}

