/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.commands;

import com.google.gson.JsonObject;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.StringRange;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestion;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.RegisterEvent;

public class SubCommandArgumentType
implements ArgumentType<String> {
    public static final SubCommandArgumentType instance = new SubCommandArgumentType();

    public String parse(StringReader reader) throws CommandSyntaxException {
        String remaining = reader.getRemaining();
        reader.setCursor(reader.getCursor() + remaining.length());
        return remaining;
    }

    private static StringRange offset(StringRange range, int offset) {
        return new StringRange(range.getStart() + offset, range.getEnd() + offset);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        CommandNode rootNode = context.getRootNode();
        CommandDispatcher commandDispatcher = new CommandDispatcher((RootCommandNode)rootNode);
        Object source = context.getSource();
        String remaining = builder.getRemaining();
        ParseResults parse = commandDispatcher.parse(remaining, source);
        int deltaCursor = remaining.length();
        CompletableFuture suggestionsFuture = commandDispatcher.getCompletionSuggestions(parse, deltaCursor);
        int offset = builder.getStart();
        return suggestionsFuture.thenApply(suggestions -> new Suggestions(SubCommandArgumentType.offset(suggestions.getRange(), offset), suggestions.getList().stream().map(suggestion -> new Suggestion(SubCommandArgumentType.offset(suggestion.getRange(), offset), suggestion.getText(), suggestion.getTooltip())).collect(Collectors.toList())));
    }

    public Collection<String> getExamples() {
        return List.of("say hi");
    }

    public static String get(CommandContext<?> context, String name) {
        return (String)context.getArgument(name, String.class);
    }

    @SubscribeEvent
    public static void init(RegisterEvent event) {
        ArgumentTypeInfos.registerByClass(SubCommandArgumentType.class, (ArgumentTypeInfo)new CustomArgumentTypeInfo());
    }

    private static class CustomArgumentTypeInfo
    implements ArgumentTypeInfo<SubCommandArgumentType, ArgumentTypeInfo.Template<SubCommandArgumentType>> {
        private CustomArgumentTypeInfo() {
        }

        public void m_214155_(ArgumentTypeInfo.Template<SubCommandArgumentType> template, FriendlyByteBuf friendlyByteBuf) {
        }

        public ArgumentTypeInfo.Template<SubCommandArgumentType> m_213618_(FriendlyByteBuf friendlyByteBuf) {
            return this.getTemplate();
        }

        public void m_213719_(ArgumentTypeInfo.Template<SubCommandArgumentType> template, JsonObject jsonObject) {
        }

        public ArgumentTypeInfo.Template<SubCommandArgumentType> unpack(SubCommandArgumentType argumentType) {
            return this.getTemplate();
        }

        private ArgumentTypeInfo.Template<SubCommandArgumentType> getTemplate() {
            final CustomArgumentTypeInfo this_ = this;
            return new ArgumentTypeInfo.Template<SubCommandArgumentType>(){

                public SubCommandArgumentType instantiate(CommandBuildContext commandBuildContext) {
                    return instance;
                }

                public ArgumentTypeInfo<SubCommandArgumentType, ?> m_213709_() {
                    return this_;
                }
            };
        }
    }
}

