/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.compat;

import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.apache.commons.lang3.Validate;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import qouteall.imm_ptl.core.CHelper;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.IPMcHelper;
import qouteall.imm_ptl.core.platform_specific.O_O;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.my_util.MyTaskList;

public class IPModInfoChecking {
    /*
     * Enabled aggressive exception aggregation
     */
    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public static ImmPtlInfo fetchImmPtlInfoFromInternet() {
        String url = O_O.getImmPtlModInfoUrl();
        if (url == null) {
            Helper.log("Not fetching immptl mod info");
            return null;
        }
        try (CloseableHttpClient httpClient = HttpClientBuilder.create().build();){
            ImmPtlInfo immPtlInfo;
            block23: {
                ImmPtlInfo immPtlInfo2;
                HttpEntity entity;
                CloseableHttpResponse httpResponse;
                block21: {
                    ImmPtlInfo immPtlInfo3;
                    block22: {
                        block19: {
                            ImmPtlInfo immPtlInfo4;
                            block20: {
                                HttpGet request = new HttpGet(url);
                                request.addHeader("User-Agent", "Immersive Portals mod");
                                httpResponse = httpClient.execute((HttpUriRequest)request);
                                try {
                                    int statusCode = httpResponse.getStatusLine().getStatusCode();
                                    if (statusCode == 200) break block19;
                                    Helper.err("Failed to fetch immptl mod info " + statusCode);
                                    immPtlInfo4 = null;
                                    if (httpResponse == null) break block20;
                                }
                                catch (Throwable throwable) {
                                    if (httpResponse != null) {
                                        try {
                                            httpResponse.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                httpResponse.close();
                            }
                            return immPtlInfo4;
                        }
                        entity = httpResponse.getEntity();
                        if (entity != null) break block21;
                        immPtlInfo3 = null;
                        if (httpResponse == null) break block22;
                        httpResponse.close();
                    }
                    return immPtlInfo3;
                }
                String jsonStr = EntityUtils.toString((HttpEntity)entity);
                immPtlInfo = immPtlInfo2 = (ImmPtlInfo)Helper.gson.fromJson(jsonStr, ImmPtlInfo.class);
                if (httpResponse == null) break block23;
                httpResponse.close();
            }
            return immPtlInfo;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void initDedicatedServer() {
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void initClient() {
        Util.m_183991_().execute(() -> {
            if (!IPGlobal.checkModInfoFromInternet) {
                return;
            }
            ImmPtlInfo immPtlInfo = IPModInfoChecking.fetchImmPtlInfoFromInternet();
            if (immPtlInfo == null) {
                return;
            }
            IPGlobal.clientTaskList.addTask(MyTaskList.withDelayCondition(() -> Minecraft.m_91087_().f_91073_ == null, MyTaskList.oneShotTask(() -> {
                for (ModEntry mod : immPtlInfo.severelyIncompatible) {
                    if (mod == null || !mod.isModLoadedWithinVersion()) continue;
                    if (mod.startVersion != null || mod.endVersion != null) {
                        CHelper.printChat((Component)Component.m_237110_((String)"imm_ptl.severely_incompatible_within_version", (Object[])new Object[]{mod.modName, mod.modId, mod.getVersionRangeStr()}).m_130940_(ChatFormatting.RED));
                        continue;
                    }
                    CHelper.printChat((Component)Component.m_237110_((String)"imm_ptl.severely_incompatible", (Object[])new Object[]{mod.modName, mod.modId}).m_130940_(ChatFormatting.RED));
                }
                for (ModEntry mod : immPtlInfo.incompatible) {
                    if (mod == null || !mod.isModLoadedWithinVersion() || !IPGlobal.enableWarning) continue;
                    CHelper.printChat((Component)Component.m_237110_((String)"imm_ptl.incompatible", (Object[])new Object[]{mod.modName, mod.modId}).m_130940_(ChatFormatting.RED).m_7220_(IPMcHelper.getDisableWarningText()));
                }
            })));
        });
        IPGlobal.clientTaskList.addTask(MyTaskList.withDelayCondition(() -> Minecraft.m_91087_().f_91073_ == null, MyTaskList.oneShotTask(() -> {
            List topLevelMods;
            if (IPGlobal.enableWarning && FMLEnvironment.production && (topLevelMods = ModList.get().getModFiles().stream().filter(modContainer -> modContainer.getMods().isEmpty()).collect(Collectors.toList())).size() > 20) {
                CHelper.printChat((Component)Component.m_237113_((String)"[Immersive Portals] WARNING: You are using many mods. It's likely that one of them has compatibility issues with Immersive Portals. If you are sure that there is no compatibility issue, disable this warning.").m_130940_(ChatFormatting.RED).m_7220_(IPMcHelper.getDisableWarningText()));
            }
        })));
    }

    public static final class ImmPtlInfo {
        public LatestReleaseInfo latestRelease;
        public List<ModEntry> severelyIncompatible;
        public List<ModEntry> incompatible;

        public ImmPtlInfo(LatestReleaseInfo latestRelease, List<ModEntry> severelyIncompatible, List<ModEntry> incompatible) {
            this.latestRelease = latestRelease;
            this.severelyIncompatible = severelyIncompatible;
            this.incompatible = incompatible;
        }

        public String toString() {
            return "ImmPtlInfo[latestRelease=" + this.latestRelease + ", severelyIncompatible=" + this.severelyIncompatible + ", incompatible=" + this.incompatible + "]";
        }
    }

    public static final class ModEntry {
        public String modId;
        public String modName;
        @Nullable
        public String startVersion;
        @Nullable
        public String endVersion;

        public ModEntry(String modId, String modName, @Nullable String startVersion, @Nullable String endVersion) {
            this.modId = modId;
            this.modName = modName;
            this.startVersion = startVersion;
            this.endVersion = endVersion;
        }

        boolean isModLoadedWithinVersion() {
            return O_O.isModLoadedWithinVersion(this.modId, this.startVersion, this.endVersion);
        }

        String getVersionRangeStr() {
            if (this.startVersion != null) {
                if (this.endVersion != null) {
                    return this.startVersion + "-" + this.endVersion;
                }
                return this.startVersion + "+";
            }
            Validate.notNull((Object)this.endVersion);
            return "-" + this.endVersion;
        }

        public String toString() {
            return "ModEntry[modId=" + this.modId + ", modName=" + this.modName + ", startVersion=" + this.startVersion + ", endVersion=" + this.endVersion + "]";
        }
    }

    public static final class LatestReleaseInfo {
        public String modVersion;
        public String mcVersion;

        public LatestReleaseInfo(String modVersion, String mcVersion) {
            this.modVersion = modVersion;
            this.mcVersion = mcVersion;
        }

        public String toString() {
            return "LatestReleaseInfo[modVersion=" + this.modVersion + ", mcVersion=" + this.mcVersion + "]";
        }
    }
}

