/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.mixin.common.entity_sync;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityLinkPacket;
import net.minecraft.network.protocol.game.ClientboundSetPassengersPacket;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.chunk.LevelChunk;
import org.apache.commons.lang3.Validate;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.ducks.IEEntityTracker;
import qouteall.imm_ptl.core.ducks.IEThreadedAnvilChunkStorage;
import qouteall.imm_ptl.core.network.PacketRedirection;

@Mixin(value={ChunkMap.class})
public abstract class MixinChunkMap_E
implements IEThreadedAnvilChunkStorage {
    @Shadow
    @Final
    public Int2ObjectMap<ChunkMap.TrackedEntity> f_140150_;
    @Shadow
    @Final
    private ServerLevel f_140133_;

    @Shadow
    abstract void m_140192_(ServerPlayer var1, boolean var2);

    @Inject(method={"Lnet/minecraft/server/level/ChunkMap;removeEntity(Lnet/minecraft/world/entity/Entity;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void onUnloadEntity(Entity entity, CallbackInfo ci) {
        ServerPlayer player;
        if (entity instanceof ServerPlayer && IPGlobal.serverTeleportationManager.isTeleporting(player = (ServerPlayer)entity)) {
            Object tracker = this.f_140150_.remove(entity.m_19879_());
            ((IEEntityTracker)tracker).stopTrackingToAllPlayers_();
            this.m_140192_(player, false);
            ci.cancel();
        }
    }

    @Inject(method={"Lnet/minecraft/server/level/ChunkMap;tick()V"}, at={@At(value="HEAD")}, cancellable=true)
    private void onTickEntityMovement(CallbackInfo ci) {
        ci.cancel();
    }

    @Override
    public void ip_onPlayerUnload(ServerPlayer oldPlayer) {
        this.f_140150_.values().forEach(obj -> obj.m_140485_(oldPlayer));
    }

    @Override
    public void ip_onPlayerDisconnected(ServerPlayer player) {
        this.f_140150_.values().forEach(trackedEntity -> ((IEEntityTracker)trackedEntity).ip_onPlayerDisconnect(player));
    }

    @Override
    public void ip_onDimensionRemove() {
        this.f_140150_.values().forEach(obj -> ((IEEntityTracker)obj).ip_onDimensionRemove());
    }

    @Override
    public void ip_updateEntityTrackersAfterSendingChunkPacket(LevelChunk chunk, ServerPlayer player) {
        ArrayList attachedEntityList = Lists.newArrayList();
        ArrayList passengerList = Lists.newArrayList();
        for (Object entityTracker : this.f_140150_.values()) {
            Entity entity = ((IEEntityTracker)entityTracker).getEntity_();
            if (entity == player || !entity.m_146902_().equals((Object)chunk.m_7697_())) continue;
            ((IEEntityTracker)entityTracker).updateEntityTrackingStatus(player);
            if (entity instanceof Mob && ((Mob)entity).m_21524_() != null) {
                attachedEntityList.add(entity);
            }
            if (entity.m_20197_().isEmpty()) continue;
            passengerList.add(entity);
        }
        PacketRedirection.withForceRedirect(this.f_140133_, () -> {
            for (Entity entity : attachedEntityList) {
                player.f_8906_.m_9829_((Packet)new ClientboundSetEntityLinkPacket(entity, ((Mob)entity).m_21524_()));
            }
            for (Entity entity : passengerList) {
                player.f_8906_.m_9829_((Packet)new ClientboundSetPassengersPacket(entity));
            }
        });
    }

    @Override
    public void ip_resendSpawnPacketToTrackers(Entity entity) {
        Object tracker = this.f_140150_.get(entity.m_19879_());
        Validate.notNull((Object)tracker, (String)"entity not yet tracked", (Object[])new Object[0]);
        ((IEEntityTracker)tracker).resendSpawnPacketToTrackers();
    }

    @Override
    public Int2ObjectMap<ChunkMap.TrackedEntity> ip_getEntityTrackerMap() {
        return this.f_140150_;
    }
}

