/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal.animation;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import qouteall.imm_ptl.core.portal.animation.AnimationContext;
import qouteall.imm_ptl.core.portal.animation.AnimationResult;
import qouteall.imm_ptl.core.portal.animation.DeltaUnilateralPortalState;
import qouteall.q_misc_util.Helper;

public interface PortalAnimationDriver {
    public static final Map<ResourceLocation, Function<CompoundTag, PortalAnimationDriver>> deserializerRegistry = new HashMap<ResourceLocation, Function<CompoundTag, PortalAnimationDriver>>();

    public static void registerDeserializer(ResourceLocation key, Function<CompoundTag, PortalAnimationDriver> deserializer) {
        deserializerRegistry.put(key, deserializer);
    }

    @Nullable
    public static PortalAnimationDriver fromTag(CompoundTag tag) {
        String type = tag.m_128461_("type");
        Function<CompoundTag, PortalAnimationDriver> deserializer = deserializerRegistry.get(new ResourceLocation(type));
        if (deserializer == null) {
            Helper.err("Unknown animation type " + type);
            return null;
        }
        try {
            return deserializer.apply(tag);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public CompoundTag toTag();

    @Nonnull
    public AnimationResult getAnimationResult(long var1, float var3, AnimationContext var4);

    @Nullable
    default public DeltaUnilateralPortalState getEndingResult(long tickTime, AnimationContext context) {
        return null;
    }

    default public PortalAnimationDriver getFlippedVersion() {
        return this;
    }

    default public Component getInfo() {
        return Component.m_237113_((String)"Unknown Animation");
    }
}

