/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal.animation;

import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import qouteall.imm_ptl.core.portal.animation.AnimationContext;
import qouteall.imm_ptl.core.portal.animation.AnimationResult;
import qouteall.imm_ptl.core.portal.animation.DeltaUnilateralPortalState;
import qouteall.imm_ptl.core.portal.animation.PortalAnimationDriver;
import qouteall.imm_ptl.core.portal.animation.TimingFunction;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.my_util.DQuaternion;

public class RotationAnimation
implements PortalAnimationDriver {
    public final Vec3 initialOffset;
    public final Vec3 rotationAxis;
    public final double degreesPerTick;
    public final long startGameTime;
    public final long endGameTime;
    @Nullable
    public final TimingFunction timingFunction;

    public static void init() {
        PortalAnimationDriver.registerDeserializer(new ResourceLocation("imm_ptl:rotation"), RotationAnimation::deserialize);
    }

    public RotationAnimation(Vec3 initialOffset, Vec3 rotationAxis, double degreesPerTick, long startGameTime, long endGameTime, @Nullable TimingFunction timingFunction) {
        this.initialOffset = initialOffset;
        this.rotationAxis = rotationAxis;
        this.degreesPerTick = degreesPerTick;
        this.startGameTime = startGameTime;
        this.endGameTime = endGameTime;
        this.timingFunction = timingFunction;
    }

    @Override
    public CompoundTag toTag() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("type", "imm_ptl:rotation");
        Helper.putVec3d(tag, "initialOffset", this.initialOffset);
        Helper.putVec3d(tag, "rotationAxis", this.rotationAxis);
        tag.m_128347_("degreesPerTick", this.degreesPerTick);
        tag.m_128356_("startGameTime", this.startGameTime);
        tag.m_128356_("endGameTime", this.endGameTime);
        if (this.timingFunction != null) {
            tag.m_128359_("timingFunction", this.timingFunction.toString());
        }
        return tag;
    }

    private static RotationAnimation deserialize(CompoundTag tag) {
        Vec3 initialOffset = Helper.getVec3d(tag, "initialOffset");
        Vec3 rotationAxis = Helper.getVec3d(tag, "rotationAxis");
        double degreesPerTick = tag.m_128459_("degreesPerTick");
        long startGameTime = tag.m_128454_("startGameTime");
        long endGameTime = tag.m_128454_("endGameTime");
        TimingFunction timingFunction = tag.m_128441_("timingFunction") ? TimingFunction.fromString(tag.m_128461_("timingFunction")) : null;
        return new RotationAnimation(initialOffset, rotationAxis, degreesPerTick, startGameTime, endGameTime, timingFunction);
    }

    @Override
    public AnimationResult getAnimationResult(long tickTime, float partialTicks, AnimationContext context) {
        double passedTicks = (double)(tickTime - 1L - this.startGameTime) + (double)partialTicks;
        boolean ended = false;
        long durationTicks = this.endGameTime - this.startGameTime;
        if (passedTicks >= (double)durationTicks) {
            ended = true;
            passedTicks = durationTicks;
        }
        if (this.timingFunction != null) {
            passedTicks = this.timingFunction.mapProgress(passedTicks / (double)durationTicks) * (double)durationTicks;
        }
        double angle = this.degreesPerTick * passedTicks;
        DQuaternion rotation = DQuaternion.rotationByDegrees(this.rotationAxis, angle);
        Vec3 vec = this.initialOffset;
        Vec3 rotatedVec = rotation.rotate(vec);
        Vec3 offset = rotatedVec.m_82546_(vec);
        return new AnimationResult(new DeltaUnilateralPortalState(offset, rotation, null), ended);
    }

    @Override
    @Nullable
    public DeltaUnilateralPortalState getEndingResult(long tickTime, AnimationContext context) {
        if (this.endGameTime == Long.MAX_VALUE) {
            return null;
        }
        return this.getAnimationResult(this.endGameTime, 0.0f, context).delta();
    }

    @Override
    public PortalAnimationDriver getFlippedVersion() {
        return new RotationAnimation(this.initialOffset, this.rotationAxis, this.degreesPerTick, this.startGameTime, this.endGameTime, this.timingFunction);
    }

    @Override
    public Component getInfo() {
        return Component.m_237113_((String)"Rotation[offset=(%.3f %.3f %.3f),axis=(%.3f %.3f %.3f),angVelo=%.3f]".formatted(this.initialOffset.f_82479_, this.initialOffset.f_82480_, this.initialOffset.f_82481_, this.rotationAxis.f_82479_, this.rotationAxis.f_82480_, this.rotationAxis.f_82481_, this.degreesPerTick));
    }

    public static class Builder {
        private Vec3 initialOffset;
        public Vec3 rotationAxis;
        public double degreesPerTick;
        public long startGameTime;
        public long endGameTime;
        public TimingFunction timingFunction;

        public RotationAnimation build() {
            return new RotationAnimation(this.initialOffset, this.rotationAxis, this.degreesPerTick, this.startGameTime, this.endGameTime, this.timingFunction);
        }

        public Builder setInitialOffset(Vec3 initialOffset) {
            this.initialOffset = initialOffset;
            return this;
        }

        public Builder setRotationAxis(Vec3 rotationAxis) {
            this.rotationAxis = rotationAxis;
            return this;
        }

        public Builder setDegreesPerTick(double degreesPerTick) {
            this.degreesPerTick = degreesPerTick;
            return this;
        }

        public Builder setStartGameTime(long startGameTime) {
            this.startGameTime = startGameTime;
            return this;
        }

        public Builder setEndGameTime(long endGameTime) {
            this.endGameTime = endGameTime;
            return this;
        }

        public Builder setTimingFunction(TimingFunction timingFunction) {
            this.timingFunction = timingFunction;
            return this;
        }
    }
}

