/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal.custom_portal_gen.form;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.state.BlockState;
import qouteall.imm_ptl.core.portal.custom_portal_gen.SimpleBlockPredicate;
import qouteall.imm_ptl.core.portal.custom_portal_gen.form.NetherPortalLikeForm;
import qouteall.imm_ptl.core.portal.custom_portal_gen.form.PortalGenForm;
import qouteall.imm_ptl.core.portal.nether_portal.BlockPortalShape;

public class HeterogeneousForm
extends NetherPortalLikeForm {
    public final SimpleBlockPredicate areaBlock;
    public final SimpleBlockPredicate frameBlock;
    public static final Codec<HeterogeneousForm> codec = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("generate_frame_if_not_found").forGetter(o -> o.generateFrameIfNotFound), (App)SimpleBlockPredicate.codec.fieldOf("area_block").forGetter(o -> o.areaBlock), (App)SimpleBlockPredicate.codec.fieldOf("frame_block").forGetter(o -> o.frameBlock)).apply((Applicative)instance, HeterogeneousForm::new));

    public HeterogeneousForm(boolean generateFrameIfNotFound, SimpleBlockPredicate areaBlock, SimpleBlockPredicate frameBlock) {
        super(generateFrameIfNotFound);
        this.areaBlock = areaBlock;
        this.frameBlock = frameBlock;
    }

    @Override
    public void generateNewFrame(ServerLevel fromWorld, BlockPortalShape fromShape, ServerLevel toWorld, BlockPortalShape toShape) {
        BlockPos offset = toShape.innerAreaBox.l.m_121996_((Vec3i)fromShape.innerAreaBox.l);
        fromShape.frameAreaWithoutCorner.forEach(blockPos -> toWorld.m_46597_(blockPos.m_121955_((Vec3i)offset), fromWorld.m_8055_(blockPos)));
    }

    @Override
    public Predicate<BlockState> getOtherSideFramePredicate() {
        return this.frameBlock;
    }

    @Override
    public Predicate<BlockState> getThisSideFramePredicate() {
        return this.frameBlock;
    }

    @Override
    public Predicate<BlockState> getAreaPredicate() {
        return this.areaBlock;
    }

    @Override
    public Codec<? extends PortalGenForm> getCodec() {
        return codec;
    }

    @Override
    public PortalGenForm getReverse() {
        return new HeterogeneousForm(this.generateFrameIfNotFound, this.areaBlock, this.frameBlock);
    }
}

