/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal.custom_portal_gen.form;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import qouteall.imm_ptl.core.portal.custom_portal_gen.PortalGenInfo;
import qouteall.imm_ptl.core.portal.custom_portal_gen.form.NetherPortalLikeForm;
import qouteall.imm_ptl.core.portal.custom_portal_gen.form.PortalGenForm;
import qouteall.imm_ptl.core.portal.nether_portal.BlockPortalShape;
import qouteall.imm_ptl.core.portal.nether_portal.NetherPortalGeneration;
import qouteall.q_misc_util.my_util.IntBox;

public class ScalingSquareForm
extends NetherPortalLikeForm {
    public static final Codec<ScalingSquareForm> codec = RecordCodecBuilder.create(instance -> instance.group((App)Registry.f_122824_.m_194605_().fieldOf("from_frame_block").forGetter(o -> o.fromFrameBlock), (App)Registry.f_122824_.m_194605_().fieldOf("area_block").forGetter(o -> o.areaBlock), (App)Registry.f_122824_.m_194605_().fieldOf("to_frame_block").forGetter(o -> o.toFrameBlock), (App)Codec.INT.fieldOf("from_length").forGetter(o -> o.fromLength), (App)Codec.INT.fieldOf("to_length").forGetter(o -> o.toLength), (App)Codec.BOOL.fieldOf("generate_frame_if_not_found").forGetter(o -> o.generateFrameIfNotFound)).apply((Applicative)instance, instance.stable(ScalingSquareForm::new)));
    public final Block fromFrameBlock;
    public final Block areaBlock;
    public final Block toFrameBlock;
    public final int fromLength;
    public final int toLength;

    public ScalingSquareForm(Block fromFrameBlock, Block areaBlock, Block toFrameBlock, int fromLength, int toLength, boolean generateFrameIfNotFound) {
        super(generateFrameIfNotFound);
        this.fromFrameBlock = fromFrameBlock;
        this.areaBlock = areaBlock;
        this.toFrameBlock = toFrameBlock;
        this.fromLength = fromLength;
        this.toLength = toLength;
    }

    @Override
    public Codec<? extends PortalGenForm> getCodec() {
        return codec;
    }

    @Override
    public PortalGenForm getReverse() {
        return new ScalingSquareForm(this.toFrameBlock, this.areaBlock, this.fromFrameBlock, this.toLength, this.fromLength, this.generateFrameIfNotFound);
    }

    @Override
    public boolean testThisSideShape(ServerLevel fromWorld, BlockPortalShape fromShape) {
        boolean isSquareShape = BlockPortalShape.isSquareShape(fromShape, this.fromLength);
        return isSquareShape;
    }

    @Override
    public Function<WorldGenRegion, Function<BlockPos.MutableBlockPos, PortalGenInfo>> getFrameMatchingFunc(ServerLevel fromWorld, ServerLevel toWorld, BlockPortalShape fromShape) {
        BlockPortalShape template = this.getTemplateToShape(fromShape);
        Predicate<BlockState> areaPredicate = this.getAreaPredicate();
        Predicate<BlockState> otherSideFramePredicate = this.getOtherSideFramePredicate();
        BlockPos.MutableBlockPos temp2 = new BlockPos.MutableBlockPos();
        return region -> blockPos -> {
            BlockPortalShape result = template.matchShapeWithMovedFirstFramePos(pos -> areaPredicate.test(region.m_8055_(pos)), pos -> otherSideFramePredicate.test(region.m_8055_(pos)), (BlockPos)blockPos, temp2);
            if (result != null && (fromWorld != toWorld || fromShape.anchor != result.anchor)) {
                return new PortalGenInfo((ResourceKey<Level>)fromWorld.m_46472_(), (ResourceKey<Level>)toWorld.m_46472_(), fromShape, result, null, this.getScale());
            }
            return null;
        };
    }

    private double getScale() {
        return (double)this.toLength / (double)this.fromLength;
    }

    private BlockPortalShape getTemplateToShape(BlockPortalShape fromShape) {
        return BlockPortalShape.getSquareShapeTemplate(fromShape.axis, this.toLength);
    }

    @Override
    public void generateNewFrame(ServerLevel fromWorld, BlockPortalShape fromShape, ServerLevel toWorld, BlockPortalShape toShape) {
        for (BlockPos blockPos : toShape.frameAreaWithCorner) {
            toWorld.m_46597_(blockPos, this.toFrameBlock.m_49966_());
        }
    }

    @Override
    public PortalGenInfo getNewPortalPlacement(ServerLevel toWorld, BlockPos toPos, ServerLevel fromWorld, BlockPortalShape fromShape) {
        BlockPortalShape templateShape = this.getTemplateToShape(fromShape);
        IntBox airCubePlacement = NetherPortalGeneration.findAirCubePlacement(toWorld, toPos, templateShape.axis, templateShape.totalAreaBox.getSize());
        BlockPortalShape placedShape = templateShape.getShapeWithMovedTotalAreaBox(airCubePlacement);
        return new PortalGenInfo((ResourceKey<Level>)fromWorld.m_46472_(), (ResourceKey<Level>)toWorld.m_46472_(), fromShape, placedShape, null, this.getScale());
    }

    @Override
    public Predicate<BlockState> getOtherSideFramePredicate() {
        return s -> s.m_60734_() == this.toFrameBlock;
    }

    @Override
    public Predicate<BlockState> getThisSideFramePredicate() {
        return s -> s.m_60734_() == this.fromFrameBlock;
    }

    @Override
    public Predicate<BlockState> getAreaPredicate() {
        return s -> s.m_60734_() == this.areaBlock;
    }
}

