/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.render.context_management;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import java.util.List;
import java.util.Stack;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.world.phys.Vec3;
import qouteall.imm_ptl.core.ducks.IECamera;

public class WorldRenderInfo {
    public final ClientLevel world;
    public final Vec3 cameraPos;
    public final boolean overwriteCameraTransformation;
    @Nullable
    public final Matrix4f cameraTransformation;
    @Nullable
    public final UUID description;
    public final int renderDistance;
    public final boolean doRenderHand;
    private static final Stack<WorldRenderInfo> renderInfoStack = new Stack();

    public WorldRenderInfo(ClientLevel world, Vec3 cameraPos, @Nullable Matrix4f cameraTransformation, boolean overwriteCameraTransformation, @Nullable UUID description, int renderDistance) {
        this(world, cameraPos, cameraTransformation, overwriteCameraTransformation, description, renderDistance, false);
    }

    public WorldRenderInfo(ClientLevel world, Vec3 cameraPos, @Nullable Matrix4f cameraTransformation, boolean overwriteCameraTransformation, @Nullable UUID description, int renderDistance, boolean doRenderHand) {
        this.world = world;
        this.cameraPos = cameraPos;
        this.cameraTransformation = cameraTransformation;
        this.description = description;
        this.renderDistance = renderDistance;
        this.overwriteCameraTransformation = overwriteCameraTransformation;
        this.doRenderHand = doRenderHand;
    }

    public static void pushRenderInfo(WorldRenderInfo worldRenderInfo) {
        renderInfoStack.push(worldRenderInfo);
    }

    public static void popRenderInfo() {
        renderInfoStack.pop();
    }

    public static void adjustCameraPos(Camera camera) {
        if (!renderInfoStack.isEmpty()) {
            WorldRenderInfo currWorldRenderInfo = renderInfoStack.peek();
            ((IECamera)camera).portal_setPos(currWorldRenderInfo.cameraPos);
        }
    }

    public static void applyAdditionalTransformations(PoseStack matrixStack) {
        for (WorldRenderInfo worldRenderInfo : renderInfoStack) {
            Matrix4f matrix;
            if (worldRenderInfo.overwriteCameraTransformation) {
                matrixStack.m_85850_().m_85861_().m_27624_();
                matrixStack.m_85850_().m_85864_().m_8180_();
            }
            if ((matrix = worldRenderInfo.cameraTransformation) == null) continue;
            matrixStack.m_85850_().m_85861_().m_27644_(matrix);
            Matrix3f normalMatrixMult = new Matrix3f(matrix);
            normalMatrixMult.m_8156_((float)Math.pow(1.0 / (double)Math.abs(normalMatrixMult.m_152786_()), 0.3333333333333333));
            matrixStack.m_85850_().m_85864_().m_8178_(normalMatrixMult);
        }
    }

    public static boolean isRendering() {
        return !renderInfoStack.empty();
    }

    public static int getRenderingLayer() {
        return renderInfoStack.size();
    }

    public static List<UUID> getRenderingDescription() {
        return renderInfoStack.stream().map(renderInfo -> renderInfo.description).collect(Collectors.toList());
    }

    public static int getRenderDistance() {
        if (renderInfoStack.isEmpty()) {
            return Minecraft.m_91087_().f_91066_.m_193772_();
        }
        return WorldRenderInfo.renderInfoStack.peek().renderDistance;
    }
}

