/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.teleportation;

import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.util.Tuple;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.Validate;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.PortalState;
import qouteall.imm_ptl.core.render.context_management.RenderStates;
import qouteall.q_misc_util.Helper;

public class TeleportationUtil {
    public static PortalPointVelocity getPortalPointVelocity(PortalState lastTickState, PortalState thisTickState, double localX, double localY) {
        Vec3 lastThisSidePos = lastTickState.getPointOnSurface(localX, localY);
        Vec3 currentThisSidePos = thisTickState.getPointOnSurface(localX, localY);
        Vec3 thisSideVelocity = currentThisSidePos.m_82546_(lastThisSidePos);
        Vec3 lastOtherSidePos = lastTickState.transformPoint(lastThisSidePos);
        Vec3 currentOtherSidePos = thisTickState.transformPoint(currentThisSidePos);
        Vec3 otherSideVelocity = currentOtherSidePos.m_82546_(lastOtherSidePos);
        return new PortalPointVelocity(thisSideVelocity, otherSideVelocity);
    }

    @Nullable
    public static Teleportation checkStaticTeleportation(Portal portal, Vec3 lastPos, Vec3 currentPos) {
        Vec3 currentLocalPos;
        Vec3 lastLocalPos = portal.transformFromWorldToPortalLocal(lastPos);
        CollisionInfo collisionInfo = TeleportationUtil.checkTeleportationByPortalLocalPos(portal, lastLocalPos, currentLocalPos = portal.transformFromWorldToPortalLocal(currentPos));
        if (collisionInfo == null) {
            return null;
        }
        PortalState portalState = portal.getPortalState();
        return new Teleportation(false, portal, lastPos, currentPos, collisionInfo.portalLocalX, collisionInfo.portalLocalY, collisionInfo.tOfCollision, collisionInfo.collisionPos, portalState, portalState, portalState, portalState, portalState, new PortalPointVelocity(Vec3.f_82478_, Vec3.f_82478_), portal.transformPoint(collisionInfo.collisionPos));
    }

    @Nullable
    public static Teleportation checkDynamicTeleportation(Portal portal, PortalState lastFrameState, PortalState currentFrameState, Vec3 lastFrameEyePos, Vec3 currentFrameEyePos, PortalState lastTickState, PortalState thisTickState, Vec3 lastTickEyePos, Vec3 thisTickEyePos) {
        Vec3 currentLocalPos;
        Vec3 lastLocalPos = lastFrameState.worldPosToPortalLocalPos(lastFrameEyePos);
        CollisionInfo collisionInfo = TeleportationUtil.checkTeleportationByPortalLocalPos(portal, lastLocalPos, currentLocalPos = currentFrameState.worldPosToPortalLocalPos(currentFrameEyePos));
        if (collisionInfo == null) {
            return null;
        }
        PortalPointVelocity portalPointVelocity = TeleportationUtil.getPortalPointVelocity(lastTickState, thisTickState, collisionInfo.portalLocalX, collisionInfo.portalLocalY);
        PortalState collisionPortalState = PortalState.interpolate(lastFrameState, currentFrameState, collisionInfo.tOfCollision, false);
        Vec3 collisionPointMappedToThisFrame = thisTickState.transformPoint(thisTickState.portalLocalPosToWorldPos(new Vec3(collisionInfo.portalLocalX, collisionInfo.portalLocalY, 0.0)));
        Vec3 collisionPointMappedToLastFrame = lastFrameState.transformPoint(lastFrameState.portalLocalPosToWorldPos(new Vec3(collisionInfo.portalLocalX, collisionInfo.portalLocalY, 0.0)));
        Vec3 teleportationCheckpoint = Helper.maxBy(collisionPointMappedToThisFrame, collisionPointMappedToLastFrame, Comparator.comparingDouble(v -> v.m_82546_(portal.getDestPos()).m_82526_(portal.getContentDirection())));
        return new Teleportation(true, portal, lastFrameEyePos, currentFrameEyePos, collisionInfo.portalLocalX, collisionInfo.portalLocalY, collisionInfo.tOfCollision, collisionInfo.collisionPos, collisionPortalState, lastFrameState, currentFrameState, lastTickState, thisTickState, portalPointVelocity, teleportationCheckpoint);
    }

    @Nullable
    private static CollisionInfo checkTeleportationByPortalLocalPos(Portal portal, Vec3 lastLocalPos, Vec3 currentLocalPos) {
        boolean movedThrough;
        boolean bl = movedThrough = lastLocalPos.f_82481_ > 0.0 && currentLocalPos.f_82481_ < 0.0;
        if (!movedThrough) {
            return null;
        }
        Vec3 lineOrigin = lastLocalPos;
        Vec3 lineDirection = currentLocalPos.m_82546_(lastLocalPos);
        double t = Helper.getCollidingT(Vec3.f_82478_, new Vec3(0.0, 0.0, 1.0), lineOrigin, lineDirection);
        Validate.isTrue((t < 1.00001 && t > -1.0E-5 ? 1 : 0) != 0);
        Vec3 collidingPoint = lineOrigin.m_82549_(lineDirection.m_82490_(t));
        boolean inProjection = portal.isLocalXYOnPortal(collidingPoint.f_82479_, collidingPoint.f_82480_);
        if (inProjection) {
            return new CollisionInfo(collidingPoint.f_82479_, collidingPoint.f_82480_, t, portal.transformFromPortalLocalToWorld(collidingPoint));
        }
        return null;
    }

    public static Tuple<Vec3, Vec3> getTransformedLastTickPosAndCurrentTickPos(Teleportation teleportation, Vec3 lastTickPos, Vec3 thisTickPos) {
        if (!teleportation.isDynamic()) {
            Portal portal = teleportation.portal;
            Vec3 newLastTickPos = portal.transformPoint(lastTickPos);
            Vec3 newThisTickPos = portal.transformPoint(thisTickPos);
            return new Tuple((Object)newLastTickPos, (Object)newThisTickPos);
        }
        PortalState lastTickState = teleportation.lastTickState;
        PortalState thisTickState = teleportation.thisTickState;
        Vec3 newOtherSideLastTickPos = lastTickState.transformPoint(lastTickPos);
        Vec3 newOtherSideThisTickPos = thisTickState.transformPoint(thisTickPos);
        float partialTicks = RenderStates.tickDelta;
        Vec3 newImmediateCameraPos = newOtherSideLastTickPos.m_165921_(newOtherSideThisTickPos, (double)partialTicks);
        Vec3 correctImmediateCameraPos = teleportation.collidingPortalState().transformPoint(teleportation.thisFrameEyePos());
        Vec3 deltaVelocity = teleportation.portalPointVelocity().otherSidePointVelocity().m_82546_(teleportation.collidingPortalState().transformVec(teleportation.portalPointVelocity().thisSidePointVelocity()));
        Vec3 offset = correctImmediateCameraPos.m_82546_(newImmediateCameraPos);
        newOtherSideLastTickPos = newOtherSideLastTickPos.m_82549_(offset);
        newOtherSideThisTickPos = newOtherSideThisTickPos.m_82549_(offset);
        PortalState targetingPortalState = teleportation.thisTickState();
        double dot = newOtherSideThisTickPos.m_82546_(targetingPortalState.toPos).m_82526_(targetingPortalState.getContentDirection());
        if (dot < 0.0) {
            Helper.log("Teleported to behind the end-tick portal destination. Corrected.");
            newOtherSideThisTickPos = newOtherSideThisTickPos.m_82549_(targetingPortalState.getContentDirection().m_82490_(-dot + 0.001));
        }
        PortalState thisFrameState = teleportation.thisFrameState();
        newImmediateCameraPos = newOtherSideLastTickPos.m_165921_(newOtherSideThisTickPos, (double)partialTicks);
        dot = newImmediateCameraPos.m_82546_(thisFrameState.toPos).m_82526_(thisFrameState.getContentDirection());
        if (dot < 0.0) {
            Helper.log("Teleported to behind the end-frame portal destination. Corrected.");
            Vec3 offset1 = thisFrameState.getContentDirection().m_82490_(-dot + 0.001);
            newOtherSideThisTickPos = newOtherSideThisTickPos.m_82549_(offset1);
            newOtherSideLastTickPos = newOtherSideLastTickPos.m_82549_(offset1);
        }
        return new Tuple((Object)newOtherSideLastTickPos, (Object)newOtherSideThisTickPos);
    }

    @Deprecated
    private static PortalPointVelocity getConservativePortalPointVelocity(PortalState lastTickState, PortalState thisTickState, Vec3 lastTickPos, Vec3 thisTickPos) {
        List<Vec3> localPoses = List.of(lastTickState.worldPosToPortalLocalPos(lastTickPos), lastTickState.worldPosToPortalLocalPos(thisTickPos), thisTickState.worldPosToPortalLocalPos(lastTickPos), thisTickState.worldPosToPortalLocalPos(thisTickPos));
        List<PortalPointVelocity> portalPointVelocities = localPoses.stream().map(localPos -> TeleportationUtil.getPortalPointVelocity(lastTickState, thisTickState, localPos.f_82479_, localPos.f_82480_)).toList();
        return new PortalPointVelocity(portalPointVelocities.stream().map(v -> v.thisSidePointVelocity).max(Comparator.comparingDouble(p -> p.m_82526_(lastTickState.getNormal()))).orElseThrow(), portalPointVelocities.stream().map(v -> v.otherSidePointVelocity).max(Comparator.comparingDouble(p -> p.m_82526_(thisTickState.getContentDirection()))).orElseThrow());
    }

    public record PortalPointVelocity(Vec3 thisSidePointVelocity, Vec3 otherSidePointVelocity) {
    }

    private record CollisionInfo(double portalLocalX, double portalLocalY, double tOfCollision, Vec3 collisionPos) {
    }

    public record Teleportation(boolean isDynamic, Portal portal, Vec3 lastFrameEyePos, Vec3 thisFrameEyePos, double collidingPosPortalLocalX, double collidingPosPortalLocalY, double tOfCollision, Vec3 collidingPos, PortalState collidingPortalState, PortalState lastFrameState, PortalState thisFrameState, PortalState lastTickState, PortalState thisTickState, PortalPointVelocity portalPointVelocity, Vec3 teleportationCheckpoint) {
    }

    public record PortalPointOffset(Vec3 thisSideOffset, Vec3 otherSideOffse) {
    }
}

