/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.jcm.mod.block;

import com.lx862.jcm.mod.block.base.WallAttachedBlock;
import com.lx862.jcm.mod.data.BlockProperties;
import com.lx862.jcm.mod.util.BlockUtil;
import com.lx862.jcm.mod.util.TextCategory;
import com.lx862.jcm.mod.util.TextUtil;
import com.lx862.jcm.mod.util.VoxelUtil;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.properties.Property;
import org.mtr.mapping.holder.ActionResult;
import org.mtr.mapping.holder.Block;
import org.mtr.mapping.holder.BlockHitResult;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockSettings;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.BlockView;
import org.mtr.mapping.holder.BooleanProperty;
import org.mtr.mapping.holder.Hand;
import org.mtr.mapping.holder.Item;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.Random;
import org.mtr.mapping.holder.ServerWorld;
import org.mtr.mapping.holder.ShapeContext;
import org.mtr.mapping.holder.Text;
import org.mtr.mapping.holder.TextFormatting;
import org.mtr.mapping.holder.VoxelShape;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.tool.HolderBase;
import org.mtr.mod.Items;
import org.mtr.mod.block.IBlock;

public class OperatorButtonBlock
extends WallAttachedBlock {
    private final int poweredDuration;
    public static final BooleanProperty POWERED = BlockProperties.POWERED;

    public OperatorButtonBlock(BlockSettings settings, int poweredDuration) {
        super(settings);
        this.setDefaultState2(this.getDefaultState2().with(new org.mtr.mapping.holder.Property((Property)OperatorButtonBlock.POWERED.data), (Comparable)Boolean.valueOf(false)));
        this.poweredDuration = poweredDuration;
    }

    public VoxelShape getOutlineShape2(BlockState state, BlockView view, BlockPos pos, ShapeContext context) {
        return VoxelUtil.getDirectionalShape16(BlockUtil.getProperty(state, FACING), 5.0, 5.0, 0.0, 11.0, 11.5, 0.2);
    }

    public ActionResult onUse2(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockHitResult hit) {
        if (world.isClient()) {
            return ActionResult.SUCCESS;
        }
        return IBlock.checkHoldingItem((World)world, (PlayerEntity)player, item -> {
            this.setPowered(world, state, pos, true);
            OperatorButtonBlock.scheduleBlockTick((World)world, (BlockPos)pos, (Block)new Block((net.minecraft.world.level.block.Block)this), (int)this.poweredDuration);
        }, () -> player.sendMessage(Text.cast((HolderBase)TextUtil.translatable(TextCategory.HUD, "operator_button.fail", new Object[0]).formatted(TextFormatting.RED)), true), (Item[])new Item[]{Items.DRIVER_KEY.get()});
    }

    public void scheduledTick2(BlockState state, ServerWorld serverWorld, BlockPos pos, Random random) {
        if (((Boolean)state.get(new org.mtr.mapping.holder.Property((Property)OperatorButtonBlock.POWERED.data))).booleanValue()) {
            this.setPowered(World.cast((HolderBase)serverWorld), state, pos, false);
        }
    }

    @Override
    public void addBlockProperties(List<HolderBase<?>> properties) {
        super.addBlockProperties(properties);
        properties.add((HolderBase<?>)POWERED);
    }

    public boolean emitsRedstonePower2(BlockState state) {
        return true;
    }

    public int getWeakRedstonePower2(BlockState state, BlockView world, BlockPos pos, org.mtr.mapping.holder.Direction direction) {
        return BlockUtil.getProperty(state, POWERED) ? 15 : 0;
    }

    public int getStrongRedstonePower2(BlockState state, BlockView world, BlockPos pos, org.mtr.mapping.holder.Direction direction) {
        return BlockUtil.getProperty(state, POWERED) ? 15 : 0;
    }

    private void setPowered(World world, BlockState blockState, BlockPos pos, boolean powered) {
        world.setBlockState(pos, blockState.with(new org.mtr.mapping.holder.Property((Property)OperatorButtonBlock.POWERED.data), (Comparable)Boolean.valueOf(powered)));
        this.updateNearbyBlock(world, pos, org.mtr.mapping.holder.Direction.convert((Direction)((Direction)blockState.get(new org.mtr.mapping.holder.Property((Property)OperatorButtonBlock.FACING.data)))));
    }

    private void updateNearbyBlock(World world, BlockPos pos, org.mtr.mapping.holder.Direction blockFacing) {
        world.updateNeighbors(pos.offset(blockFacing), new Block((net.minecraft.world.level.block.Block)this));
    }
}

