/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.jcm.mod.block;

import com.lx862.jcm.mod.block.ThalesTicketBarrier;
import com.lx862.jcm.mod.block.base.DirectionalBlock;
import com.lx862.jcm.mod.data.BlockProperties;
import com.lx862.jcm.mod.util.BlockUtil;
import com.lx862.jcm.mod.util.VoxelUtil;
import java.util.List;
import net.minecraft.world.level.block.state.properties.Property;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockSettings;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.BlockView;
import org.mtr.mapping.holder.BooleanProperty;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.IntegerProperty;
import org.mtr.mapping.holder.ShapeContext;
import org.mtr.mapping.holder.VoxelShape;
import org.mtr.mapping.holder.VoxelShapes;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.holder.WorldAccess;
import org.mtr.mapping.tool.HolderBase;
import org.mtr.mod.Blocks;
import org.mtr.mod.block.BlockGlassFence;

public class ThalesTicketBarrierBareBlock
extends DirectionalBlock {
    public static final IntegerProperty FENCE_TYPE = BlockProperties.BARRIER_FENCE_TYPE;
    public static final BooleanProperty FLIPPED = BlockProperties.BARRIER_FLIPPED;

    public ThalesTicketBarrierBareBlock(BlockSettings settings) {
        super(settings);
    }

    public VoxelShape getOutlineShape2(BlockState state, BlockView view, BlockPos pos, ShapeContext context) {
        boolean hasFence = BlockUtil.getProperty(state, FENCE_TYPE) != 0;
        boolean flipped = BlockUtil.getProperty(state, FLIPPED);
        VoxelShape mainBarrierShape = VoxelUtil.getDirectionalShape16(BlockUtil.getProperty(state, FACING), 12.0, 0.0, 0.0, 16.0, 16.0, 16.0);
        VoxelShape vx1 = hasFence ? (flipped ? VoxelUtil.getDirectionalShape16(BlockUtil.getProperty(state, FACING), 0.0, 0.0, 13.0, 12.0, 19.0, 16.0) : VoxelUtil.getDirectionalShape16(BlockUtil.getProperty(state, FACING), 0.0, 0.0, 0.0, 12.0, 19.0, 3.0)) : VoxelShapes.empty();
        return VoxelShapes.union((VoxelShape)mainBarrierShape, (VoxelShape)vx1);
    }

    public VoxelShape getCollisionShape2(BlockState state, BlockView view, BlockPos pos, ShapeContext context) {
        boolean hasFence = BlockUtil.getProperty(state, FENCE_TYPE) != 0;
        boolean flipped = BlockUtil.getProperty(state, FLIPPED);
        VoxelShape mainBarrierShape = VoxelUtil.getDirectionalShape16(BlockUtil.getProperty(state, FACING), 12.0, 0.0, 0.0, 16.0, 24.0, 16.0);
        VoxelShape vx1 = hasFence ? (flipped ? VoxelUtil.getDirectionalShape16(BlockUtil.getProperty(state, FACING), 0.0, 0.0, 13.0, 12.0, 24.0, 16.0) : VoxelUtil.getDirectionalShape16(BlockUtil.getProperty(state, FACING), 0.0, 0.0, 0.0, 12.0, 24.0, 3.0)) : VoxelShapes.empty();
        return VoxelShapes.union((VoxelShape)mainBarrierShape, (VoxelShape)vx1);
    }

    public BlockState getStateForNeighborUpdate2(BlockState state, Direction direction, BlockState neighborState, WorldAccess world, BlockPos pos, BlockPos neighborPos) {
        return this.getFenceState(neighborState, direction, state, World.cast((HolderBase)world), pos);
    }

    private BlockState getFenceState(BlockState stateNear, Direction direction, BlockState state, World world, BlockPos pos) {
        BlockPos nextToPos;
        boolean hasBlockNextToFence;
        if (stateNear.getBlock().data instanceof ThalesTicketBarrier || stateNear.getBlock().data instanceof ThalesTicketBarrierBareBlock) {
            return state;
        }
        Direction thisDirection = BlockUtil.getProperty(state, FACING);
        if (stateNear.getBlock().data instanceof BlockGlassFence) {
            boolean flipped;
            Direction nearbyFacing = BlockUtil.getProperty(stateNear, FACING);
            boolean valid = nearbyFacing == thisDirection || nearbyFacing == thisDirection.getOpposite();
            boolean bl = flipped = nearbyFacing != thisDirection;
            if (direction != thisDirection.rotateYClockwise() && direction != thisDirection.rotateYCounterclockwise()) {
                valid = false;
            }
            if (valid) {
                int fenceType = 0;
                if (stateNear.isOf(Blocks.GLASS_FENCE_CIO.get())) {
                    fenceType = 1;
                }
                if (stateNear.isOf(Blocks.GLASS_FENCE_CKT.get())) {
                    fenceType = 2;
                }
                if (stateNear.isOf(Blocks.GLASS_FENCE_HEO.get())) {
                    fenceType = 3;
                }
                if (stateNear.isOf(Blocks.GLASS_FENCE_MOS.get())) {
                    fenceType = 4;
                }
                if (stateNear.isOf(Blocks.GLASS_FENCE_PLAIN.get())) {
                    fenceType = 5;
                }
                if (stateNear.isOf(Blocks.GLASS_FENCE_SHM.get())) {
                    fenceType = 6;
                }
                if (stateNear.isOf(Blocks.GLASS_FENCE_STAINED.get())) {
                    fenceType = 7;
                }
                if (stateNear.isOf(Blocks.GLASS_FENCE_STW.get())) {
                    fenceType = 8;
                }
                if (stateNear.isOf(Blocks.GLASS_FENCE_TSH.get())) {
                    fenceType = 9;
                }
                if (stateNear.isOf(Blocks.GLASS_FENCE_WKS.get())) {
                    fenceType = 10;
                }
                return state.with(new org.mtr.mapping.holder.Property((Property)ThalesTicketBarrierBareBlock.FENCE_TYPE.data), (Comparable)Integer.valueOf(fenceType)).with(new org.mtr.mapping.holder.Property((Property)ThalesTicketBarrierBareBlock.FLIPPED.data), (Comparable)Boolean.valueOf(flipped));
            }
        }
        boolean bl = hasBlockNextToFence = !world.getBlockState(nextToPos = pos.offset(thisDirection.rotateYCounterclockwise())).isAir();
        if (hasBlockNextToFence) {
            return state;
        }
        return state.with(new org.mtr.mapping.holder.Property((Property)ThalesTicketBarrierBareBlock.FENCE_TYPE.data), (Comparable)Integer.valueOf(0));
    }

    @Override
    public void addBlockProperties(List<HolderBase<?>> properties) {
        super.addBlockProperties(properties);
        properties.add((HolderBase<?>)FENCE_TYPE);
        properties.add((HolderBase<?>)FLIPPED);
    }
}

