/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.jcm.mod.block.base;

import com.lx862.jcm.mod.block.base.DirectionalBlock;
import com.lx862.jcm.mod.block.behavior.HorizontalDoubleBlockBehavior;
import com.lx862.jcm.mod.block.behavior.WallAttachedBlockBehavior;
import com.lx862.jcm.mod.util.BlockUtil;
import java.util.List;
import org.mtr.mapping.holder.BlockEntity;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockSettings;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.Blocks;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.ItemPlacementContext;
import org.mtr.mapping.holder.ItemStack;
import org.mtr.mapping.holder.LivingEntity;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.holder.WorldAccess;
import org.mtr.mapping.tool.HolderBase;

public abstract class HorizontalWallAttached2Block
extends DirectionalBlock
implements HorizontalDoubleBlockBehavior {
    public HorizontalWallAttached2Block(BlockSettings settings) {
        super(settings);
    }

    @Override
    public BlockState getPlacementState2(ItemPlacementContext ctx) {
        BlockState superState = super.getPlacementState2(ctx);
        if (superState == null) {
            return null;
        }
        boolean firstBlockAttachable = WallAttachedBlockBehavior.canBePlaced(ctx.getBlockPos(), ctx.getWorld(), BlockUtil.getProperty(superState, FACING));
        boolean secondBlockAttachable = WallAttachedBlockBehavior.canBePlaced(ctx.getBlockPos().offset(BlockUtil.getProperty(superState, FACING).rotateYClockwise()), ctx.getWorld(), BlockUtil.getProperty(superState, FACING));
        return firstBlockAttachable && secondBlockAttachable && HorizontalDoubleBlockBehavior.canBePlaced(ctx) ? super.getPlacementState2(ctx) : null;
    }

    public void onPlaced2(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack itemStack) {
        HorizontalDoubleBlockBehavior.onPlaced(world, state, pos);
    }

    public BlockState getStateForNeighborUpdate2(BlockState state, Direction direction, BlockState neighborState, WorldAccess world, BlockPos pos, BlockPos neighborPos) {
        boolean isLeft = BlockUtil.getProperty(state, IS_LEFT);
        boolean blockAttachable = WallAttachedBlockBehavior.canBePlaced(pos, World.cast((HolderBase)world), BlockUtil.getProperty(state, FACING));
        if (!HorizontalDoubleBlockBehavior.blockIsValid(pos, state, world, isLeft) || !blockAttachable) {
            return Blocks.getAirMapped().getDefaultState();
        }
        return super.getStateForNeighborUpdate2(state, direction, neighborState, world, pos, neighborPos);
    }

    @Override
    protected BlockEntity[] getBlockEntity(BlockState state, World world, BlockPos pos) {
        Direction facing = BlockUtil.getProperty(state, FACING);
        BlockPos otherPos = pos.offset(facing);
        return new BlockEntity[]{BlockUtil.getBlockEntityOrNull(world, pos), BlockUtil.getBlockEntityOrNull(world, otherPos)};
    }

    @Override
    public void addBlockProperties(List<HolderBase<?>> properties) {
        super.addBlockProperties(properties);
        HorizontalDoubleBlockBehavior.addProperties(properties);
    }
}

