/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.jcm.mod.render.block;

import com.lx862.jcm.mod.Constants;
import com.lx862.jcm.mod.block.entity.ButterflyLightBlockEntity;
import com.lx862.jcm.mod.data.BlockProperties;
import com.lx862.jcm.mod.data.JCMClientStats;
import com.lx862.jcm.mod.render.RenderHelper;
import com.lx862.jcm.mod.render.block.JCMBlockEntityRenderer;
import com.lx862.jcm.mod.util.BlockUtil;
import java.util.ArrayList;
import java.util.List;
import org.mtr.core.data.Platform;
import org.mtr.core.operation.ArrivalResponse;
import org.mtr.core.tool.Utilities;
import org.mtr.libraries.it.unimi.dsi.fastutil.longs.LongCollection;
import org.mtr.libraries.it.unimi.dsi.fastutil.longs.LongImmutableList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.RenderLayer;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.BlockEntityRenderer;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mod.InitClient;
import org.mtr.mod.data.ArrivalsCacheClient;

public class ButterflyLightRenderer
extends JCMBlockEntityRenderer<ButterflyLightBlockEntity> {
    private static final Identifier BUTTERFLY_LIGHT_TEXTURE = Constants.id("textures/block/butterfly_light_dotmatrix.png");

    public ButterflyLightRenderer(BlockEntityRenderer.Argument dispatcher) {
        super(dispatcher);
    }

    @Override
    public void renderCurated(ButterflyLightBlockEntity blockEntity, GraphicsHolder graphicsHolder, World world, BlockState state, BlockPos pos, float tickDelta, int light, int i1) {
        Platform closestPlatform;
        int startBlinkingSeconds = blockEntity.getStartBlinkingSeconds();
        Direction facing = BlockUtil.getProperty(state, BlockProperties.FACING);
        ArrayList closestPlatforms = new ArrayList();
        InitClient.findClosePlatform((BlockPos)pos, (int)5, closestPlatforms::add);
        Platform platform = closestPlatform = !closestPlatforms.isEmpty() ? (Platform)closestPlatforms.get(0) : null;
        if (closestPlatform == null) {
            return;
        }
        ObjectArrayList arrivals = ArrivalsCacheClient.INSTANCE.requestArrivals((LongCollection)LongImmutableList.of((long[])new long[]{closestPlatform.getId()}));
        ArrivalResponse firstArrival = (ArrivalResponse)Utilities.getElement((List)arrivals, (int)0);
        if (firstArrival == null) {
            return;
        }
        boolean arrived = firstArrival.getArrival() <= System.currentTimeMillis();
        long dwellLeft = firstArrival.getDeparture() - System.currentTimeMillis();
        if (!arrived) {
            return;
        }
        long secondsLeft = dwellLeft / 1000L;
        if (secondsLeft <= (long)startBlinkingSeconds && JCMClientStats.getGameTick() % 40.0 > 20.0) {
            graphicsHolder.push();
            graphicsHolder.translate(0.5, 0.5, 0.5);
            graphicsHolder.scale(0.0625f, 0.0625f, 0.0625f);
            this.rotateToBlockDirection(graphicsHolder, blockEntity);
            graphicsHolder.rotateZDegrees(180.0f);
            graphicsHolder.translate(-8.0, 3.0, -2.05);
            graphicsHolder.createVertexConsumer(RenderLayer.getBeaconBeam((Identifier)BUTTERFLY_LIGHT_TEXTURE, (boolean)true));
            RenderHelper.drawTexture(graphicsHolder, 2.0f, 0.0f, 4.0f, 12.0f, 5.0f, facing, -1, 0xF000F0);
            graphicsHolder.pop();
        }
    }
}

