/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.jcm.mod.render.block;

import com.lx862.jcm.mod.block.entity.DepartureTimerBlockEntity;
import com.lx862.jcm.mod.data.BlockProperties;
import com.lx862.jcm.mod.render.block.JCMBlockEntityRenderer;
import com.lx862.jcm.mod.render.text.TextInfo;
import com.lx862.jcm.mod.render.text.TextRenderingManager;
import com.lx862.jcm.mod.util.BlockUtil;
import java.util.ArrayList;
import java.util.List;
import org.mtr.core.data.Platform;
import org.mtr.core.operation.ArrivalResponse;
import org.mtr.core.tool.Utilities;
import org.mtr.libraries.it.unimi.dsi.fastutil.longs.LongCollection;
import org.mtr.libraries.it.unimi.dsi.fastutil.longs.LongImmutableList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.BlockEntityRenderer;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mod.InitClient;
import org.mtr.mod.data.ArrivalsCacheClient;

public class DepartureTimerRenderer
extends JCMBlockEntityRenderer<DepartureTimerBlockEntity> {
    public DepartureTimerRenderer(BlockEntityRenderer.Argument dispatcher) {
        super(dispatcher);
    }

    @Override
    public void renderCurated(DepartureTimerBlockEntity blockEntity, GraphicsHolder graphicsHolder, World world, BlockState state, BlockPos pos, float tickDelta, int light, int i1) {
        Platform closestPlatform;
        Direction facing = BlockUtil.getProperty(state, BlockProperties.FACING);
        graphicsHolder.push();
        graphicsHolder.translate(0.5, 0.5, 0.5);
        graphicsHolder.scale(0.018f, 0.018f, 0.018f);
        this.rotateToBlockDirection(graphicsHolder, blockEntity);
        graphicsHolder.rotateZDegrees(180.0f);
        graphicsHolder.translate(-12.5, -2.0, -4.1);
        ArrayList closestPlatforms = new ArrayList();
        InitClient.findClosePlatform((BlockPos)pos, (int)5, closestPlatforms::add);
        Platform platform = closestPlatform = !closestPlatforms.isEmpty() ? (Platform)closestPlatforms.get(0) : null;
        if (closestPlatform == null) {
            return;
        }
        ObjectArrayList arrivals = ArrivalsCacheClient.INSTANCE.requestArrivals((LongCollection)LongImmutableList.of((long[])new long[]{closestPlatform.getId()}));
        ArrivalResponse firstArrival = (ArrivalResponse)Utilities.getElement((List)arrivals, (int)0);
        if (firstArrival == null) {
            return;
        }
        boolean arrived = firstArrival.getArrival() <= System.currentTimeMillis();
        long dwellLeft = Math.abs(firstArrival.getDeparture() - System.currentTimeMillis());
        if (!arrived) {
            return;
        }
        long seconds = dwellLeft / 1000L;
        long mins = seconds / 60L;
        TextRenderingManager.bind(graphicsHolder);
        TextRenderingManager.draw(graphicsHolder, new TextInfo(String.format("%d:%02d", mins % 10L, seconds % 60L)).withColor(-1170893).withFont("jsblock:deptimer"), facing, 0.0, 0.0);
        graphicsHolder.pop();
    }
}

