/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.jcm.mod.render.gui.screen;

import com.lx862.jcm.mod.data.pids.PIDSManager;
import com.lx862.jcm.mod.data.pids.preset.PIDSContext;
import com.lx862.jcm.mod.data.pids.preset.components.base.PIDSComponent;
import com.lx862.jcm.mod.data.pids.preset.components.base.TextComponent;
import com.lx862.jcm.mod.data.pids.preset.components.base.TextureComponent;
import com.lx862.jcm.mod.render.GuiHelper;
import com.lx862.jcm.mod.render.RenderHelper;
import com.lx862.jcm.mod.render.gui.screen.base.TitledScreen;
import com.lx862.jcm.mod.render.text.TextRenderingManager;
import com.lx862.jcm.mod.util.TextUtil;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.gui.components.AbstractWidget;
import org.mtr.core.operation.ArrivalResponse;
import org.mtr.core.serializer.JsonReader;
import org.mtr.core.serializer.ReaderBase;
import org.mtr.libraries.com.google.gson.JsonArray;
import org.mtr.libraries.com.google.gson.JsonElement;
import org.mtr.libraries.com.google.gson.JsonObject;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.mapping.holder.ClickableWidget;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.holder.MutableText;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.ButtonWidgetExtension;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.GuiDrawing;
import org.mtr.mapping.tool.HolderBase;

public class PIDSDemoScreen
extends TitledScreen
implements RenderHelper,
GuiHelper {
    public PIDSDemoScreen() {
        super(true);
    }

    @Override
    public MutableText getScreenTitle() {
        return TextUtil.literal("PIDS Component");
    }

    @Override
    public MutableText getScreenSubtitle() {
        return TextUtil.literal("Test Rendering");
    }

    protected void init2() {
        super.init2();
        int btnWidth = GuiHelper.getButtonWidth((double)this.f_96543_ * 0.6);
        ButtonWidgetExtension btn = new ButtonWidgetExtension((this.f_96543_ - btnWidth) / 2, this.f_96544_ - 30, btnWidth, 20, TextUtil.translatable("gui.done", new Object[0]), b -> this.onClose2());
        this.addChild(new ClickableWidget((AbstractWidget)btn));
    }

    @Override
    public void drawBackground(GraphicsHolder graphicsHolder, int mouseX, int mouseY, float tickDelta) {
        super.drawBackground(graphicsHolder, mouseX, mouseY, tickDelta);
        this.drawPIDS(graphicsHolder, new GuiDrawing(graphicsHolder), tickDelta);
    }

    private void drawPIDS(GraphicsHolder graphicsHolder, GuiDrawing guiDrawing, double tickDelta) {
        JsonObject fakeArrivalsJson = new JsonObject();
        JsonArray fakeArrivalsArrayJson = new JsonArray();
        ObjectArrayList fakeArrivals = new ObjectArrayList();
        for (int i = 0; i < 4; ++i) {
            JsonObject jo = new JsonObject();
            jo.addProperty("destination", "Arrival " + (i + 1));
            jo.addProperty("arrival", (Number)(100L + System.currentTimeMillis() + (long)(i * 10000)));
            jo.addProperty("departure", (Number)(100L + System.currentTimeMillis() + (long)((i + 1) * 10000)));
            jo.addProperty("realtime", Boolean.valueOf(true));
            jo.addProperty("platformName", "2");
            fakeArrivals.add((Object)new ArrivalResponse((ReaderBase)new JsonReader((JsonElement)jo)));
        }
        List<PIDSComponent> components = PIDSManager.getPreset("rv_pids").getComponents((ObjectArrayList<ArrivalResponse>)fakeArrivals, new String[]{"", "", "", ""}, new boolean[]{false, false, false, false}, 0, 0, 150, 80, 4, false);
        List textureComponents = components.stream().filter(e -> e instanceof TextureComponent).collect(Collectors.toList());
        List textComponents = components.stream().filter(e -> e instanceof TextComponent).collect(Collectors.toList());
        PIDSContext pidsContext = new PIDSContext(World.cast((HolderBase)MinecraftClient.getInstance().getWorldMapped()), null, new String[0], (ObjectArrayList<ArrivalResponse>)fakeArrivals, tickDelta);
        for (PIDSComponent component : textureComponents) {
            graphicsHolder.push();
            component.render(graphicsHolder, guiDrawing, Direction.NORTH, pidsContext);
            graphicsHolder.pop();
        }
        graphicsHolder.translate(0.0, 0.0, 0.5);
        TextRenderingManager.bind(graphicsHolder);
        for (PIDSComponent component : textComponents) {
            graphicsHolder.push();
            component.render(graphicsHolder, guiDrawing, Direction.NORTH, pidsContext);
            graphicsHolder.pop();
        }
    }

    public boolean isPauseScreen2() {
        return false;
    }
}

