/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.api.sound;

import com.mojang.blaze3d.audio.OggAudioStream;
import dev.architectury.injectables.annotations.PlatformOnly;
import gg.moonflower.etched.api.record.TrackData;
import gg.moonflower.etched.api.sound.SoundStreamModifier;
import gg.moonflower.etched.api.sound.source.AudioSource;
import gg.moonflower.etched.api.sound.stream.MonoWrapper;
import gg.moonflower.etched.api.sound.stream.RawAudioStream;
import gg.moonflower.etched.api.util.DownloadProgressListener;
import gg.moonflower.etched.api.util.HeaderInputStream;
import gg.moonflower.etched.api.util.Mp3InputStream;
import gg.moonflower.etched.api.util.SeekingStream;
import gg.moonflower.etched.api.util.WaveDataReader;
import gg.moonflower.etched.client.sound.EmptyAudioStream;
import gg.moonflower.etched.client.sound.SoundCache;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.UnsupportedAudioFileException;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.AbstractSoundInstance;
import net.minecraft.client.resources.sounds.Sound;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.AudioStream;
import net.minecraft.client.sounds.LoopingAudioStream;
import net.minecraft.client.sounds.SoundBufferLibrary;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.client.sounds.WeighedSoundEvents;
import net.minecraft.client.sounds.Weighted;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.valueproviders.ConstantFloat;
import net.minecraft.util.valueproviders.SampledFloat;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class AbstractOnlineSoundInstance
extends AbstractSoundInstance {
    private static final Logger LOGGER = LogManager.getLogger();
    private final String url;
    private final String subtitle;
    private final int attenuationDistance;
    private final DownloadProgressListener progressListener;
    private final AudioSource.AudioFileType type;
    private final boolean stereo;

    public AbstractOnlineSoundInstance(String url, @Nullable String subtitle, int attenuationDistance, SoundSource source, DownloadProgressListener progressListener, AudioSource.AudioFileType type, boolean stereo) {
        super(new ResourceLocation("etched", DigestUtils.sha1Hex((String)url)), source, SoundInstance.m_235150_());
        this.url = url;
        this.subtitle = subtitle;
        this.attenuationDistance = attenuationDistance;
        this.progressListener = progressListener;
        this.type = type;
        this.stereo = stereo;
    }

    private static AudioStream getStream(AudioStream stream, Sound sound) {
        return sound instanceof SoundStreamModifier ? ((SoundStreamModifier)sound).modifyStream(stream) : new MonoWrapper(stream);
    }

    public WeighedSoundEvents m_6775_(SoundManager soundManager) {
        WeighedSoundEvents weighedSoundEvents = new WeighedSoundEvents(this.m_7904_(), this.subtitle);
        weighedSoundEvents.m_120451_((Weighted)new OnlineSound(this.m_7904_(), this.url, this.attenuationDistance, this.progressListener, this.type, this.stereo));
        this.f_119570_ = weighedSoundEvents.m_213718_(this.f_235066_);
        return weighedSoundEvents;
    }

    public AbstractOnlineSoundInstance setLoop(boolean loop) {
        this.f_119578_ = loop;
        return this;
    }

    @PlatformOnly(value={"forge"})
    public CompletableFuture<AudioStream> getStream(SoundBufferLibrary loader, Sound sound, boolean repeatInstantly) {
        return this.getStream(loader, repeatInstantly);
    }

    private CompletableFuture<AudioStream> getStream(SoundBufferLibrary loader, boolean repeatInstantly) {
        Sound sound = this.m_5891_();
        if (!(sound instanceof OnlineSound)) {
            return loader.m_120204_(sound.m_119790_(), repeatInstantly);
        }
        OnlineSound onlineSound = (OnlineSound)sound;
        if (TrackData.isLocalSound(onlineSound.getURL())) {
            WeighedSoundEvents weighedSoundEvents = Minecraft.m_91087_().m_91106_().m_120384_(new ResourceLocation(onlineSound.getURL()));
            if (weighedSoundEvents == null) {
                CompletableFuture<AudioStream> future = new CompletableFuture<AudioStream>();
                future.completeExceptionally(new FileNotFoundException("Unable to play unknown soundEvent: " + sound.m_119790_()));
                return future;
            }
            return ((CompletableFuture)loader.m_120204_(weighedSoundEvents.m_213718_(this.f_235066_).m_119790_(), repeatInstantly).thenApply(MonoWrapper::new)).handleAsync((stream, e) -> {
                if (e != null) {
                    e.printStackTrace();
                    onlineSound.getProgressListener().onFail();
                    return EmptyAudioStream.INSTANCE;
                }
                onlineSound.getProgressListener().onSuccess();
                return stream;
            }, (Executor)Util.m_183991_());
        }
        return ((CompletableFuture)((CompletableFuture)SoundCache.getAudioStream(onlineSound.getURL(), onlineSound.getProgressListener(), onlineSound.getAudioFileType()).thenCompose(AudioSource::openStream)).thenApplyAsync(stream -> {
            onlineSound.getProgressListener().progressStartLoading();
            try {
                HeaderInputStream is;
                byte[] readHeader = new byte[8192];
                int read = IOUtils.read((InputStream)stream, (byte[])readHeader);
                if (read < readHeader.length) {
                    byte[] header = new byte[read];
                    System.arraycopy(readHeader, 0, header, 0, header.length);
                    is = new HeaderInputStream(header, (InputStream)stream);
                } else {
                    is = new HeaderInputStream(readHeader, (InputStream)stream);
                }
                try {
                    return AbstractOnlineSoundInstance.getStream((AudioStream)(repeatInstantly ? new LoopingAudioStream(OggAudioStream::new, (InputStream)is) : new OggAudioStream((InputStream)is)), sound);
                }
                catch (Exception e) {
                    LOGGER.debug("Failed to load as OGG", (Throwable)e);
                    ((SeekingStream)is).beginning();
                    try {
                        AudioInputStream ais = WaveDataReader.getAudioInputStream(is);
                        AudioFormat format = ais.getFormat();
                        return AbstractOnlineSoundInstance.getStream((AudioStream)(repeatInstantly ? new LoopingAudioStream(input -> new RawAudioStream(format, input), (InputStream)ais) : new RawAudioStream(format, ais)), sound);
                    }
                    catch (Exception e1) {
                        LOGGER.debug("Failed to load as WAV", (Throwable)e1);
                        ((SeekingStream)is).beginning();
                        try {
                            Mp3InputStream mp3InputStream = new Mp3InputStream(is);
                            return AbstractOnlineSoundInstance.getStream((AudioStream)(repeatInstantly ? new LoopingAudioStream(input -> new RawAudioStream(mp3InputStream.getFormat(), input), (InputStream)mp3InputStream) : new RawAudioStream(mp3InputStream.getFormat(), mp3InputStream)), sound);
                        }
                        catch (Exception e2) {
                            LOGGER.debug("Failed to load as MP3", (Throwable)e2);
                            IOUtils.closeQuietly((InputStream)is);
                            e.printStackTrace();
                            e1.printStackTrace();
                            e2.printStackTrace();
                            throw new CompletionException(new UnsupportedAudioFileException("Could not load as OGG, WAV, OR MP3"));
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new CompletionException(e);
            }
        }, (Executor)Util.m_183991_())).handleAsync((stream, e) -> {
            if (e != null) {
                e.printStackTrace();
                onlineSound.getProgressListener().onFail();
                return EmptyAudioStream.INSTANCE;
            }
            onlineSound.getProgressListener().onSuccess();
            return stream;
        }, (Executor)Util.m_183991_());
    }

    public static class OnlineSound
    extends Sound
    implements SoundStreamModifier {
        private final String url;
        private final DownloadProgressListener progressListener;
        private final AudioSource.AudioFileType type;
        private final boolean stereo;

        public OnlineSound(ResourceLocation location, String url, int attenuationDistance, DownloadProgressListener progressListener, AudioSource.AudioFileType type, boolean stereo) {
            super(location.toString(), (SampledFloat)ConstantFloat.m_146458_((float)1.0f), (SampledFloat)ConstantFloat.m_146458_((float)1.0f), 1, Sound.Type.FILE, true, false, attenuationDistance);
            this.url = url;
            this.progressListener = progressListener;
            this.type = type;
            this.stereo = stereo;
        }

        public String getURL() {
            return this.url;
        }

        public DownloadProgressListener getProgressListener() {
            return this.progressListener;
        }

        public AudioSource.AudioFileType getAudioFileType() {
            return this.type;
        }

        @Override
        public AudioStream modifyStream(AudioStream stream) {
            return this.stereo ? stream : new MonoWrapper(stream);
        }
    }
}

