/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.common.network.play.handler;

import gg.moonflower.etched.api.record.PlayableRecord;
import gg.moonflower.etched.api.sound.SoundTracker;
import gg.moonflower.etched.api.sound.StopListeningSound;
import gg.moonflower.etched.client.screen.AlbumJukeboxScreen;
import gg.moonflower.etched.client.screen.EtchingScreen;
import gg.moonflower.etched.client.screen.RadioScreen;
import gg.moonflower.etched.common.blockentity.AlbumJukeboxBlockEntity;
import gg.moonflower.etched.common.menu.AlbumJukeboxMenu;
import gg.moonflower.etched.common.network.play.ClientboundInvalidEtchUrlPacket;
import gg.moonflower.etched.common.network.play.ClientboundPlayEntityMusicPacket;
import gg.moonflower.etched.common.network.play.ClientboundPlayMusicPacket;
import gg.moonflower.etched.common.network.play.ClientboundSetUrlPacket;
import gg.moonflower.etched.common.network.play.SetAlbumJukeboxTrackPacket;
import gg.moonflower.etched.common.network.play.handler.EtchedClientPlayPacketHandler;
import gg.moonflower.etched.core.mixin.client.LevelRendererAccessor;
import gg.moonflower.pollen.api.network.v1.packet.PollinatedPacketContext;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class EtchedClientPlayPacketHandlerImpl
implements EtchedClientPlayPacketHandler {
    private static final Logger LOGGER = LogManager.getLogger();

    @Override
    public void handlePlayMusicPacket(ClientboundPlayMusicPacket pkt, PollinatedPacketContext ctx) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        SoundManager soundManager = Minecraft.m_91087_().m_91106_();
        Map<BlockPos, SoundInstance> playingRecords = ((LevelRendererAccessor)Minecraft.m_91087_().f_91060_).getPlayingRecords();
        BlockPos pos = pkt.getPos();
        SoundInstance soundInstance = playingRecords.get(pos);
        ctx.enqueueWork(() -> {
            if (soundInstance != null) {
                soundManager.m_120399_(soundInstance);
                playingRecords.remove(pos);
            }
            if (pkt.getTracks().length == 0) {
                return;
            }
            SoundTracker.playBlockRecord(pos, pkt.getTracks(), 0);
        });
    }

    @Override
    public void handlePlayEntityMusicPacket(ClientboundPlayEntityMusicPacket pkt, PollinatedPacketContext ctx) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        int entityId = pkt.getEntityId();
        SoundManager soundManager = Minecraft.m_91087_().m_91106_();
        SoundInstance soundInstance = SoundTracker.getEntitySound(entityId);
        ctx.enqueueWork(() -> {
            if (soundInstance != null) {
                if (soundInstance instanceof StopListeningSound) {
                    ((StopListeningSound)soundInstance).stopListening();
                }
                if (pkt.getAction() == ClientboundPlayEntityMusicPacket.Action.RESTART && soundManager.m_120403_(soundInstance)) {
                    return;
                }
                SoundTracker.setEntitySound(entityId, null);
            }
            if (pkt.getAction() == ClientboundPlayEntityMusicPacket.Action.STOP) {
                return;
            }
            Entity entity = level.m_6815_(entityId);
            if (entity == null) {
                LOGGER.error("Server sent sound for nonexistent entity: " + entityId);
                return;
            }
            ItemStack record = pkt.getRecord();
            if (!PlayableRecord.isPlayableRecord(record)) {
                LOGGER.error("Server sent invalid music disc: " + record);
                return;
            }
            Optional<? extends SoundInstance> sound = ((PlayableRecord)record.m_41720_()).createEntitySound(record, entity, 0);
            if (!sound.isPresent()) {
                LOGGER.error("Server sent invalid music disc: " + record);
                return;
            }
            StopListeningSound entitySound = StopListeningSound.create(sound.get(), () -> Minecraft.m_91087_().m_6937_(() -> {
                SoundTracker.setEntitySound(entityId, null);
                SoundTracker.playEntityRecord(record, entityId, 1, false);
            }));
            SoundTracker.setEntitySound(entityId, entitySound);
        });
    }

    @Override
    public void handleSetInvalidEtch(ClientboundInvalidEtchUrlPacket pkt, PollinatedPacketContext ctx) {
        ctx.enqueueWork(() -> {
            if (Minecraft.m_91087_().f_91080_ instanceof EtchingScreen) {
                EtchingScreen screen = (EtchingScreen)Minecraft.m_91087_().f_91080_;
                screen.setReason(pkt.getException());
            }
        });
    }

    @Override
    public void handleSetUrl(ClientboundSetUrlPacket pkt, PollinatedPacketContext ctx) {
        ctx.enqueueWork(() -> {
            if (Minecraft.m_91087_().f_91080_ instanceof RadioScreen) {
                RadioScreen screen = (RadioScreen)Minecraft.m_91087_().f_91080_;
                screen.receiveUrl(pkt.getUrl());
            }
        });
    }

    @Override
    public void handleSetAlbumJukeboxTrack(SetAlbumJukeboxTrackPacket pkt, PollinatedPacketContext ctx) {
        Minecraft minecraft = Minecraft.m_91087_();
        ctx.enqueueWork(() -> {
            if (minecraft.f_91073_ != null && minecraft.f_91080_ instanceof AlbumJukeboxScreen) {
                AlbumJukeboxScreen screen = (AlbumJukeboxScreen)minecraft.f_91080_;
                BlockPos pos = ((AlbumJukeboxMenu)screen.m_6262_()).getPos();
                if (((AlbumJukeboxMenu)screen.m_6262_()).setPlayingTrack((Level)minecraft.f_91073_, pkt)) {
                    AlbumJukeboxBlockEntity entity = (AlbumJukeboxBlockEntity)Objects.requireNonNull(minecraft.f_91073_.m_7702_(pos));
                    SoundTracker.playAlbum(entity, entity.m_58900_(), minecraft.f_91073_, pos, true);
                }
            }
        });
    }
}

