/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.core.mixin.client;

import com.mojang.blaze3d.audio.Channel;
import com.mojang.blaze3d.audio.SoundBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.client.sounds.AudioStream;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Channel.class})
public class ChannelMixin {
    @Unique
    private final AtomicBoolean loaded = new AtomicBoolean(false);
    @Unique
    private final AtomicBoolean stopped = new AtomicBoolean(false);

    @Inject(method={"stop"}, at={@At(value="HEAD")})
    public void stop(CallbackInfo ci) {
        if (!this.loaded.get()) {
            this.stopped.set(true);
        }
    }

    @Inject(method={"play"}, at={@At(value="HEAD")}, cancellable=true)
    public void play(CallbackInfo ci) {
        if (this.stopped.get()) {
            this.stopped.set(false);
            ci.cancel();
        }
    }

    @Inject(method={"stopped"}, at={@At(value="TAIL")}, cancellable=true)
    public void stopped(CallbackInfoReturnable<Boolean> cir) {
        if (!((Boolean)cir.getReturnValue()).booleanValue() && this.stopped.get()) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"attachStaticBuffer"}, at={@At(value="HEAD")})
    public void attachStaticBuffer(SoundBuffer soundBuffer, CallbackInfo ci) {
        this.loaded.set(true);
    }

    @Inject(method={"attachBufferStream"}, at={@At(value="HEAD")})
    public void attachBufferStream(AudioStream audioStream, CallbackInfo ci) {
        this.loaded.set(true);
    }
}

