/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.core.registry;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import dev.architectury.registry.registries.RegistrySupplier;
import gg.moonflower.etched.core.mixin.StructureTemplatePoolAccessor;
import gg.moonflower.etched.core.registry.EtchedBlocks;
import gg.moonflower.etched.core.registry.EtchedItems;
import gg.moonflower.pollen.api.event.entity.v1.ModifyTradesEvents;
import gg.moonflower.pollen.api.registry.wrapper.v1.PollinatedVillagerRegistry;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.data.worldgen.DesertVillagePools;
import net.minecraft.data.worldgen.PlainVillagePools;
import net.minecraft.data.worldgen.ProcessorLists;
import net.minecraft.data.worldgen.SavannaVillagePools;
import net.minecraft.data.worldgen.SnowyVillagePools;
import net.minecraft.data.worldgen.TaigaVillagePools;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;

public class EtchedVillagers {
    public static final PollinatedVillagerRegistry REGISTRY = PollinatedVillagerRegistry.create((String)"etched");
    public static final RegistrySupplier<PoiType> BARD_POI = REGISTRY.registerPoiType("bard", () -> new PoiType((Set)ImmutableSet.builder().addAll((Iterable)Blocks.f_50065_.m_49965_().m_61056_()).build(), 1, 1));
    public static final RegistrySupplier<VillagerProfession> BARD = REGISTRY.register("bard", () -> new VillagerProfession("etched:bard", poi -> poi.m_203373_(BARD_POI.getId()), poi -> poi.m_203373_(BARD_POI.getId()), ImmutableSet.of(), ImmutableSet.of(), null));

    public static void registerVillages() {
        PlainVillagePools.m_127185_();
        DesertVillagePools.m_126860_();
        SavannaVillagePools.m_127230_();
        SnowyVillagePools.m_127233_();
        TaigaVillagePools.m_127305_();
        EtchedVillagers.createVillagePiece("plains", "bard_house", 1, 2, (Holder<StructureProcessorList>)ProcessorLists.f_127204_, (Holder<StructureProcessorList>)ProcessorLists.f_127199_);
        EtchedVillagers.createVillagePiece("desert", "bard_house", 1, 2, (Holder<StructureProcessorList>)ProcessorLists.f_127203_);
        EtchedVillagers.createVillagePiece("savanna", "bard_house", 1, 4, (Holder<StructureProcessorList>)ProcessorLists.f_127200_);
        EtchedVillagers.createVillagePiece("snowy", "bard_house", 1, 4, (Holder<StructureProcessorList>)ProcessorLists.f_127201_);
        EtchedVillagers.createVillagePiece("taiga", "bard_house", 1, 4, (Holder<StructureProcessorList>)ProcessorLists.f_127204_, (Holder<StructureProcessorList>)ProcessorLists.f_127202_);
    }

    public static void registerTrades() {
        ModifyTradesEvents.VILLAGER.register(context -> {
            if (context.getProfession() != BARD.get()) {
                return;
            }
            ModifyTradesEvents.TradeRegistry tier1 = context.getTrades(1);
            tier1.add((ItemLike)Items.f_42752_, 8, 1, 4, 20, true);
            tier1.add((ItemLike)Items.f_42710_, 8, 1, 4, 20, true);
            tier1.add((ItemLike)Items.f_42701_, 8, 1, 4, 20, true);
            tier1.add((ItemLike)Items.f_186363_, 8, 1, 4, 20, true);
            tier1.add((ItemLike)Items.f_41859_, 1, 2, 16, 2, true);
            tier1.add(EtchedItems.MUSIC_LABEL, 4, 2, 16, 1, false);
            ModifyTradesEvents.TradeRegistry tier2 = context.getTrades(2);
            tier2.add(EtchedItems.BLANK_MUSIC_DISC, 28, 2, 12, 15, false);
            tier2.add(EtchedBlocks.ETCHING_TABLE, 32, 1, 8, 15, false);
            ModifyTradesEvents.TradeRegistry tier3 = context.getTrades(3);
            tier3.add((ItemLike)Blocks.f_50129_, 6, 1, 16, 2, false);
            tier3.add((ItemLike)Blocks.f_50335_, 12, 1, 8, 2, false);
            tier3.add((ItemLike)Blocks.f_50041_, 8, 1, 32, 4, false);
            tier3.add((ItemLike)Blocks.f_50453_, 24, 1, 8, 4, false);
            tier3.add((ItemLike)Blocks.f_50354_, 36, 1, 4, 8, false);
            tier3.add((ItemLike)Blocks.f_50074_, 48, 1, 2, 10, false);
            ModifyTradesEvents.TradeRegistry tier4 = context.getTrades(4);
            tier3.add((ItemLike)Items.f_41984_, 26, 1, 4, 30, false);
            tier4.add(EtchedItems.JUKEBOX_MINECART, 28, 1, 4, 30, false);
            tier4.add(EtchedBlocks.ALBUM_JUKEBOX, 30, 1, 4, 30, false);
            ModifyTradesEvents.TradeRegistry tier5 = context.getTrades(5);
            tier5.add((ItemLike)Items.f_42415_, 8, 1, 8, 40, true);
            tier5.add((ItemLike)Items.f_151049_, 1, 8, 10, 40, true);
            Registry.f_122827_.m_203431_(ItemTags.f_13158_).ifPresent(tag -> tag.m_203614_().forEach(item -> tier5.add((ItemLike)item.m_203334_(), 10, 1, 4, 40, true)));
        });
    }

    private static void createVillagePiece(String village, String name, int houseId, int weight, Holder<StructureProcessorList> zombieProcessor) {
        EtchedVillagers.createVillagePiece(village, name, houseId, weight, (Holder<StructureProcessorList>)ProcessorLists.f_127198_, zombieProcessor);
    }

    private static void createVillagePiece(String village, String name, int houseId, int weight, Holder<StructureProcessorList> normalProcessor, Holder<StructureProcessorList> zombieProcessor) {
        EtchedVillagers.addToPool(new ResourceLocation("village/" + village + "/houses"), new ResourceLocation("etched", "village/" + village + "/houses/" + village + "_" + name + "_" + houseId), normalProcessor, weight);
        EtchedVillagers.addToPool(new ResourceLocation("village/" + village + "/zombie/houses"), new ResourceLocation("etched", "village/" + village + "/houses/" + village + "_" + name + "_" + houseId), zombieProcessor, weight);
    }

    private static void addToPool(ResourceLocation poolId, ResourceLocation pieceId, Holder<StructureProcessorList> processorList, int weight) {
        StructureTemplatePool pool = (StructureTemplatePool)BuiltinRegistries.f_123864_.m_7745_(poolId);
        if (pool == null) {
            return;
        }
        StructurePoolElement piece = (StructurePoolElement)StructurePoolElement.m_210512_((String)pieceId.toString(), processorList).apply(StructureTemplatePool.Projection.RIGID);
        ObjectArrayList<StructurePoolElement> templates = ((StructureTemplatePoolAccessor)pool).getTemplates();
        List<Pair<StructurePoolElement, Integer>> rawTemplates = ((StructureTemplatePoolAccessor)pool).getRawTemplates();
        if (templates == null || rawTemplates == null) {
            return;
        }
        for (int i = 0; i < weight; ++i) {
            templates.add(piece);
        }
        rawTemplates.add((Pair<StructurePoolElement, Integer>)Pair.of((Object)piece, (Object)weight));
    }
}

