/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.decoration.steamWhistle;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.decoration.steamWhistle.WhistleBlock;
import com.simibubi.create.content.decoration.steamWhistle.WhistleExtenderBlock;
import com.simibubi.create.content.decoration.steamWhistle.WhistleSoundInstance;
import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.fluids.tank.FluidTankBlockEntity;
import com.simibubi.create.content.kinetics.steamEngine.SteamJetParticleData;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import java.lang.ref.WeakReference;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;

public class WhistleBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation {
    public WeakReference<FluidTankBlockEntity> source = new WeakReference<Object>(null);
    public LerpedFloat animation = LerpedFloat.linear();
    protected int pitch;
    @OnlyIn(value=Dist.CLIENT)
    protected WhistleSoundInstance soundInstance;

    public WhistleBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.registerAwardables(behaviours, AllAdvancements.STEAM_WHISTLE);
    }

    public void updatePitch() {
        BlockState blockState;
        int newPitch;
        BlockPos currentPos = this.f_58858_.m_7494_();
        for (newPitch = 0; newPitch <= 24 && AllBlocks.STEAM_WHISTLE_EXTENSION.has(blockState = this.f_58857_.m_8055_(currentPos)); newPitch += 2) {
            if (blockState.m_61143_(WhistleExtenderBlock.SHAPE) == WhistleExtenderBlock.WhistleExtenderShape.SINGLE) {
                ++newPitch;
                break;
            }
            currentPos = currentPos.m_7494_();
        }
        if (this.pitch == newPitch) {
            return;
        }
        this.pitch = newPitch;
        this.notifyUpdate();
        FluidTankBlockEntity tank = this.getTank();
        if (tank != null && tank.boiler != null) {
            tank.boiler.checkPipeOrganAdvancement(tank);
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.f_58857_.m_5776_()) {
            if (this.isPowered()) {
                this.award(AllAdvancements.STEAM_WHISTLE);
            }
            return;
        }
        FluidTankBlockEntity tank = this.getTank();
        boolean powered = this.isPowered() && (tank != null && tank.boiler.isActive() && (tank.boiler.passiveHeat || tank.boiler.activeHeat > 0) || this.isVirtual());
        this.animation.chase(powered ? 1.0 : 0.0, powered ? 0.5 : (double)0.4f, powered ? LerpedFloat.Chaser.EXP : LerpedFloat.Chaser.LINEAR);
        this.animation.tickChaser();
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> this.tickAudio(this.getOctave(), powered));
    }

    @Override
    protected void write(CompoundTag tag, boolean clientPacket) {
        tag.m_128405_("Pitch", this.pitch);
        super.write(tag, clientPacket);
    }

    @Override
    protected void read(CompoundTag tag, boolean clientPacket) {
        this.pitch = tag.m_128451_("Pitch");
        super.read(tag, clientPacket);
    }

    @Override
    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        String[] pitches = Lang.translateDirect("generic.notes", new Object[0]).getString().split(";");
        MutableComponent textComponent = Components.literal("    ");
        tooltip.add((Component)textComponent.m_7220_((Component)Lang.translateDirect("generic.pitch", pitches[this.pitch % pitches.length])));
        return true;
    }

    protected boolean isPowered() {
        return this.m_58900_().m_61145_((Property)WhistleBlock.POWERED).orElse(false);
    }

    protected WhistleBlock.WhistleSize getOctave() {
        return this.m_58900_().m_61145_(WhistleBlock.SIZE).orElse(WhistleBlock.WhistleSize.MEDIUM);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void tickAudio(WhistleBlock.WhistleSize size, boolean powered) {
        if (!powered) {
            if (this.soundInstance != null) {
                this.soundInstance.fadeOut();
                this.soundInstance = null;
            }
            return;
        }
        float f = (float)Math.pow(2.0, (double)(-this.pitch) / 12.0);
        boolean particle = this.f_58857_.m_46467_() % 8L == 0L;
        Vec3 eyePosition = Minecraft.m_91087_().f_91075_.m_146892_();
        float maxVolume = (float)Mth.m_14008_((double)((64.0 - eyePosition.m_82554_(Vec3.m_82512_((Vec3i)this.f_58858_))) / 64.0), (double)0.0, (double)1.0);
        if (this.soundInstance == null || this.soundInstance.m_7801_() || this.soundInstance.getOctave() != size) {
            this.soundInstance = new WhistleSoundInstance(size, this.f_58858_);
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)this.soundInstance);
            AllSoundEvents.WHISTLE_CHIFF.playAt(this.f_58857_, (Vec3i)this.f_58858_, maxVolume * 0.175f, size == WhistleBlock.WhistleSize.SMALL ? f + 0.75f : f, false);
            particle = true;
        }
        this.soundInstance.keepAlive();
        this.soundInstance.setPitch(f);
        if (!particle) {
            return;
        }
        Direction facing = this.m_58900_().m_61145_((Property)WhistleBlock.FACING).orElse(Direction.SOUTH);
        float angle = 180.0f + AngleHelper.horizontalAngle(facing);
        Vec3 sizeOffset = VecHelper.rotate(new Vec3(0.0, (double)-0.4f, (double)(0.0625f * (float)size.ordinal())), angle, Direction.Axis.Y);
        Vec3 offset = VecHelper.rotate(new Vec3(0.0, 1.0, 0.75), angle, Direction.Axis.Y);
        Vec3 v = offset.m_82490_((double)0.45f).m_82549_(sizeOffset).m_82549_(Vec3.m_82512_((Vec3i)this.f_58858_));
        Vec3 m = offset.m_82546_(Vec3.m_82528_((Vec3i)facing.m_122436_()).m_82490_(0.75));
        this.f_58857_.m_7106_((ParticleOptions)new SteamJetParticleData(1.0f), v.f_82479_, v.f_82480_, v.f_82481_, m.f_82479_, m.f_82480_, m.f_82481_);
    }

    public int getPitchId() {
        return this.pitch + 100 * this.m_58900_().m_61145_(WhistleBlock.SIZE).orElse(WhistleBlock.WhistleSize.MEDIUM).ordinal();
    }

    public FluidTankBlockEntity getTank() {
        FluidTankBlockEntity tank = (FluidTankBlockEntity)this.source.get();
        if (tank == null || tank.m_58901_()) {
            Direction facing;
            BlockEntity be;
            if (tank != null) {
                this.source = new WeakReference<Object>(null);
            }
            if ((be = this.f_58857_.m_7702_(this.f_58858_.m_121945_(facing = WhistleBlock.getAttachedDirection(this.m_58900_())))) instanceof FluidTankBlockEntity) {
                FluidTankBlockEntity tankBe;
                tank = tankBe = (FluidTankBlockEntity)be;
                this.source = new WeakReference<FluidTankBlockEntity>(tank);
            }
        }
        if (tank == null) {
            return null;
        }
        return tank.getControllerBE();
    }
}

