/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.Create;
import com.simibubi.create.foundation.gui.element.GuiGameElement;
import com.simibubi.create.foundation.gui.element.ScreenElement;
import com.simibubi.create.foundation.ponder.PonderLocalization;
import com.simibubi.create.foundation.ponder.PonderRegistry;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PonderTag
implements ScreenElement {
    public static final PonderTag HIGHLIGHT_ALL = new PonderTag(Create.asResource("_all"));
    private final ResourceLocation id;
    private ResourceLocation icon;
    private ItemStack itemIcon = ItemStack.f_41583_;
    private ItemStack mainItem = ItemStack.f_41583_;

    public PonderTag(ResourceLocation id) {
        this.id = id;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public ItemStack getMainItem() {
        return this.mainItem;
    }

    public String getTitle() {
        return PonderLocalization.getTag(this.id);
    }

    public String getDescription() {
        return PonderLocalization.getTagDescription(this.id);
    }

    public PonderTag defaultLang(String title, String description) {
        PonderLocalization.registerTag(this.id, title, description);
        return this;
    }

    public PonderTag addToIndex() {
        PonderRegistry.TAGS.listTag(this);
        return this;
    }

    public PonderTag icon(ResourceLocation location) {
        this.icon = new ResourceLocation(location.m_135827_(), "textures/ponder/tag/" + location.m_135815_() + ".png");
        return this;
    }

    public PonderTag icon(String location) {
        this.icon = new ResourceLocation(this.id.m_135827_(), "textures/ponder/tag/" + location + ".png");
        return this;
    }

    public PonderTag idAsIcon() {
        return this.icon(this.id);
    }

    public PonderTag item(ItemLike item, boolean useAsIcon, boolean useAsMainItem) {
        if (useAsIcon) {
            this.itemIcon = new ItemStack(item);
        }
        if (useAsMainItem) {
            this.mainItem = new ItemStack(item);
        }
        return this;
    }

    public PonderTag item(ItemLike item) {
        return this.item(item, true, false);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(PoseStack ms, int x, int y) {
        ms.m_85836_();
        ms.m_85837_((double)x, (double)y, 0.0);
        if (this.icon != null) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.icon);
            ms.m_85841_(0.25f, 0.25f, 1.0f);
            GuiComponent.m_93143_((PoseStack)ms, (int)0, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)64, (int)64, (int)64, (int)64);
        } else if (!this.itemIcon.m_41619_()) {
            ms.m_85837_(-2.0, -2.0, 0.0);
            ms.m_85841_(1.25f, 1.25f, 1.25f);
            GuiGameElement.of(this.itemIcon).render(ms);
        }
        ms.m_85849_();
    }
}

