/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.chiseling.modes.draw;

import com.communi.suggestu.scena.core.registries.AbstractCustomRegistryEntry;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import mod.chiselsandbits.api.blockinformation.IBlockInformation;
import mod.chiselsandbits.api.change.IChangeTrackerManager;
import mod.chiselsandbits.api.chiseling.IChiselingContext;
import mod.chiselsandbits.api.chiseling.mode.IChiselMode;
import mod.chiselsandbits.api.inventory.bit.IBitInventory;
import mod.chiselsandbits.api.inventory.management.IBitInventoryManager;
import mod.chiselsandbits.api.item.click.ClickProcessingState;
import mod.chiselsandbits.api.item.withmode.group.IToolModeGroup;
import mod.chiselsandbits.api.multistate.StateEntrySize;
import mod.chiselsandbits.api.multistate.accessor.IAreaAccessor;
import mod.chiselsandbits.api.multistate.accessor.IStateEntryInfo;
import mod.chiselsandbits.api.multistate.accessor.world.IInWorldStateEntryInfo;
import mod.chiselsandbits.api.multistate.accessor.world.IWorldAreaAccessor;
import mod.chiselsandbits.api.multistate.mutator.world.IWorldAreaMutator;
import mod.chiselsandbits.api.util.IBatchMutation;
import mod.chiselsandbits.api.util.LocalStrings;
import mod.chiselsandbits.api.util.RayTracingUtils;
import mod.chiselsandbits.api.util.VectorUtils;
import mod.chiselsandbits.registrars.ModChiselModeGroups;
import mod.chiselsandbits.registrars.ModMetadataKeys;
import mod.chiselsandbits.utils.BitInventoryUtils;
import mod.chiselsandbits.utils.ItemStackUtils;
import mod.chiselsandbits.utils.VoxelShapeUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class DrawnLineChiselMode
extends AbstractCustomRegistryEntry
implements IChiselMode {
    private final MutableComponent displayName;
    private final MutableComponent multiLineDisplayName;
    private final ResourceLocation iconName;

    DrawnLineChiselMode(MutableComponent displayName, MutableComponent multiLineDisplayName, ResourceLocation iconName) {
        this.displayName = displayName;
        this.multiLineDisplayName = multiLineDisplayName;
        this.iconName = iconName;
    }

    @Override
    public boolean isSingleClickUse() {
        return false;
    }

    @Override
    public ClickProcessingState onLeftClickBy(Player playerEntity, IChiselingContext context) {
        return this.processRayTraceIntoContext(playerEntity, context, direction -> Vec3.m_82528_((Vec3i)direction.m_122424_().m_122436_()).m_82559_(StateEntrySize.current().getSizePerHalfBitScalingVector()));
    }

    @Override
    public void onStoppedLeftClicking(Player playerEntity, IChiselingContext context) {
        this.onLeftClickBy(playerEntity, context);
        context.setComplete();
        if (context.isSimulation()) {
            return;
        }
        context.getMutator().ifPresent(mutator -> {
            try (IBatchMutation ignored = mutator.batch(IChangeTrackerManager.getInstance().getChangeTracker(playerEntity));){
                HashMap resultingBitCount = Maps.newHashMap();
                Predicate<IStateEntryInfo> filter = context.getStateFilter().map(factory -> (Predicate)factory.apply(mutator)).orElse(s -> true);
                mutator.inWorldMutableStream().filter(filter).forEach(state -> {
                    IBlockInformation currentState = state.getBlockInformation();
                    if (context.tryDamageItem()) {
                        resultingBitCount.putIfAbsent(currentState, 0);
                        resultingBitCount.computeIfPresent(currentState, (s, currentCount) -> currentCount + 1);
                        state.clear();
                    }
                });
                resultingBitCount.forEach((blockState, count) -> BitInventoryUtils.insertIntoOrSpawn(playerEntity, blockState, count));
            }
        });
    }

    @Override
    public ClickProcessingState onRightClickBy(Player playerEntity, IChiselingContext context) {
        return this.processRayTraceIntoContext(playerEntity, context, direction -> Vec3.m_82528_((Vec3i)direction.m_122436_()).m_82559_(StateEntrySize.current().getSizePerHalfBitScalingVector()));
    }

    @Override
    public void onStoppedRightClicking(Player playerEntity, IChiselingContext context) {
        this.onRightClickBy(playerEntity, context);
        context.setComplete();
        if (context.isSimulation()) {
            return;
        }
        context.getMutator().ifPresent(mutator -> {
            BlockPos heightPos;
            IBlockInformation heldBlockState = ItemStackUtils.getHeldBitBlockInformationFromPlayer(playerEntity);
            if (heldBlockState.isAir()) {
                return;
            }
            Predicate<IStateEntryInfo> filter = context.getStateFilter().map(factory -> (Predicate)factory.apply(mutator)).orElse(s -> true);
            int missingBitCount = (int)mutator.stream().filter(state -> state.getBlockInformation().isAir() && filter.test((IStateEntryInfo)state)).count();
            IBitInventory playerBitInventory = IBitInventoryManager.getInstance().create(playerEntity);
            context.setComplete();
            if (playerBitInventory.canExtract(heldBlockState, missingBitCount) || playerEntity.m_7500_()) {
                if (!playerEntity.m_7500_()) {
                    playerBitInventory.extract(heldBlockState, missingBitCount);
                }
                try (IBatchMutation ignored = mutator.batch(IChangeTrackerManager.getInstance().getChangeTracker(playerEntity));){
                    mutator.inWorldMutableStream().filter(state -> state.getBlockInformation().isAir() && filter.test((IStateEntryInfo)state)).forEach(state -> state.overrideState(heldBlockState));
                }
            } else {
                context.setError(LocalStrings.ChiselAttemptFailedNotEnoughBits.getText(heldBlockState.getBlockState().m_60734_().m_49954_()));
            }
            if (missingBitCount == 0 && (heightPos = new BlockPos(mutator.getInWorldEndPoint())).m_123342_() >= context.getWorld().m_151558_()) {
                MutableComponent component = Component.m_237110_((String)"build.tooHigh", (Object[])new Object[]{context.getWorld().m_151558_() - 1}).m_130940_(ChatFormatting.RED);
                playerEntity.m_213846_((Component)component);
            }
        });
    }

    private ClickProcessingState processRayTraceIntoContext(Player playerEntity, IChiselingContext context, Function<Direction, Vec3> offsetGenerator) {
        HitResult rayTraceResult = RayTracingUtils.rayTracePlayer(playerEntity);
        if (rayTraceResult.m_6662_() != HitResult.Type.BLOCK || !(rayTraceResult instanceof BlockHitResult)) {
            context.setError(LocalStrings.ChiselAttemptFailedNoBlock.getText());
            return ClickProcessingState.DEFAULT;
        }
        BlockHitResult blockRayTraceResult = (BlockHitResult)rayTraceResult;
        Vec3 currentTarget = blockRayTraceResult.m_82450_().m_82549_(offsetGenerator.apply(blockRayTraceResult.m_82434_()));
        Optional<Vec3> anchor = context.getMetadata(ModMetadataKeys.ANCHOR.get());
        if (anchor.isEmpty()) {
            context.setMetadata(ModMetadataKeys.ANCHOR.get(), currentTarget);
            anchor = context.getMetadata(ModMetadataKeys.ANCHOR.get());
        }
        context.resetMutator();
        context.include(anchor.orElseThrow());
        context.include(currentTarget);
        Optional<Vec3> finalAnchor = anchor;
        context.setStateFilter(areaAccessor -> {
            if (areaAccessor instanceof IWorldAreaAccessor) {
                IWorldAreaAccessor worldAreaAccessor = (IWorldAreaAccessor)areaAccessor;
                return new LineAreaFilter((Vec3)finalAnchor.get(), currentTarget);
            }
            return s -> false;
        });
        return ClickProcessingState.ALLOW;
    }

    @Override
    public Optional<IAreaAccessor> getCurrentAccessor(IChiselingContext context) {
        return context.getMutator().map(IAreaAccessor.class::cast);
    }

    @Override
    public VoxelShape getShape(IChiselingContext context) {
        if (context.getMutator().isEmpty()) {
            return Shapes.m_83040_();
        }
        IWorldAreaMutator mutator = context.getMutator().get();
        Optional<Predicate> filter = context.getStateFilter().map(factory -> (Predicate)factory.apply(mutator));
        if (filter.isEmpty()) {
            return Shapes.m_83040_();
        }
        Predicate stateFilter = filter.get();
        if (!(stateFilter instanceof LineAreaFilter)) {
            return Shapes.m_83040_();
        }
        LineAreaFilter lineAreaFilter = (LineAreaFilter)stateFilter;
        BlockPos offset = VectorUtils.invert(new BlockPos(mutator.getInWorldStartPoint()));
        List<Vec3> startPoints = lineAreaFilter.included.stream().map(v -> v.m_82559_(StateEntrySize.current().getSizePerBitScalingVector())).toList();
        return VoxelShapeUtils.batchCombine(Shapes.m_83040_(), BooleanOp.f_82695_, true, startPoints.stream().map(p -> Shapes.m_83048_((double)p.f_82479_, (double)p.f_82480_, (double)p.f_82481_, (double)(p.f_82479_ + (double)StateEntrySize.current().getSizePerBit()), (double)(p.f_82480_ + (double)StateEntrySize.current().getSizePerBit()), (double)(p.f_82481_ + (double)StateEntrySize.current().getSizePerBit()))).collect(Collectors.toList())).m_83216_((double)offset.m_123341_(), (double)offset.m_123342_(), (double)offset.m_123343_());
    }

    @Override
    @NotNull
    public ResourceLocation getIcon() {
        return this.iconName;
    }

    @Override
    @NotNull
    public Optional<IToolModeGroup> getGroup() {
        return Optional.of(ModChiselModeGroups.DRAW);
    }

    @Override
    public Component getDisplayName() {
        return this.displayName;
    }

    @Override
    public Component getMultiLineDisplayName() {
        return this.multiLineDisplayName;
    }

    private static final class LineAreaFilter
    implements Predicate<IStateEntryInfo> {
        private final Vec3 origin;
        private final Vec3 magnitude;
        private final List<Vec3> included;

        private LineAreaFilter(Vec3 startPoint, Vec3 endPoint) {
            this.origin = startPoint.m_82559_(StateEntrySize.current().getBitsPerBlockSideScalingVector());
            this.magnitude = endPoint.m_82559_(StateEntrySize.current().getBitsPerBlockSideScalingVector()).m_82546_(this.origin);
            this.included = this.calculateIncludedPositions();
        }

        @Override
        public boolean test(IStateEntryInfo stateEntryInfo) {
            if (!(stateEntryInfo instanceof IInWorldStateEntryInfo)) {
                return false;
            }
            IInWorldStateEntryInfo inWorldStateEntryInfo = (IInWorldStateEntryInfo)stateEntryInfo;
            return this.included.contains(inWorldStateEntryInfo.getInWorldStartPoint().m_82559_(StateEntrySize.current().getBitsPerBlockSideScalingVector()));
        }

        private List<Vec3> calculateIncludedPositions() {
            double zDist;
            ArrayList<Vec3i> positions = new ArrayList<Vec3i>();
            Vec3 direction = this.magnitude.m_82541_();
            double xLen = direction.m_82490_(1.0 / direction.m_7096_()).m_82553_();
            double yLen = direction.m_82490_(1.0 / direction.m_7098_()).m_82553_();
            double zLen = direction.m_82490_(1.0 / direction.m_7094_()).m_82553_();
            double reach = this.magnitude.m_82553_();
            double distanceFromStart = 0.0;
            Vec3i pos = new Vec3i((int)(direction.m_7096_() > 0.0 ? Math.ceil(this.origin.m_7096_()) - 1.0 : Math.floor(this.origin.m_7096_())), (int)(direction.m_7098_() > 0.0 ? Math.ceil(this.origin.m_7098_()) - 1.0 : Math.floor(this.origin.m_7098_())), (int)(direction.m_7094_() > 0.0 ? Math.ceil(this.origin.m_7094_()) - 1.0 : Math.floor(this.origin.m_7094_())));
            double xOff = direction.m_7096_() > 0.0 ? (double)(1 + pos.m_123341_()) - this.origin.m_7096_() : this.origin.m_7096_() - (double)pos.m_123341_();
            double yOff = direction.m_7098_() > 0.0 ? (double)(1 + pos.m_123342_()) - this.origin.m_7098_() : this.origin.m_7098_() - (double)pos.m_123342_();
            double zOff = direction.m_7094_() > 0.0 ? (double)(1 + pos.m_123343_()) - this.origin.m_7094_() : this.origin.m_7094_() - (double)pos.m_123343_();
            double xDist = Double.isNaN(xLen) ? Double.POSITIVE_INFINITY : Math.abs(xOff * xLen);
            double yDist = Double.isNaN(yLen) ? Double.POSITIVE_INFINITY : Math.abs(yOff * yLen);
            double d = zDist = Double.isNaN(zLen) ? Double.POSITIVE_INFINITY : Math.abs(zOff * zLen);
            while (distanceFromStart <= reach) {
                positions.add(pos);
                if (xDist < yDist) {
                    if (xDist < zDist) {
                        distanceFromStart = xDist;
                        xDist += xLen;
                        pos = pos.m_7918_(direction.m_7096_() > 0.0 ? 1 : -1, 0, 0);
                        continue;
                    }
                    distanceFromStart = zDist;
                    zDist += zLen;
                    pos = pos.m_7918_(0, 0, direction.m_7094_() > 0.0 ? 1 : -1);
                    continue;
                }
                if (yDist < zDist) {
                    distanceFromStart = yDist;
                    yDist += yLen;
                    pos = pos.m_7918_(0, direction.m_7098_() > 0.0 ? 1 : -1, 0);
                    continue;
                }
                distanceFromStart = zDist;
                zDist += zLen;
                pos = pos.m_7918_(0, 0, direction.m_7094_() > 0.0 ? 1 : -1);
            }
            return positions.stream().map(i -> new Vec3((double)i.m_123341_(), (double)i.m_123342_(), (double)i.m_123343_())).collect(Collectors.toList());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof LineAreaFilter)) {
                return false;
            }
            LineAreaFilter that = (LineAreaFilter)o;
            if (!this.origin.equals((Object)that.origin)) {
                return false;
            }
            if (!this.magnitude.equals((Object)that.magnitude)) {
                return false;
            }
            return this.included.equals(that.included);
        }

        public int hashCode() {
            int result = this.origin.hashCode();
            result = 31 * result + this.magnitude.hashCode();
            result = 31 * result + this.included.hashCode();
            return result;
        }
    }
}

