/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GZIPDataCompressionUtils {
    private static final Logger LOGGER = LogManager.getLogger();

    public static CompoundTag compress(Consumer<CompoundTag> uncompressedBuilder) {
        CompoundTag result = new CompoundTag();
        GZIPDataCompressionUtils.compress(result, uncompressedBuilder);
        return result;
    }

    public static void compress(CompoundTag compoundTag, Consumer<CompoundTag> uncompressedBuilder) {
        CompoundTag uncompressedData = new CompoundTag();
        uncompressedBuilder.accept(uncompressedData);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            NbtIo.m_128947_((CompoundTag)uncompressedData, (OutputStream)outputStream);
        }
        catch (IOException e) {
            LOGGER.error("Failed to compress data. Uncompressed data will be stored.", (Throwable)e);
            compoundTag.m_128379_("compressed", false);
            compoundTag.m_128365_("data", (Tag)uncompressedData);
            return;
        }
        byte[] compressedData = outputStream.toByteArray();
        try {
            outputStream.close();
        }
        catch (IOException e) {
            LOGGER.error("Failed to close compression stream!", (Throwable)e);
        }
        compoundTag.m_128379_("compressed", true);
        compoundTag.m_128382_("data", compressedData);
    }

    public static void decompress(CompoundTag input, Consumer<CompoundTag> uncompressedConsumer) {
        CompoundTag uncompressedData;
        if (!input.m_128441_("compressed") || !input.m_128441_("data")) {
            LOGGER.error("Received uncompressed data. This is normal during upgrade procedures, however in any other case this is an error!");
            uncompressedConsumer.accept(input);
            return;
        }
        if (!input.m_128471_("compressed")) {
            LOGGER.error("Received uncompressed data. This is normal during upgrade procedures, however in any other case this is an error!");
            uncompressedConsumer.accept(input.m_128469_("data"));
            return;
        }
        byte[] compressedData = input.m_128463_("data");
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(compressedData);
        try {
            uncompressedData = NbtIo.m_128939_((InputStream)byteArrayInputStream);
        }
        catch (IOException e) {
            LOGGER.error("Failed to decompress data. Uncompressed data will be stored.", (Throwable)e);
            return;
        }
        uncompressedConsumer.accept(uncompressedData);
    }
}

