/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.utils;

import java.util.function.Consumer;
import java.util.function.Function;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NullUtils {
    private NullUtils() {
        throw new IllegalStateException("Can not instantiate an instance of: NullUtils. This is a utility class");
    }

    public static <T> void whenNotNull(@Nullable T obj, @NotNull Consumer<T> executor) {
        if (obj != null) {
            executor.accept(obj);
        }
    }

    @Contract(value="null, _, _ -> param2;")
    public static <T, R> R whenNotNull(@Nullable T obj, @Nullable R defaultValue, @NotNull Function<T, R> executor) {
        if (obj != null) {
            return executor.apply(obj);
        }
        return defaultValue;
    }
}

